// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"log"
	"reflect"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/schema"
	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/validation"
)

func resourceOSConfigPatchDeployment() *schema.Resource {
	return &schema.Resource{
		Create: resourceOSConfigPatchDeploymentCreate,
		Read:   resourceOSConfigPatchDeploymentRead,
		Delete: resourceOSConfigPatchDeploymentDelete,

		Importer: &schema.ResourceImporter{
			State: resourceOSConfigPatchDeploymentImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(20 * time.Minute),
			Delete: schema.DefaultTimeout(20 * time.Minute),
		},

		Schema: map[string]*schema.Schema{
			"instance_filter": {
				Type:        schema.TypeList,
				Required:    true,
				ForceNew:    true,
				Description: `VM instances to patch.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"all": {
							Type:         schema.TypeBool,
							Optional:     true,
							ForceNew:     true,
							Description:  `Target all VM instances in the project. If true, no other criteria is permitted.`,
							AtLeastOneOf: []string{"instance_filter.0.all", "instance_filter.0.group_labels", "instance_filter.0.zones", "instance_filter.0.instances", "instance_filter.0.instance_name_prefixes"},
						},
						"group_labels": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `Targets VM instances matching ANY of these GroupLabels. This allows targeting of disparate groups of VM instances.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"labels": {
										Type:        schema.TypeMap,
										Required:    true,
										ForceNew:    true,
										Description: `Compute Engine instance labels that must be present for a VM instance to be targeted by this filter`,
										Elem:        &schema.Schema{Type: schema.TypeString},
									},
								},
							},
							AtLeastOneOf: []string{"instance_filter.0.all", "instance_filter.0.group_labels", "instance_filter.0.zones", "instance_filter.0.instances", "instance_filter.0.instance_name_prefixes"},
						},
						"instance_name_prefixes": {
							Type:     schema.TypeList,
							Optional: true,
							ForceNew: true,
							Description: `Targets VMs whose name starts with one of these prefixes. Similar to labels, this is another way to group
VMs when targeting configs, for example prefix="prod-".`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
							AtLeastOneOf: []string{"instance_filter.0.all", "instance_filter.0.group_labels", "instance_filter.0.zones", "instance_filter.0.instances", "instance_filter.0.instance_name_prefixes"},
						},
						"instances": {
							Type:     schema.TypeList,
							Optional: true,
							ForceNew: true,
							Description: `Targets any of the VM instances specified. Instances are specified by their URI in the 'form zones/{{zone}}/instances/{{instance_name}}',
'projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}', or
'https://www.googleapis.com/compute/v1/projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}'`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
							AtLeastOneOf: []string{"instance_filter.0.all", "instance_filter.0.group_labels", "instance_filter.0.zones", "instance_filter.0.instances", "instance_filter.0.instance_name_prefixes"},
						},
						"zones": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
							AtLeastOneOf: []string{"instance_filter.0.all", "instance_filter.0.group_labels", "instance_filter.0.zones", "instance_filter.0.instances", "instance_filter.0.instance_name_prefixes"},
						},
					},
				},
			},
			"patch_deployment_id": {
				Type:         schema.TypeString,
				Required:     true,
				ForceNew:     true,
				ValidateFunc: validateRegexp(`(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))`),
				Description: `A name for the patch deployment in the project. When creating a name the following rules apply:
* Must contain only lowercase letters, numbers, and hyphens.
* Must start with a letter.
* Must be between 1-63 characters.
* Must end with a number or a letter.
* Must be unique within the project.`,
			},
			"description": {
				Type:        schema.TypeString,
				Optional:    true,
				ForceNew:    true,
				Description: `Description of the patch deployment. Length of the description is limited to 1024 characters.`,
			},
			"duration": {
				Type:     schema.TypeString,
				Optional: true,
				ForceNew: true,
				Description: `Duration of the patch. After the duration ends, the patch times out.
A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"`,
			},
			"one_time_schedule": {
				Type:        schema.TypeList,
				Optional:    true,
				ForceNew:    true,
				Description: `Schedule a one-time execution.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"execute_time": {
							Type:     schema.TypeString,
							Required: true,
							ForceNew: true,
							Description: `The desired patch job execution time. A timestamp in RFC3339 UTC "Zulu" format,
accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".`,
						},
					},
				},
				ExactlyOneOf: []string{"one_time_schedule", "recurring_schedule"},
			},
			"patch_config": {
				Type:        schema.TypeList,
				Optional:    true,
				ForceNew:    true,
				Description: `Patch configuration that is applied.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"apt": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `Apt update settings. Use this setting to override the default apt patch rules.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"excludes": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `List of packages to exclude from update. These packages will be excluded.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
										AtLeastOneOf: []string{"patch_config.0.apt.0.type", "patch_config.0.apt.0.excludes", "patch_config.0.apt.0.exclusive_packages"},
									},
									"exclusive_packages": {
										Type:     schema.TypeList,
										Optional: true,
										ForceNew: true,
										Description: `An exclusive list of packages to be updated. These are the only packages that will be updated.
If these packages are not installed, they will be ignored. This field cannot be specified with
any other patch configuration fields.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
										AtLeastOneOf: []string{"patch_config.0.apt.0.type", "patch_config.0.apt.0.excludes", "patch_config.0.apt.0.exclusive_packages"},
									},
									"type": {
										Type:         schema.TypeString,
										Optional:     true,
										ForceNew:     true,
										ValidateFunc: validateEnum([]string{"DIST", "UPGRADE", ""}),
										Description:  `By changing the type to DIST, the patching is performed using apt-get dist-upgrade instead. Possible values: ["DIST", "UPGRADE"]`,
										AtLeastOneOf: []string{"patch_config.0.apt.0.type", "patch_config.0.apt.0.excludes", "patch_config.0.apt.0.exclusive_packages"},
									},
								},
							},
							AtLeastOneOf: []string{"patch_config.0.reboot_config", "patch_config.0.apt", "patch_config.0.yum", "patch_config.0.goo", "patch_config.0.zypper", "patch_config.0.windows_update", "patch_config.0.pre_step", "patch_config.0.post_step"},
						},
						"goo": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `goo update settings. Use this setting to override the default goo patch rules.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"enabled": {
										Type:        schema.TypeBool,
										Required:    true,
										ForceNew:    true,
										Description: `goo update settings. Use this setting to override the default goo patch rules.`,
									},
								},
							},
							AtLeastOneOf: []string{"patch_config.0.reboot_config", "patch_config.0.apt", "patch_config.0.yum", "patch_config.0.goo", "patch_config.0.zypper", "patch_config.0.windows_update", "patch_config.0.pre_step", "patch_config.0.post_step"},
						},
						"mig_instances_allowed": {
							Type:        schema.TypeBool,
							Optional:    true,
							ForceNew:    true,
							Description: `Allows the patch job to run on Managed instance groups (MIGs).`,
						},
						"post_step": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `The ExecStep to run after the patch update.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"linux_exec_step_config": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `The ExecStepConfig for all Linux VMs targeted by the PatchJob.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"allowed_success_codes": {
													Type:        schema.TypeList,
													Optional:    true,
													ForceNew:    true,
													Description: `Defaults to [0]. A list of possible return values that the execution can return to indicate a success.`,
													Elem: &schema.Schema{
														Type: schema.TypeInt,
													},
												},
												"gcs_object": {
													Type:        schema.TypeList,
													Optional:    true,
													ForceNew:    true,
													Description: `A Cloud Storage object containing the executable.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"bucket": {
																Type:        schema.TypeString,
																Required:    true,
																ForceNew:    true,
																Description: `Bucket of the Cloud Storage object.`,
															},
															"generation_number": {
																Type:        schema.TypeString,
																Required:    true,
																ForceNew:    true,
																Description: `Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.`,
															},
															"object": {
																Type:        schema.TypeString,
																Required:    true,
																ForceNew:    true,
																Description: `Name of the Cloud Storage object.`,
															},
														},
													},
													ExactlyOneOf: []string{"patch_config.0.post_step.0.linux_exec_step_config.0.local_path", "patch_config.0.post_step.0.linux_exec_step_config.0.gcs_object"},
												},
												"interpreter": {
													Type:         schema.TypeString,
													Optional:     true,
													ForceNew:     true,
													ValidateFunc: validateEnum([]string{"SHELL", "POWERSHELL", ""}),
													Description: `The script interpreter to use to run the script. If no interpreter is specified the script will
be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]`,
												},
												"local_path": {
													Type:         schema.TypeString,
													Optional:     true,
													ForceNew:     true,
													Description:  `An absolute path to the executable on the VM.`,
													ExactlyOneOf: []string{"patch_config.0.post_step.0.linux_exec_step_config.0.local_path", "patch_config.0.post_step.0.linux_exec_step_config.0.gcs_object"},
												},
											},
										},
										AtLeastOneOf: []string{"patch_config.0.post_step.0.linux_exec_step_config", "patch_config.0.post_step.0.windows_exec_step_config"},
									},
									"windows_exec_step_config": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `The ExecStepConfig for all Windows VMs targeted by the PatchJob.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"allowed_success_codes": {
													Type:        schema.TypeList,
													Optional:    true,
													ForceNew:    true,
													Description: `Defaults to [0]. A list of possible return values that the execution can return to indicate a success.`,
													Elem: &schema.Schema{
														Type: schema.TypeInt,
													},
												},
												"gcs_object": {
													Type:        schema.TypeList,
													Optional:    true,
													ForceNew:    true,
													Description: `A Cloud Storage object containing the executable.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"bucket": {
																Type:        schema.TypeString,
																Required:    true,
																ForceNew:    true,
																Description: `Bucket of the Cloud Storage object.`,
															},
															"generation_number": {
																Type:        schema.TypeString,
																Required:    true,
																ForceNew:    true,
																Description: `Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.`,
															},
															"object": {
																Type:        schema.TypeString,
																Required:    true,
																ForceNew:    true,
																Description: `Name of the Cloud Storage object.`,
															},
														},
													},
													ExactlyOneOf: []string{"patch_config.0.post_step.0.windows_exec_step_config.0.local_path", "patch_config.0.post_step.0.windows_exec_step_config.0.gcs_object"},
												},
												"interpreter": {
													Type:         schema.TypeString,
													Optional:     true,
													ForceNew:     true,
													ValidateFunc: validateEnum([]string{"SHELL", "POWERSHELL", ""}),
													Description: `The script interpreter to use to run the script. If no interpreter is specified the script will
be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]`,
												},
												"local_path": {
													Type:         schema.TypeString,
													Optional:     true,
													ForceNew:     true,
													Description:  `An absolute path to the executable on the VM.`,
													ExactlyOneOf: []string{"patch_config.0.post_step.0.windows_exec_step_config.0.local_path", "patch_config.0.post_step.0.windows_exec_step_config.0.gcs_object"},
												},
											},
										},
										AtLeastOneOf: []string{"patch_config.0.post_step.0.linux_exec_step_config", "patch_config.0.post_step.0.windows_exec_step_config"},
									},
								},
							},
							AtLeastOneOf: []string{"patch_config.0.reboot_config", "patch_config.0.apt", "patch_config.0.yum", "patch_config.0.goo", "patch_config.0.zypper", "patch_config.0.windows_update", "patch_config.0.pre_step", "patch_config.0.post_step"},
						},
						"pre_step": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `The ExecStep to run before the patch update.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"linux_exec_step_config": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `The ExecStepConfig for all Linux VMs targeted by the PatchJob.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"allowed_success_codes": {
													Type:        schema.TypeList,
													Optional:    true,
													ForceNew:    true,
													Description: `Defaults to [0]. A list of possible return values that the execution can return to indicate a success.`,
													Elem: &schema.Schema{
														Type: schema.TypeInt,
													},
												},
												"gcs_object": {
													Type:        schema.TypeList,
													Optional:    true,
													ForceNew:    true,
													Description: `A Cloud Storage object containing the executable.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"bucket": {
																Type:        schema.TypeString,
																Required:    true,
																ForceNew:    true,
																Description: `Bucket of the Cloud Storage object.`,
															},
															"generation_number": {
																Type:        schema.TypeString,
																Required:    true,
																ForceNew:    true,
																Description: `Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.`,
															},
															"object": {
																Type:        schema.TypeString,
																Required:    true,
																ForceNew:    true,
																Description: `Name of the Cloud Storage object.`,
															},
														},
													},
													ExactlyOneOf: []string{"patch_config.0.pre_step.0.linux_exec_step_config.0.local_path", "patch_config.0.pre_step.0.linux_exec_step_config.0.gcs_object"},
												},
												"interpreter": {
													Type:         schema.TypeString,
													Optional:     true,
													ForceNew:     true,
													ValidateFunc: validateEnum([]string{"SHELL", "POWERSHELL", ""}),
													Description: `The script interpreter to use to run the script. If no interpreter is specified the script will
be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]`,
												},
												"local_path": {
													Type:         schema.TypeString,
													Optional:     true,
													ForceNew:     true,
													Description:  `An absolute path to the executable on the VM.`,
													ExactlyOneOf: []string{"patch_config.0.pre_step.0.linux_exec_step_config.0.local_path", "patch_config.0.pre_step.0.linux_exec_step_config.0.gcs_object"},
												},
											},
										},
										AtLeastOneOf: []string{"patch_config.0.pre_step.0.linux_exec_step_config", "patch_config.0.pre_step.0.windows_exec_step_config"},
									},
									"windows_exec_step_config": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `The ExecStepConfig for all Windows VMs targeted by the PatchJob.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"allowed_success_codes": {
													Type:        schema.TypeList,
													Optional:    true,
													ForceNew:    true,
													Description: `Defaults to [0]. A list of possible return values that the execution can return to indicate a success.`,
													Elem: &schema.Schema{
														Type: schema.TypeInt,
													},
												},
												"gcs_object": {
													Type:        schema.TypeList,
													Optional:    true,
													ForceNew:    true,
													Description: `A Cloud Storage object containing the executable.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"bucket": {
																Type:        schema.TypeString,
																Required:    true,
																ForceNew:    true,
																Description: `Bucket of the Cloud Storage object.`,
															},
															"generation_number": {
																Type:        schema.TypeString,
																Required:    true,
																ForceNew:    true,
																Description: `Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.`,
															},
															"object": {
																Type:        schema.TypeString,
																Required:    true,
																ForceNew:    true,
																Description: `Name of the Cloud Storage object.`,
															},
														},
													},
													ExactlyOneOf: []string{"patch_config.0.pre_step.0.windows_exec_step_config.0.local_path", "patch_config.0.pre_step.0.windows_exec_step_config.0.gcs_object"},
												},
												"interpreter": {
													Type:         schema.TypeString,
													Optional:     true,
													ForceNew:     true,
													ValidateFunc: validateEnum([]string{"SHELL", "POWERSHELL", ""}),
													Description: `The script interpreter to use to run the script. If no interpreter is specified the script will
be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]`,
												},
												"local_path": {
													Type:         schema.TypeString,
													Optional:     true,
													ForceNew:     true,
													Description:  `An absolute path to the executable on the VM.`,
													ExactlyOneOf: []string{"patch_config.0.pre_step.0.windows_exec_step_config.0.local_path", "patch_config.0.pre_step.0.windows_exec_step_config.0.gcs_object"},
												},
											},
										},
										AtLeastOneOf: []string{"patch_config.0.pre_step.0.linux_exec_step_config", "patch_config.0.pre_step.0.windows_exec_step_config"},
									},
								},
							},
							AtLeastOneOf: []string{"patch_config.0.reboot_config", "patch_config.0.apt", "patch_config.0.yum", "patch_config.0.goo", "patch_config.0.zypper", "patch_config.0.windows_update", "patch_config.0.pre_step", "patch_config.0.post_step"},
						},
						"reboot_config": {
							Type:         schema.TypeString,
							Optional:     true,
							ForceNew:     true,
							ValidateFunc: validateEnum([]string{"DEFAULT", "ALWAYS", "NEVER", ""}),
							Description:  `Post-patch reboot settings. Possible values: ["DEFAULT", "ALWAYS", "NEVER"]`,
							AtLeastOneOf: []string{"patch_config.0.reboot_config", "patch_config.0.apt", "patch_config.0.yum", "patch_config.0.goo", "patch_config.0.zypper", "patch_config.0.windows_update", "patch_config.0.pre_step", "patch_config.0.post_step"},
						},
						"windows_update": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `Windows update settings. Use this setting to override the default Windows patch rules.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"classifications": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `Only apply updates of these windows update classifications. If empty, all updates are applied. Possible values: ["CRITICAL", "SECURITY", "DEFINITION", "DRIVER", "FEATURE_PACK", "SERVICE_PACK", "TOOL", "UPDATE_ROLLUP", "UPDATE"]`,
										Elem: &schema.Schema{
											Type:         schema.TypeString,
											ValidateFunc: validateEnum([]string{"CRITICAL", "SECURITY", "DEFINITION", "DRIVER", "FEATURE_PACK", "SERVICE_PACK", "TOOL", "UPDATE_ROLLUP", "UPDATE"}),
										},
										ExactlyOneOf: []string{"patch_config.0.windows_update.0.classifications", "patch_config.0.windows_update.0.excludes", "patch_config.0.windows_update.0.exclusive_patches"},
									},
									"excludes": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `List of KBs to exclude from update.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
										ExactlyOneOf: []string{"patch_config.0.windows_update.0.classifications", "patch_config.0.windows_update.0.excludes", "patch_config.0.windows_update.0.exclusive_patches"},
									},
									"exclusive_patches": {
										Type:     schema.TypeList,
										Optional: true,
										ForceNew: true,
										Description: `An exclusive list of kbs to be updated. These are the only patches that will be updated.
This field must not be used with other patch configurations.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
										ExactlyOneOf: []string{"patch_config.0.windows_update.0.classifications", "patch_config.0.windows_update.0.excludes", "patch_config.0.windows_update.0.exclusive_patches"},
									},
								},
							},
							AtLeastOneOf: []string{"patch_config.0.reboot_config", "patch_config.0.apt", "patch_config.0.yum", "patch_config.0.goo", "patch_config.0.zypper", "patch_config.0.windows_update", "patch_config.0.pre_step", "patch_config.0.post_step"},
						},
						"yum": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `Yum update settings. Use this setting to override the default yum patch rules.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"excludes": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `List of packages to exclude from update. These packages will be excluded.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
										AtLeastOneOf: []string{"patch_config.0.yum.0.security", "patch_config.0.yum.0.minimal", "patch_config.0.yum.0.excludes", "patch_config.0.yum.0.exclusive_packages"},
									},
									"exclusive_packages": {
										Type:     schema.TypeList,
										Optional: true,
										ForceNew: true,
										Description: `An exclusive list of packages to be updated. These are the only packages that will be updated.
If these packages are not installed, they will be ignored. This field cannot be specified with
any other patch configuration fields.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
										AtLeastOneOf: []string{"patch_config.0.yum.0.security", "patch_config.0.yum.0.minimal", "patch_config.0.yum.0.excludes", "patch_config.0.yum.0.exclusive_packages"},
									},
									"minimal": {
										Type:         schema.TypeBool,
										Optional:     true,
										ForceNew:     true,
										Description:  `Will cause patch to run yum update-minimal instead.`,
										AtLeastOneOf: []string{"patch_config.0.yum.0.security", "patch_config.0.yum.0.minimal", "patch_config.0.yum.0.excludes", "patch_config.0.yum.0.exclusive_packages"},
									},
									"security": {
										Type:         schema.TypeBool,
										Optional:     true,
										ForceNew:     true,
										Description:  `Adds the --security flag to yum update. Not supported on all platforms.`,
										AtLeastOneOf: []string{"patch_config.0.yum.0.security", "patch_config.0.yum.0.minimal", "patch_config.0.yum.0.excludes", "patch_config.0.yum.0.exclusive_packages"},
									},
								},
							},
							AtLeastOneOf: []string{"patch_config.0.reboot_config", "patch_config.0.apt", "patch_config.0.yum", "patch_config.0.goo", "patch_config.0.zypper", "patch_config.0.windows_update", "patch_config.0.pre_step", "patch_config.0.post_step"},
						},
						"zypper": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `zypper update settings. Use this setting to override the default zypper patch rules.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"categories": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `Install only patches with these categories. Common categories include security, recommended, and feature.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
										AtLeastOneOf: []string{"patch_config.0.zypper.0.with_optional", "patch_config.0.zypper.0.with_update", "patch_config.0.zypper.0.categories", "patch_config.0.zypper.0.severities", "patch_config.0.zypper.0.excludes", "patch_config.0.zypper.0.exclusive_patches"},
									},
									"excludes": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `List of packages to exclude from update.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
										AtLeastOneOf: []string{"patch_config.0.zypper.0.with_optional", "patch_config.0.zypper.0.with_update", "patch_config.0.zypper.0.categories", "patch_config.0.zypper.0.severities", "patch_config.0.zypper.0.excludes", "patch_config.0.zypper.0.exclusive_patches"},
									},
									"exclusive_patches": {
										Type:     schema.TypeList,
										Optional: true,
										ForceNew: true,
										Description: `An exclusive list of patches to be updated. These are the only patches that will be installed using 'zypper patch patch:' command.
This field must not be used with any other patch configuration fields.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
										AtLeastOneOf: []string{"patch_config.0.zypper.0.with_optional", "patch_config.0.zypper.0.with_update", "patch_config.0.zypper.0.categories", "patch_config.0.zypper.0.severities", "patch_config.0.zypper.0.excludes", "patch_config.0.zypper.0.exclusive_patches"},
									},
									"severities": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `Install only patches with these severities. Common severities include critical, important, moderate, and low.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
										AtLeastOneOf: []string{"patch_config.0.zypper.0.with_optional", "patch_config.0.zypper.0.with_update", "patch_config.0.zypper.0.categories", "patch_config.0.zypper.0.severities", "patch_config.0.zypper.0.excludes", "patch_config.0.zypper.0.exclusive_patches"},
									},
									"with_optional": {
										Type:         schema.TypeBool,
										Optional:     true,
										ForceNew:     true,
										Description:  `Adds the --with-optional flag to zypper patch.`,
										AtLeastOneOf: []string{"patch_config.0.zypper.0.with_optional", "patch_config.0.zypper.0.with_update", "patch_config.0.zypper.0.categories", "patch_config.0.zypper.0.severities", "patch_config.0.zypper.0.excludes", "patch_config.0.zypper.0.exclusive_patches"},
									},
									"with_update": {
										Type:         schema.TypeBool,
										Optional:     true,
										ForceNew:     true,
										Description:  `Adds the --with-update flag, to zypper patch.`,
										AtLeastOneOf: []string{"patch_config.0.zypper.0.with_optional", "patch_config.0.zypper.0.with_update", "patch_config.0.zypper.0.categories", "patch_config.0.zypper.0.severities", "patch_config.0.zypper.0.excludes", "patch_config.0.zypper.0.exclusive_patches"},
									},
								},
							},
							AtLeastOneOf: []string{"patch_config.0.reboot_config", "patch_config.0.apt", "patch_config.0.yum", "patch_config.0.goo", "patch_config.0.zypper", "patch_config.0.windows_update", "patch_config.0.pre_step", "patch_config.0.post_step"},
						},
					},
				},
			},
			"recurring_schedule": {
				Type:        schema.TypeList,
				Optional:    true,
				ForceNew:    true,
				Description: `Schedule recurring executions.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"time_of_day": {
							Type:        schema.TypeList,
							Required:    true,
							ForceNew:    true,
							Description: `Time of the day to run a recurring deployment.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"hours": {
										Type:         schema.TypeInt,
										Optional:     true,
										ForceNew:     true,
										ValidateFunc: validation.IntBetween(0, 23),
										Description: `Hours of day in 24 hour format. Should be from 0 to 23.
An API may choose to allow the value "24:00:00" for scenarios like business closing time.`,
										AtLeastOneOf: []string{"recurring_schedule.0.time_of_day.0.hours", "recurring_schedule.0.time_of_day.0.minutes", "recurring_schedule.0.time_of_day.0.seconds", "recurring_schedule.0.time_of_day.0.nanos"},
									},
									"minutes": {
										Type:         schema.TypeInt,
										Optional:     true,
										ForceNew:     true,
										ValidateFunc: validation.IntBetween(0, 59),
										Description:  `Minutes of hour of day. Must be from 0 to 59.`,
										AtLeastOneOf: []string{"recurring_schedule.0.time_of_day.0.hours", "recurring_schedule.0.time_of_day.0.minutes", "recurring_schedule.0.time_of_day.0.seconds", "recurring_schedule.0.time_of_day.0.nanos"},
									},
									"nanos": {
										Type:         schema.TypeInt,
										Optional:     true,
										ForceNew:     true,
										ValidateFunc: validation.IntBetween(0, 999999999),
										Description:  `Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.`,
										AtLeastOneOf: []string{"recurring_schedule.0.time_of_day.0.hours", "recurring_schedule.0.time_of_day.0.minutes", "recurring_schedule.0.time_of_day.0.seconds", "recurring_schedule.0.time_of_day.0.nanos"},
									},
									"seconds": {
										Type:         schema.TypeInt,
										Optional:     true,
										ForceNew:     true,
										ValidateFunc: validation.IntBetween(0, 60),
										Description:  `Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.`,
										AtLeastOneOf: []string{"recurring_schedule.0.time_of_day.0.hours", "recurring_schedule.0.time_of_day.0.minutes", "recurring_schedule.0.time_of_day.0.seconds", "recurring_schedule.0.time_of_day.0.nanos"},
									},
								},
							},
						},
						"time_zone": {
							Type:     schema.TypeList,
							Required: true,
							ForceNew: true,
							Description: `Defines the time zone that timeOfDay is relative to. The rules for daylight saving time are
determined by the chosen time zone.`,
							MaxItems: 1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"id": {
										Type:        schema.TypeString,
										Required:    true,
										ForceNew:    true,
										Description: `IANA Time Zone Database time zone, e.g. "America/New_York".`,
									},
									"version": {
										Type:        schema.TypeString,
										Optional:    true,
										ForceNew:    true,
										Description: `IANA Time Zone Database version number, e.g. "2019a".`,
									},
								},
							},
						},
						"end_time": {
							Type:     schema.TypeString,
							Optional: true,
							ForceNew: true,
							Description: `The end time at which a recurring patch deployment schedule is no longer active.
A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".`,
						},
						"monthly": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `Schedule with monthly executions.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"month_day": {
										Type:         schema.TypeInt,
										Optional:     true,
										ForceNew:     true,
										ValidateFunc: validation.IntBetween(-1, 31),
										Description: `One day of the month. 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month.
Months without the target day will be skipped. For example, a schedule to run "every month on the 31st"
will not run in February, April, June, etc.`,
										ExactlyOneOf: []string{"recurring_schedule.0.monthly.0.week_day_of_month", "recurring_schedule.0.monthly.0.month_day"},
									},
									"week_day_of_month": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `Week day in a month.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"day_of_week": {
													Type:         schema.TypeString,
													Required:     true,
													ForceNew:     true,
													ValidateFunc: validateEnum([]string{"MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"}),
													Description:  `A day of the week. Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]`,
												},
												"week_ordinal": {
													Type:         schema.TypeInt,
													Required:     true,
													ForceNew:     true,
													ValidateFunc: validation.IntBetween(-1, 4),
													Description:  `Week number in a month. 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.`,
												},
											},
										},
										ExactlyOneOf: []string{"recurring_schedule.0.monthly.0.week_day_of_month", "recurring_schedule.0.monthly.0.month_day"},
									},
								},
							},
						},
						"start_time": {
							Type:     schema.TypeString,
							Optional: true,
							ForceNew: true,
							Description: `The time that the recurring schedule becomes effective. Defaults to createTime of the patch deployment.
A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".`,
						},
						"weekly": {
							Type:        schema.TypeList,
							Optional:    true,
							ForceNew:    true,
							Description: `Schedule with weekly executions.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"day_of_week": {
										Type:         schema.TypeString,
										Required:     true,
										ForceNew:     true,
										ValidateFunc: validateEnum([]string{"MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"}),
										Description:  `IANA Time Zone Database time zone, e.g. "America/New_York". Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]`,
									},
								},
							},
						},
						"last_execute_time": {
							Type:     schema.TypeString,
							Computed: true,
							Description: `The time the last patch job ran successfully.
A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".`,
						},
						"next_execute_time": {
							Type:     schema.TypeString,
							Computed: true,
							Description: `The time the next patch job is scheduled to run.
A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".`,
						},
					},
				},
				ExactlyOneOf: []string{"one_time_schedule", "recurring_schedule"},
			},
			"rollout": {
				Type:        schema.TypeList,
				Optional:    true,
				ForceNew:    true,
				Description: `Rollout strategy of the patch job.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"disruption_budget": {
							Type:     schema.TypeList,
							Required: true,
							ForceNew: true,
							Description: `The maximum number (or percentage) of VMs per zone to disrupt at any given moment. The number of VMs calculated from multiplying the percentage by the total number of VMs in a zone is rounded up.
During patching, a VM is considered disrupted from the time the agent is notified to begin until patching has completed. This disruption time includes the time to complete reboot and any post-patch steps.
A VM contributes to the disruption budget if its patching operation fails either when applying the patches, running pre or post patch steps, or if it fails to respond with a success notification before timing out. VMs that are not running or do not have an active agent do not count toward this disruption budget.
For zone-by-zone rollouts, if the disruption budget in a zone is exceeded, the patch job stops, because continuing to the next zone requires completion of the patch process in the previous zone.
For example, if the disruption budget has a fixed value of 10, and 8 VMs fail to patch in the current zone, the patch job continues to patch 2 VMs at a time until the zone is completed. When that zone is completed successfully, patching begins with 10 VMs at a time in the next zone. If 10 VMs in the next zone fail to patch, the patch job stops.`,
							MaxItems: 1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"fixed": {
										Type:         schema.TypeInt,
										Optional:     true,
										ForceNew:     true,
										ValidateFunc: validation.IntAtLeast(1),
										Description:  `Specifies a fixed value.`,
										ExactlyOneOf: []string{"rollout.0.disruption_budget.0.fixed", "rollout.0.disruption_budget.0.percentage"},
									},
									"percentage": {
										Type:         schema.TypeInt,
										Optional:     true,
										ForceNew:     true,
										ValidateFunc: validation.IntBetween(0, 100),
										Description:  `Specifies the relative value defined as a percentage, which will be multiplied by a reference value.`,
										ExactlyOneOf: []string{"rollout.0.disruption_budget.0.fixed", "rollout.0.disruption_budget.0.percentage"},
									},
								},
							},
						},
						"mode": {
							Type:         schema.TypeString,
							Required:     true,
							ForceNew:     true,
							ValidateFunc: validateEnum([]string{"ZONE_BY_ZONE", "CONCURRENT_ZONES"}),
							Description:  `Mode of the patch rollout. Possible values: ["ZONE_BY_ZONE", "CONCURRENT_ZONES"]`,
						},
					},
				},
			},
			"create_time": {
				Type:     schema.TypeString,
				Computed: true,
				Description: `Time the patch deployment was created. Timestamp is in RFC3339 text format.
A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".`,
			},
			"last_execute_time": {
				Type:     schema.TypeString,
				Computed: true,
				Description: `The last time a patch job was started by this deployment. Timestamp is in RFC3339 text format.
A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".`,
			},
			"name": {
				Type:     schema.TypeString,
				Computed: true,
				Description: `Unique name for the patch deployment resource in a project.
The patch deployment name is in the form: projects/{project_id}/patchDeployments/{patchDeploymentId}.`,
			},
			"update_time": {
				Type:     schema.TypeString,
				Computed: true,
				Description: `Time the patch deployment was last updated. Timestamp is in RFC3339 text format.
A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".`,
			},
			"project": {
				Type:     schema.TypeString,
				Optional: true,
				Computed: true,
				ForceNew: true,
			},
		},
		UseJSONNumber: true,
	}
}

func resourceOSConfigPatchDeploymentCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	obj := make(map[string]interface{})
	descriptionProp, err := expandOSConfigPatchDeploymentDescription(d.Get("description"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("description"); !isEmptyValue(reflect.ValueOf(descriptionProp)) && (ok || !reflect.DeepEqual(v, descriptionProp)) {
		obj["description"] = descriptionProp
	}
	instanceFilterProp, err := expandOSConfigPatchDeploymentInstanceFilter(d.Get("instance_filter"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("instance_filter"); !isEmptyValue(reflect.ValueOf(instanceFilterProp)) && (ok || !reflect.DeepEqual(v, instanceFilterProp)) {
		obj["instanceFilter"] = instanceFilterProp
	}
	patchConfigProp, err := expandOSConfigPatchDeploymentPatchConfig(d.Get("patch_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("patch_config"); !isEmptyValue(reflect.ValueOf(patchConfigProp)) && (ok || !reflect.DeepEqual(v, patchConfigProp)) {
		obj["patchConfig"] = patchConfigProp
	}
	durationProp, err := expandOSConfigPatchDeploymentDuration(d.Get("duration"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("duration"); !isEmptyValue(reflect.ValueOf(durationProp)) && (ok || !reflect.DeepEqual(v, durationProp)) {
		obj["duration"] = durationProp
	}
	oneTimeScheduleProp, err := expandOSConfigPatchDeploymentOneTimeSchedule(d.Get("one_time_schedule"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("one_time_schedule"); !isEmptyValue(reflect.ValueOf(oneTimeScheduleProp)) && (ok || !reflect.DeepEqual(v, oneTimeScheduleProp)) {
		obj["oneTimeSchedule"] = oneTimeScheduleProp
	}
	recurringScheduleProp, err := expandOSConfigPatchDeploymentRecurringSchedule(d.Get("recurring_schedule"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("recurring_schedule"); !isEmptyValue(reflect.ValueOf(recurringScheduleProp)) && (ok || !reflect.DeepEqual(v, recurringScheduleProp)) {
		obj["recurringSchedule"] = recurringScheduleProp
	}
	rolloutProp, err := expandOSConfigPatchDeploymentRollout(d.Get("rollout"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("rollout"); !isEmptyValue(reflect.ValueOf(rolloutProp)) && (ok || !reflect.DeepEqual(v, rolloutProp)) {
		obj["rollout"] = rolloutProp
	}

	obj, err = resourceOSConfigPatchDeploymentEncoder(d, meta, obj)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{OSConfigBasePath}}projects/{{project}}/patchDeployments?patchDeploymentId={{patch_deployment_id}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new PatchDeployment: %#v", obj)
	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for PatchDeployment: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "POST", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return fmt.Errorf("Error creating PatchDeployment: %s", err)
	}
	if err := d.Set("name", flattenOSConfigPatchDeploymentName(res["name"], d, config)); err != nil {
		return fmt.Errorf(`Error setting computed identity field "name": %s`, err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "{{name}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	// `name` is autogenerated from the api so needs to be set post-create
	name, ok := res["name"]
	if !ok {
		respBody, ok := res["response"]
		if !ok {
			return fmt.Errorf("Create response didn't contain critical fields. Create may not have succeeded.")
		}

		name, ok = respBody.(map[string]interface{})["name"]
		if !ok {
			return fmt.Errorf("Create response didn't contain critical fields. Create may not have succeeded.")
		}
	}
	if err := d.Set("name", name.(string)); err != nil {
		return fmt.Errorf("Error setting name: %s", err)
	}
	d.SetId(name.(string))

	log.Printf("[DEBUG] Finished creating PatchDeployment %q: %#v", d.Id(), res)

	return resourceOSConfigPatchDeploymentRead(d, meta)
}

func resourceOSConfigPatchDeploymentRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{OSConfigBasePath}}{{name}}")
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for PatchDeployment: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequest(config, "GET", billingProject, url, userAgent, nil)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("OSConfigPatchDeployment %q", d.Id()))
	}

	res, err = resourceOSConfigPatchDeploymentDecoder(d, meta, res)
	if err != nil {
		return err
	}

	if res == nil {
		// Decoding the object has resulted in it being gone. It may be marked deleted
		log.Printf("[DEBUG] Removing OSConfigPatchDeployment because it no longer exists.")
		d.SetId("")
		return nil
	}

	if err := d.Set("project", project); err != nil {
		return fmt.Errorf("Error reading PatchDeployment: %s", err)
	}

	if err := d.Set("name", flattenOSConfigPatchDeploymentName(res["name"], d, config)); err != nil {
		return fmt.Errorf("Error reading PatchDeployment: %s", err)
	}
	if err := d.Set("description", flattenOSConfigPatchDeploymentDescription(res["description"], d, config)); err != nil {
		return fmt.Errorf("Error reading PatchDeployment: %s", err)
	}
	if err := d.Set("instance_filter", flattenOSConfigPatchDeploymentInstanceFilter(res["instanceFilter"], d, config)); err != nil {
		return fmt.Errorf("Error reading PatchDeployment: %s", err)
	}
	if err := d.Set("patch_config", flattenOSConfigPatchDeploymentPatchConfig(res["patchConfig"], d, config)); err != nil {
		return fmt.Errorf("Error reading PatchDeployment: %s", err)
	}
	if err := d.Set("duration", flattenOSConfigPatchDeploymentDuration(res["duration"], d, config)); err != nil {
		return fmt.Errorf("Error reading PatchDeployment: %s", err)
	}
	if err := d.Set("create_time", flattenOSConfigPatchDeploymentCreateTime(res["createTime"], d, config)); err != nil {
		return fmt.Errorf("Error reading PatchDeployment: %s", err)
	}
	if err := d.Set("update_time", flattenOSConfigPatchDeploymentUpdateTime(res["updateTime"], d, config)); err != nil {
		return fmt.Errorf("Error reading PatchDeployment: %s", err)
	}
	if err := d.Set("last_execute_time", flattenOSConfigPatchDeploymentLastExecuteTime(res["lastExecuteTime"], d, config)); err != nil {
		return fmt.Errorf("Error reading PatchDeployment: %s", err)
	}
	if err := d.Set("one_time_schedule", flattenOSConfigPatchDeploymentOneTimeSchedule(res["oneTimeSchedule"], d, config)); err != nil {
		return fmt.Errorf("Error reading PatchDeployment: %s", err)
	}
	if err := d.Set("recurring_schedule", flattenOSConfigPatchDeploymentRecurringSchedule(res["recurringSchedule"], d, config)); err != nil {
		return fmt.Errorf("Error reading PatchDeployment: %s", err)
	}
	if err := d.Set("rollout", flattenOSConfigPatchDeploymentRollout(res["rollout"], d, config)); err != nil {
		return fmt.Errorf("Error reading PatchDeployment: %s", err)
	}

	return nil
}

func resourceOSConfigPatchDeploymentDelete(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for PatchDeployment: %s", err)
	}
	billingProject = project

	url, err := replaceVars(d, config, "{{OSConfigBasePath}}{{name}}")
	if err != nil {
		return err
	}

	var obj map[string]interface{}
	log.Printf("[DEBUG] Deleting PatchDeployment %q", d.Id())

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "DELETE", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutDelete))
	if err != nil {
		return handleNotFoundError(err, d, "PatchDeployment")
	}

	log.Printf("[DEBUG] Finished deleting PatchDeployment %q: %#v", d.Id(), res)
	return nil
}

func resourceOSConfigPatchDeploymentImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {

	config := meta.(*Config)

	// current import_formats can't import fields with forward slashes in their value
	if err := parseImportId([]string{"(?P<project>[^ ]+) (?P<name>[^ ]+)", "(?P<name>[^ ]+)"}, d, config); err != nil {
		return nil, err
	}

	return []*schema.ResourceData{d}, nil
}

func flattenOSConfigPatchDeploymentName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentDescription(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentInstanceFilter(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["all"] =
		flattenOSConfigPatchDeploymentInstanceFilterAll(original["all"], d, config)
	transformed["group_labels"] =
		flattenOSConfigPatchDeploymentInstanceFilterGroupLabels(original["groupLabels"], d, config)
	transformed["zones"] =
		flattenOSConfigPatchDeploymentInstanceFilterZones(original["zones"], d, config)
	transformed["instances"] =
		flattenOSConfigPatchDeploymentInstanceFilterInstances(original["instances"], d, config)
	transformed["instance_name_prefixes"] =
		flattenOSConfigPatchDeploymentInstanceFilterInstanceNamePrefixes(original["instanceNamePrefixes"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentInstanceFilterAll(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentInstanceFilterGroupLabels(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"labels": flattenOSConfigPatchDeploymentInstanceFilterGroupLabelsLabels(original["labels"], d, config),
		})
	}
	return transformed
}
func flattenOSConfigPatchDeploymentInstanceFilterGroupLabelsLabels(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentInstanceFilterZones(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentInstanceFilterInstances(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentInstanceFilterInstanceNamePrefixes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["mig_instances_allowed"] =
		flattenOSConfigPatchDeploymentPatchConfigMigInstancesAllowed(original["migInstancesAllowed"], d, config)
	transformed["reboot_config"] =
		flattenOSConfigPatchDeploymentPatchConfigRebootConfig(original["rebootConfig"], d, config)
	transformed["apt"] =
		flattenOSConfigPatchDeploymentPatchConfigApt(original["apt"], d, config)
	transformed["yum"] =
		flattenOSConfigPatchDeploymentPatchConfigYum(original["yum"], d, config)
	transformed["goo"] =
		flattenOSConfigPatchDeploymentPatchConfigGoo(original["goo"], d, config)
	transformed["zypper"] =
		flattenOSConfigPatchDeploymentPatchConfigZypper(original["zypper"], d, config)
	transformed["windows_update"] =
		flattenOSConfigPatchDeploymentPatchConfigWindowsUpdate(original["windowsUpdate"], d, config)
	transformed["pre_step"] =
		flattenOSConfigPatchDeploymentPatchConfigPreStep(original["preStep"], d, config)
	transformed["post_step"] =
		flattenOSConfigPatchDeploymentPatchConfigPostStep(original["postStep"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentPatchConfigMigInstancesAllowed(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigRebootConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigApt(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["type"] =
		flattenOSConfigPatchDeploymentPatchConfigAptType(original["type"], d, config)
	transformed["excludes"] =
		flattenOSConfigPatchDeploymentPatchConfigAptExcludes(original["excludes"], d, config)
	transformed["exclusive_packages"] =
		flattenOSConfigPatchDeploymentPatchConfigAptExclusivePackages(original["exclusivePackages"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentPatchConfigAptType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigAptExcludes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigAptExclusivePackages(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigYum(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["security"] =
		flattenOSConfigPatchDeploymentPatchConfigYumSecurity(original["security"], d, config)
	transformed["minimal"] =
		flattenOSConfigPatchDeploymentPatchConfigYumMinimal(original["minimal"], d, config)
	transformed["excludes"] =
		flattenOSConfigPatchDeploymentPatchConfigYumExcludes(original["excludes"], d, config)
	transformed["exclusive_packages"] =
		flattenOSConfigPatchDeploymentPatchConfigYumExclusivePackages(original["exclusivePackages"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentPatchConfigYumSecurity(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigYumMinimal(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigYumExcludes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigYumExclusivePackages(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigGoo(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["enabled"] =
		flattenOSConfigPatchDeploymentPatchConfigGooEnabled(original["enabled"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentPatchConfigGooEnabled(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigZypper(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["with_optional"] =
		flattenOSConfigPatchDeploymentPatchConfigZypperWithOptional(original["withOptional"], d, config)
	transformed["with_update"] =
		flattenOSConfigPatchDeploymentPatchConfigZypperWithUpdate(original["withUpdate"], d, config)
	transformed["categories"] =
		flattenOSConfigPatchDeploymentPatchConfigZypperCategories(original["categories"], d, config)
	transformed["severities"] =
		flattenOSConfigPatchDeploymentPatchConfigZypperSeverities(original["severities"], d, config)
	transformed["excludes"] =
		flattenOSConfigPatchDeploymentPatchConfigZypperExcludes(original["excludes"], d, config)
	transformed["exclusive_patches"] =
		flattenOSConfigPatchDeploymentPatchConfigZypperExclusivePatches(original["exclusivePatches"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentPatchConfigZypperWithOptional(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigZypperWithUpdate(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigZypperCategories(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigZypperSeverities(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigZypperExcludes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigZypperExclusivePatches(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigWindowsUpdate(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["classifications"] =
		flattenOSConfigPatchDeploymentPatchConfigWindowsUpdateClassifications(original["classifications"], d, config)
	transformed["excludes"] =
		flattenOSConfigPatchDeploymentPatchConfigWindowsUpdateExcludes(original["excludes"], d, config)
	transformed["exclusive_patches"] =
		flattenOSConfigPatchDeploymentPatchConfigWindowsUpdateExclusivePatches(original["exclusivePatches"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentPatchConfigWindowsUpdateClassifications(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigWindowsUpdateExcludes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigWindowsUpdateExclusivePatches(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPreStep(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["linux_exec_step_config"] =
		flattenOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig(original["linuxExecStepConfig"], d, config)
	transformed["windows_exec_step_config"] =
		flattenOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig(original["windowsExecStepConfig"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["allowed_success_codes"] =
		flattenOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigAllowedSuccessCodes(original["allowedSuccessCodes"], d, config)
	transformed["interpreter"] =
		flattenOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigInterpreter(original["interpreter"], d, config)
	transformed["local_path"] =
		flattenOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigLocalPath(original["localPath"], d, config)
	transformed["gcs_object"] =
		flattenOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject(original["gcsObject"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigAllowedSuccessCodes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigInterpreter(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigLocalPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["bucket"] =
		flattenOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectBucket(original["bucket"], d, config)
	transformed["object"] =
		flattenOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectObject(original["object"], d, config)
	transformed["generation_number"] =
		flattenOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectGenerationNumber(original["generationNumber"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectBucket(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectObject(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectGenerationNumber(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["allowed_success_codes"] =
		flattenOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigAllowedSuccessCodes(original["allowedSuccessCodes"], d, config)
	transformed["interpreter"] =
		flattenOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigInterpreter(original["interpreter"], d, config)
	transformed["local_path"] =
		flattenOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigLocalPath(original["localPath"], d, config)
	transformed["gcs_object"] =
		flattenOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject(original["gcsObject"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigAllowedSuccessCodes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigInterpreter(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigLocalPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["bucket"] =
		flattenOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectBucket(original["bucket"], d, config)
	transformed["object"] =
		flattenOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectObject(original["object"], d, config)
	transformed["generation_number"] =
		flattenOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectGenerationNumber(original["generationNumber"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectBucket(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectObject(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectGenerationNumber(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPostStep(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["linux_exec_step_config"] =
		flattenOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig(original["linuxExecStepConfig"], d, config)
	transformed["windows_exec_step_config"] =
		flattenOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig(original["windowsExecStepConfig"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["allowed_success_codes"] =
		flattenOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigAllowedSuccessCodes(original["allowedSuccessCodes"], d, config)
	transformed["interpreter"] =
		flattenOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigInterpreter(original["interpreter"], d, config)
	transformed["local_path"] =
		flattenOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigLocalPath(original["localPath"], d, config)
	transformed["gcs_object"] =
		flattenOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject(original["gcsObject"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigAllowedSuccessCodes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigInterpreter(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigLocalPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["bucket"] =
		flattenOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectBucket(original["bucket"], d, config)
	transformed["object"] =
		flattenOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectObject(original["object"], d, config)
	transformed["generation_number"] =
		flattenOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectGenerationNumber(original["generationNumber"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectBucket(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectObject(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectGenerationNumber(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["allowed_success_codes"] =
		flattenOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigAllowedSuccessCodes(original["allowedSuccessCodes"], d, config)
	transformed["interpreter"] =
		flattenOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigInterpreter(original["interpreter"], d, config)
	transformed["local_path"] =
		flattenOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigLocalPath(original["localPath"], d, config)
	transformed["gcs_object"] =
		flattenOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject(original["gcsObject"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigAllowedSuccessCodes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigInterpreter(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigLocalPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["bucket"] =
		flattenOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectBucket(original["bucket"], d, config)
	transformed["object"] =
		flattenOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectObject(original["object"], d, config)
	transformed["generation_number"] =
		flattenOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectGenerationNumber(original["generationNumber"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectBucket(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectObject(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectGenerationNumber(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentDuration(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentCreateTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentUpdateTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentLastExecuteTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentOneTimeSchedule(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["execute_time"] =
		flattenOSConfigPatchDeploymentOneTimeScheduleExecuteTime(original["executeTime"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentOneTimeScheduleExecuteTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentRecurringSchedule(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["time_zone"] =
		flattenOSConfigPatchDeploymentRecurringScheduleTimeZone(original["timeZone"], d, config)
	transformed["start_time"] =
		flattenOSConfigPatchDeploymentRecurringScheduleStartTime(original["startTime"], d, config)
	transformed["end_time"] =
		flattenOSConfigPatchDeploymentRecurringScheduleEndTime(original["endTime"], d, config)
	transformed["time_of_day"] =
		flattenOSConfigPatchDeploymentRecurringScheduleTimeOfDay(original["timeOfDay"], d, config)
	transformed["last_execute_time"] =
		flattenOSConfigPatchDeploymentRecurringScheduleLastExecuteTime(original["lastExecuteTime"], d, config)
	transformed["next_execute_time"] =
		flattenOSConfigPatchDeploymentRecurringScheduleNextExecuteTime(original["nextExecuteTime"], d, config)
	transformed["weekly"] =
		flattenOSConfigPatchDeploymentRecurringScheduleWeekly(original["weekly"], d, config)
	transformed["monthly"] =
		flattenOSConfigPatchDeploymentRecurringScheduleMonthly(original["monthly"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentRecurringScheduleTimeZone(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["id"] =
		flattenOSConfigPatchDeploymentRecurringScheduleTimeZoneId(original["id"], d, config)
	transformed["version"] =
		flattenOSConfigPatchDeploymentRecurringScheduleTimeZoneVersion(original["version"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentRecurringScheduleTimeZoneId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentRecurringScheduleTimeZoneVersion(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentRecurringScheduleStartTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentRecurringScheduleEndTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentRecurringScheduleTimeOfDay(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	transformed := make(map[string]interface{})
	transformed["hours"] =
		flattenOSConfigPatchDeploymentRecurringScheduleTimeOfDayHours(original["hours"], d, config)
	transformed["minutes"] =
		flattenOSConfigPatchDeploymentRecurringScheduleTimeOfDayMinutes(original["minutes"], d, config)
	transformed["seconds"] =
		flattenOSConfigPatchDeploymentRecurringScheduleTimeOfDaySeconds(original["seconds"], d, config)
	transformed["nanos"] =
		flattenOSConfigPatchDeploymentRecurringScheduleTimeOfDayNanos(original["nanos"], d, config)
	return []interface{}{transformed}
}

func flattenOSConfigPatchDeploymentRecurringScheduleTimeOfDayHours(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenOSConfigPatchDeploymentRecurringScheduleTimeOfDayMinutes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenOSConfigPatchDeploymentRecurringScheduleTimeOfDaySeconds(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenOSConfigPatchDeploymentRecurringScheduleTimeOfDayNanos(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenOSConfigPatchDeploymentRecurringScheduleLastExecuteTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentRecurringScheduleNextExecuteTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentRecurringScheduleWeekly(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["day_of_week"] =
		flattenOSConfigPatchDeploymentRecurringScheduleWeeklyDayOfWeek(original["dayOfWeek"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentRecurringScheduleWeeklyDayOfWeek(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentRecurringScheduleMonthly(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["week_day_of_month"] =
		flattenOSConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth(original["weekDayOfMonth"], d, config)
	transformed["month_day"] =
		flattenOSConfigPatchDeploymentRecurringScheduleMonthlyMonthDay(original["monthDay"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["week_ordinal"] =
		flattenOSConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthWeekOrdinal(original["weekOrdinal"], d, config)
	transformed["day_of_week"] =
		flattenOSConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthDayOfWeek(original["dayOfWeek"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthWeekOrdinal(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenOSConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthDayOfWeek(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentRecurringScheduleMonthlyMonthDay(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenOSConfigPatchDeploymentRollout(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["mode"] =
		flattenOSConfigPatchDeploymentRolloutMode(original["mode"], d, config)
	transformed["disruption_budget"] =
		flattenOSConfigPatchDeploymentRolloutDisruptionBudget(original["disruptionBudget"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentRolloutMode(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigPatchDeploymentRolloutDisruptionBudget(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["fixed"] =
		flattenOSConfigPatchDeploymentRolloutDisruptionBudgetFixed(original["fixed"], d, config)
	transformed["percentage"] =
		flattenOSConfigPatchDeploymentRolloutDisruptionBudgetPercentage(original["percent"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigPatchDeploymentRolloutDisruptionBudgetFixed(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenOSConfigPatchDeploymentRolloutDisruptionBudgetPercentage(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func expandOSConfigPatchDeploymentDescription(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentInstanceFilter(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedAll, err := expandOSConfigPatchDeploymentInstanceFilterAll(original["all"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAll); val.IsValid() && !isEmptyValue(val) {
		transformed["all"] = transformedAll
	}

	transformedGroupLabels, err := expandOSConfigPatchDeploymentInstanceFilterGroupLabels(original["group_labels"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGroupLabels); val.IsValid() && !isEmptyValue(val) {
		transformed["groupLabels"] = transformedGroupLabels
	}

	transformedZones, err := expandOSConfigPatchDeploymentInstanceFilterZones(original["zones"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedZones); val.IsValid() && !isEmptyValue(val) {
		transformed["zones"] = transformedZones
	}

	transformedInstances, err := expandOSConfigPatchDeploymentInstanceFilterInstances(original["instances"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInstances); val.IsValid() && !isEmptyValue(val) {
		transformed["instances"] = transformedInstances
	}

	transformedInstanceNamePrefixes, err := expandOSConfigPatchDeploymentInstanceFilterInstanceNamePrefixes(original["instance_name_prefixes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInstanceNamePrefixes); val.IsValid() && !isEmptyValue(val) {
		transformed["instanceNamePrefixes"] = transformedInstanceNamePrefixes
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentInstanceFilterAll(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentInstanceFilterGroupLabels(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedLabels, err := expandOSConfigPatchDeploymentInstanceFilterGroupLabelsLabels(original["labels"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedLabels); val.IsValid() && !isEmptyValue(val) {
			transformed["labels"] = transformedLabels
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandOSConfigPatchDeploymentInstanceFilterGroupLabelsLabels(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandOSConfigPatchDeploymentInstanceFilterZones(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentInstanceFilterInstances(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentInstanceFilterInstanceNamePrefixes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedMigInstancesAllowed, err := expandOSConfigPatchDeploymentPatchConfigMigInstancesAllowed(original["mig_instances_allowed"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMigInstancesAllowed); val.IsValid() && !isEmptyValue(val) {
		transformed["migInstancesAllowed"] = transformedMigInstancesAllowed
	}

	transformedRebootConfig, err := expandOSConfigPatchDeploymentPatchConfigRebootConfig(original["reboot_config"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRebootConfig); val.IsValid() && !isEmptyValue(val) {
		transformed["rebootConfig"] = transformedRebootConfig
	}

	transformedApt, err := expandOSConfigPatchDeploymentPatchConfigApt(original["apt"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedApt); val.IsValid() && !isEmptyValue(val) {
		transformed["apt"] = transformedApt
	}

	transformedYum, err := expandOSConfigPatchDeploymentPatchConfigYum(original["yum"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedYum); val.IsValid() && !isEmptyValue(val) {
		transformed["yum"] = transformedYum
	}

	transformedGoo, err := expandOSConfigPatchDeploymentPatchConfigGoo(original["goo"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGoo); val.IsValid() && !isEmptyValue(val) {
		transformed["goo"] = transformedGoo
	}

	transformedZypper, err := expandOSConfigPatchDeploymentPatchConfigZypper(original["zypper"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedZypper); val.IsValid() && !isEmptyValue(val) {
		transformed["zypper"] = transformedZypper
	}

	transformedWindowsUpdate, err := expandOSConfigPatchDeploymentPatchConfigWindowsUpdate(original["windows_update"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedWindowsUpdate); val.IsValid() && !isEmptyValue(val) {
		transformed["windowsUpdate"] = transformedWindowsUpdate
	}

	transformedPreStep, err := expandOSConfigPatchDeploymentPatchConfigPreStep(original["pre_step"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPreStep); val.IsValid() && !isEmptyValue(val) {
		transformed["preStep"] = transformedPreStep
	}

	transformedPostStep, err := expandOSConfigPatchDeploymentPatchConfigPostStep(original["post_step"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPostStep); val.IsValid() && !isEmptyValue(val) {
		transformed["postStep"] = transformedPostStep
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentPatchConfigMigInstancesAllowed(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigRebootConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigApt(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedType, err := expandOSConfigPatchDeploymentPatchConfigAptType(original["type"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedType); val.IsValid() && !isEmptyValue(val) {
		transformed["type"] = transformedType
	}

	transformedExcludes, err := expandOSConfigPatchDeploymentPatchConfigAptExcludes(original["excludes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedExcludes); val.IsValid() && !isEmptyValue(val) {
		transformed["excludes"] = transformedExcludes
	}

	transformedExclusivePackages, err := expandOSConfigPatchDeploymentPatchConfigAptExclusivePackages(original["exclusive_packages"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedExclusivePackages); val.IsValid() && !isEmptyValue(val) {
		transformed["exclusivePackages"] = transformedExclusivePackages
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentPatchConfigAptType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigAptExcludes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigAptExclusivePackages(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigYum(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedSecurity, err := expandOSConfigPatchDeploymentPatchConfigYumSecurity(original["security"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSecurity); val.IsValid() && !isEmptyValue(val) {
		transformed["security"] = transformedSecurity
	}

	transformedMinimal, err := expandOSConfigPatchDeploymentPatchConfigYumMinimal(original["minimal"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMinimal); val.IsValid() && !isEmptyValue(val) {
		transformed["minimal"] = transformedMinimal
	}

	transformedExcludes, err := expandOSConfigPatchDeploymentPatchConfigYumExcludes(original["excludes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedExcludes); val.IsValid() && !isEmptyValue(val) {
		transformed["excludes"] = transformedExcludes
	}

	transformedExclusivePackages, err := expandOSConfigPatchDeploymentPatchConfigYumExclusivePackages(original["exclusive_packages"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedExclusivePackages); val.IsValid() && !isEmptyValue(val) {
		transformed["exclusivePackages"] = transformedExclusivePackages
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentPatchConfigYumSecurity(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigYumMinimal(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigYumExcludes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigYumExclusivePackages(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigGoo(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedEnabled, err := expandOSConfigPatchDeploymentPatchConfigGooEnabled(original["enabled"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEnabled); val.IsValid() && !isEmptyValue(val) {
		transformed["enabled"] = transformedEnabled
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentPatchConfigGooEnabled(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigZypper(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedWithOptional, err := expandOSConfigPatchDeploymentPatchConfigZypperWithOptional(original["with_optional"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedWithOptional); val.IsValid() && !isEmptyValue(val) {
		transformed["withOptional"] = transformedWithOptional
	}

	transformedWithUpdate, err := expandOSConfigPatchDeploymentPatchConfigZypperWithUpdate(original["with_update"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedWithUpdate); val.IsValid() && !isEmptyValue(val) {
		transformed["withUpdate"] = transformedWithUpdate
	}

	transformedCategories, err := expandOSConfigPatchDeploymentPatchConfigZypperCategories(original["categories"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCategories); val.IsValid() && !isEmptyValue(val) {
		transformed["categories"] = transformedCategories
	}

	transformedSeverities, err := expandOSConfigPatchDeploymentPatchConfigZypperSeverities(original["severities"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSeverities); val.IsValid() && !isEmptyValue(val) {
		transformed["severities"] = transformedSeverities
	}

	transformedExcludes, err := expandOSConfigPatchDeploymentPatchConfigZypperExcludes(original["excludes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedExcludes); val.IsValid() && !isEmptyValue(val) {
		transformed["excludes"] = transformedExcludes
	}

	transformedExclusivePatches, err := expandOSConfigPatchDeploymentPatchConfigZypperExclusivePatches(original["exclusive_patches"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedExclusivePatches); val.IsValid() && !isEmptyValue(val) {
		transformed["exclusivePatches"] = transformedExclusivePatches
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentPatchConfigZypperWithOptional(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigZypperWithUpdate(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigZypperCategories(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigZypperSeverities(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigZypperExcludes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigZypperExclusivePatches(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigWindowsUpdate(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedClassifications, err := expandOSConfigPatchDeploymentPatchConfigWindowsUpdateClassifications(original["classifications"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedClassifications); val.IsValid() && !isEmptyValue(val) {
		transformed["classifications"] = transformedClassifications
	}

	transformedExcludes, err := expandOSConfigPatchDeploymentPatchConfigWindowsUpdateExcludes(original["excludes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedExcludes); val.IsValid() && !isEmptyValue(val) {
		transformed["excludes"] = transformedExcludes
	}

	transformedExclusivePatches, err := expandOSConfigPatchDeploymentPatchConfigWindowsUpdateExclusivePatches(original["exclusive_patches"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedExclusivePatches); val.IsValid() && !isEmptyValue(val) {
		transformed["exclusivePatches"] = transformedExclusivePatches
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentPatchConfigWindowsUpdateClassifications(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigWindowsUpdateExcludes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigWindowsUpdateExclusivePatches(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPreStep(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedLinuxExecStepConfig, err := expandOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig(original["linux_exec_step_config"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLinuxExecStepConfig); val.IsValid() && !isEmptyValue(val) {
		transformed["linuxExecStepConfig"] = transformedLinuxExecStepConfig
	}

	transformedWindowsExecStepConfig, err := expandOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig(original["windows_exec_step_config"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedWindowsExecStepConfig); val.IsValid() && !isEmptyValue(val) {
		transformed["windowsExecStepConfig"] = transformedWindowsExecStepConfig
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedAllowedSuccessCodes, err := expandOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigAllowedSuccessCodes(original["allowed_success_codes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowedSuccessCodes); val.IsValid() && !isEmptyValue(val) {
		transformed["allowedSuccessCodes"] = transformedAllowedSuccessCodes
	}

	transformedInterpreter, err := expandOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigInterpreter(original["interpreter"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInterpreter); val.IsValid() && !isEmptyValue(val) {
		transformed["interpreter"] = transformedInterpreter
	}

	transformedLocalPath, err := expandOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigLocalPath(original["local_path"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLocalPath); val.IsValid() && !isEmptyValue(val) {
		transformed["localPath"] = transformedLocalPath
	}

	transformedGcsObject, err := expandOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject(original["gcs_object"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGcsObject); val.IsValid() && !isEmptyValue(val) {
		transformed["gcsObject"] = transformedGcsObject
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigAllowedSuccessCodes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigInterpreter(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigLocalPath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedBucket, err := expandOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectBucket(original["bucket"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBucket); val.IsValid() && !isEmptyValue(val) {
		transformed["bucket"] = transformedBucket
	}

	transformedObject, err := expandOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectObject(original["object"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedObject); val.IsValid() && !isEmptyValue(val) {
		transformed["object"] = transformedObject
	}

	transformedGenerationNumber, err := expandOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectGenerationNumber(original["generation_number"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGenerationNumber); val.IsValid() && !isEmptyValue(val) {
		transformed["generationNumber"] = transformedGenerationNumber
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectBucket(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectObject(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectGenerationNumber(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedAllowedSuccessCodes, err := expandOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigAllowedSuccessCodes(original["allowed_success_codes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowedSuccessCodes); val.IsValid() && !isEmptyValue(val) {
		transformed["allowedSuccessCodes"] = transformedAllowedSuccessCodes
	}

	transformedInterpreter, err := expandOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigInterpreter(original["interpreter"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInterpreter); val.IsValid() && !isEmptyValue(val) {
		transformed["interpreter"] = transformedInterpreter
	}

	transformedLocalPath, err := expandOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigLocalPath(original["local_path"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLocalPath); val.IsValid() && !isEmptyValue(val) {
		transformed["localPath"] = transformedLocalPath
	}

	transformedGcsObject, err := expandOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject(original["gcs_object"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGcsObject); val.IsValid() && !isEmptyValue(val) {
		transformed["gcsObject"] = transformedGcsObject
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigAllowedSuccessCodes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigInterpreter(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigLocalPath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedBucket, err := expandOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectBucket(original["bucket"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBucket); val.IsValid() && !isEmptyValue(val) {
		transformed["bucket"] = transformedBucket
	}

	transformedObject, err := expandOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectObject(original["object"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedObject); val.IsValid() && !isEmptyValue(val) {
		transformed["object"] = transformedObject
	}

	transformedGenerationNumber, err := expandOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectGenerationNumber(original["generation_number"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGenerationNumber); val.IsValid() && !isEmptyValue(val) {
		transformed["generationNumber"] = transformedGenerationNumber
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectBucket(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectObject(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectGenerationNumber(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPostStep(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedLinuxExecStepConfig, err := expandOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig(original["linux_exec_step_config"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLinuxExecStepConfig); val.IsValid() && !isEmptyValue(val) {
		transformed["linuxExecStepConfig"] = transformedLinuxExecStepConfig
	}

	transformedWindowsExecStepConfig, err := expandOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig(original["windows_exec_step_config"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedWindowsExecStepConfig); val.IsValid() && !isEmptyValue(val) {
		transformed["windowsExecStepConfig"] = transformedWindowsExecStepConfig
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedAllowedSuccessCodes, err := expandOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigAllowedSuccessCodes(original["allowed_success_codes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowedSuccessCodes); val.IsValid() && !isEmptyValue(val) {
		transformed["allowedSuccessCodes"] = transformedAllowedSuccessCodes
	}

	transformedInterpreter, err := expandOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigInterpreter(original["interpreter"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInterpreter); val.IsValid() && !isEmptyValue(val) {
		transformed["interpreter"] = transformedInterpreter
	}

	transformedLocalPath, err := expandOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigLocalPath(original["local_path"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLocalPath); val.IsValid() && !isEmptyValue(val) {
		transformed["localPath"] = transformedLocalPath
	}

	transformedGcsObject, err := expandOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject(original["gcs_object"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGcsObject); val.IsValid() && !isEmptyValue(val) {
		transformed["gcsObject"] = transformedGcsObject
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigAllowedSuccessCodes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigInterpreter(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigLocalPath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedBucket, err := expandOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectBucket(original["bucket"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBucket); val.IsValid() && !isEmptyValue(val) {
		transformed["bucket"] = transformedBucket
	}

	transformedObject, err := expandOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectObject(original["object"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedObject); val.IsValid() && !isEmptyValue(val) {
		transformed["object"] = transformedObject
	}

	transformedGenerationNumber, err := expandOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectGenerationNumber(original["generation_number"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGenerationNumber); val.IsValid() && !isEmptyValue(val) {
		transformed["generationNumber"] = transformedGenerationNumber
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectBucket(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectObject(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectGenerationNumber(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedAllowedSuccessCodes, err := expandOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigAllowedSuccessCodes(original["allowed_success_codes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowedSuccessCodes); val.IsValid() && !isEmptyValue(val) {
		transformed["allowedSuccessCodes"] = transformedAllowedSuccessCodes
	}

	transformedInterpreter, err := expandOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigInterpreter(original["interpreter"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInterpreter); val.IsValid() && !isEmptyValue(val) {
		transformed["interpreter"] = transformedInterpreter
	}

	transformedLocalPath, err := expandOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigLocalPath(original["local_path"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLocalPath); val.IsValid() && !isEmptyValue(val) {
		transformed["localPath"] = transformedLocalPath
	}

	transformedGcsObject, err := expandOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject(original["gcs_object"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGcsObject); val.IsValid() && !isEmptyValue(val) {
		transformed["gcsObject"] = transformedGcsObject
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigAllowedSuccessCodes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigInterpreter(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigLocalPath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedBucket, err := expandOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectBucket(original["bucket"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBucket); val.IsValid() && !isEmptyValue(val) {
		transformed["bucket"] = transformedBucket
	}

	transformedObject, err := expandOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectObject(original["object"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedObject); val.IsValid() && !isEmptyValue(val) {
		transformed["object"] = transformedObject
	}

	transformedGenerationNumber, err := expandOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectGenerationNumber(original["generation_number"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGenerationNumber); val.IsValid() && !isEmptyValue(val) {
		transformed["generationNumber"] = transformedGenerationNumber
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectBucket(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectObject(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectGenerationNumber(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentDuration(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentOneTimeSchedule(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedExecuteTime, err := expandOSConfigPatchDeploymentOneTimeScheduleExecuteTime(original["execute_time"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedExecuteTime); val.IsValid() && !isEmptyValue(val) {
		transformed["executeTime"] = transformedExecuteTime
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentOneTimeScheduleExecuteTime(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentRecurringSchedule(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedTimeZone, err := expandOSConfigPatchDeploymentRecurringScheduleTimeZone(original["time_zone"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTimeZone); val.IsValid() && !isEmptyValue(val) {
		transformed["timeZone"] = transformedTimeZone
	}

	transformedStartTime, err := expandOSConfigPatchDeploymentRecurringScheduleStartTime(original["start_time"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedStartTime); val.IsValid() && !isEmptyValue(val) {
		transformed["startTime"] = transformedStartTime
	}

	transformedEndTime, err := expandOSConfigPatchDeploymentRecurringScheduleEndTime(original["end_time"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEndTime); val.IsValid() && !isEmptyValue(val) {
		transformed["endTime"] = transformedEndTime
	}

	transformedTimeOfDay, err := expandOSConfigPatchDeploymentRecurringScheduleTimeOfDay(original["time_of_day"], d, config)
	if err != nil {
		return nil, err
	} else {
		transformed["timeOfDay"] = transformedTimeOfDay
	}

	transformedLastExecuteTime, err := expandOSConfigPatchDeploymentRecurringScheduleLastExecuteTime(original["last_execute_time"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLastExecuteTime); val.IsValid() && !isEmptyValue(val) {
		transformed["lastExecuteTime"] = transformedLastExecuteTime
	}

	transformedNextExecuteTime, err := expandOSConfigPatchDeploymentRecurringScheduleNextExecuteTime(original["next_execute_time"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedNextExecuteTime); val.IsValid() && !isEmptyValue(val) {
		transformed["nextExecuteTime"] = transformedNextExecuteTime
	}

	transformedWeekly, err := expandOSConfigPatchDeploymentRecurringScheduleWeekly(original["weekly"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedWeekly); val.IsValid() && !isEmptyValue(val) {
		transformed["weekly"] = transformedWeekly
	}

	transformedMonthly, err := expandOSConfigPatchDeploymentRecurringScheduleMonthly(original["monthly"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMonthly); val.IsValid() && !isEmptyValue(val) {
		transformed["monthly"] = transformedMonthly
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleTimeZone(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedId, err := expandOSConfigPatchDeploymentRecurringScheduleTimeZoneId(original["id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedId); val.IsValid() && !isEmptyValue(val) {
		transformed["id"] = transformedId
	}

	transformedVersion, err := expandOSConfigPatchDeploymentRecurringScheduleTimeZoneVersion(original["version"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedVersion); val.IsValid() && !isEmptyValue(val) {
		transformed["version"] = transformedVersion
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleTimeZoneId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleTimeZoneVersion(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleStartTime(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleEndTime(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleTimeOfDay(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedHours, err := expandOSConfigPatchDeploymentRecurringScheduleTimeOfDayHours(original["hours"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedHours); val.IsValid() && !isEmptyValue(val) {
		transformed["hours"] = transformedHours
	}

	transformedMinutes, err := expandOSConfigPatchDeploymentRecurringScheduleTimeOfDayMinutes(original["minutes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMinutes); val.IsValid() && !isEmptyValue(val) {
		transformed["minutes"] = transformedMinutes
	}

	transformedSeconds, err := expandOSConfigPatchDeploymentRecurringScheduleTimeOfDaySeconds(original["seconds"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSeconds); val.IsValid() && !isEmptyValue(val) {
		transformed["seconds"] = transformedSeconds
	}

	transformedNanos, err := expandOSConfigPatchDeploymentRecurringScheduleTimeOfDayNanos(original["nanos"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedNanos); val.IsValid() && !isEmptyValue(val) {
		transformed["nanos"] = transformedNanos
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleTimeOfDayHours(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleTimeOfDayMinutes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleTimeOfDaySeconds(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleTimeOfDayNanos(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleLastExecuteTime(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleNextExecuteTime(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleWeekly(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedDayOfWeek, err := expandOSConfigPatchDeploymentRecurringScheduleWeeklyDayOfWeek(original["day_of_week"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDayOfWeek); val.IsValid() && !isEmptyValue(val) {
		transformed["dayOfWeek"] = transformedDayOfWeek
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleWeeklyDayOfWeek(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleMonthly(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedWeekDayOfMonth, err := expandOSConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth(original["week_day_of_month"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedWeekDayOfMonth); val.IsValid() && !isEmptyValue(val) {
		transformed["weekDayOfMonth"] = transformedWeekDayOfMonth
	}

	transformedMonthDay, err := expandOSConfigPatchDeploymentRecurringScheduleMonthlyMonthDay(original["month_day"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMonthDay); val.IsValid() && !isEmptyValue(val) {
		transformed["monthDay"] = transformedMonthDay
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedWeekOrdinal, err := expandOSConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthWeekOrdinal(original["week_ordinal"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedWeekOrdinal); val.IsValid() && !isEmptyValue(val) {
		transformed["weekOrdinal"] = transformedWeekOrdinal
	}

	transformedDayOfWeek, err := expandOSConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthDayOfWeek(original["day_of_week"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDayOfWeek); val.IsValid() && !isEmptyValue(val) {
		transformed["dayOfWeek"] = transformedDayOfWeek
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthWeekOrdinal(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthDayOfWeek(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentRecurringScheduleMonthlyMonthDay(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentRollout(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedMode, err := expandOSConfigPatchDeploymentRolloutMode(original["mode"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMode); val.IsValid() && !isEmptyValue(val) {
		transformed["mode"] = transformedMode
	}

	transformedDisruptionBudget, err := expandOSConfigPatchDeploymentRolloutDisruptionBudget(original["disruption_budget"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDisruptionBudget); val.IsValid() && !isEmptyValue(val) {
		transformed["disruptionBudget"] = transformedDisruptionBudget
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentRolloutMode(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentRolloutDisruptionBudget(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedFixed, err := expandOSConfigPatchDeploymentRolloutDisruptionBudgetFixed(original["fixed"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedFixed); val.IsValid() && !isEmptyValue(val) {
		transformed["fixed"] = transformedFixed
	}

	transformedPercentage, err := expandOSConfigPatchDeploymentRolloutDisruptionBudgetPercentage(original["percentage"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPercentage); val.IsValid() && !isEmptyValue(val) {
		transformed["percent"] = transformedPercentage
	}

	return transformed, nil
}

func expandOSConfigPatchDeploymentRolloutDisruptionBudgetFixed(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigPatchDeploymentRolloutDisruptionBudgetPercentage(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func resourceOSConfigPatchDeploymentEncoder(d *schema.ResourceData, meta interface{}, obj map[string]interface{}) (map[string]interface{}, error) {
	if obj["recurringSchedule"] != nil {
		schedule := obj["recurringSchedule"].(map[string]interface{})
		if schedule["monthly"] != nil {
			obj["recurringSchedule"].(map[string]interface{})["frequency"] = "MONTHLY"
		} else if schedule["weekly"] != nil {
			obj["recurringSchedule"].(map[string]interface{})["frequency"] = "WEEKLY"
		} else {
			obj["recurringSchedule"].(map[string]interface{})["frequency"] = "DAILY"
		}
	}

	if obj["patchConfig"] != nil {
		patchConfig := obj["patchConfig"].(map[string]interface{})
		if patchConfig["goo"] != nil {
			goo := patchConfig["goo"].(map[string]interface{})

			if goo["enabled"] == true {
				delete(goo, "enabled")
				patchConfig["goo"] = goo
			} else {
				delete(patchConfig, "goo")
			}

			obj["patchConfig"] = patchConfig
		}
	}

	return obj, nil
}

func resourceOSConfigPatchDeploymentDecoder(d *schema.ResourceData, meta interface{}, res map[string]interface{}) (map[string]interface{}, error) {
	if res["patchConfig"] != nil {
		patchConfig := res["patchConfig"].(map[string]interface{})
		if patchConfig["goo"] != nil {
			patchConfig["goo"].(map[string]interface{})["enabled"] = true
			res["patchConfig"] = patchConfig
		}
	}

	return res, nil
}
