/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.run;

import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.play.internal.platform.PlayMajorVersion;
import org.gradle.play.internal.run.PlayApplicationRunner;
import org.gradle.play.internal.run.PlayRunAdapterV23X;
import org.gradle.play.internal.run.PlayRunAdapterV24X;
import org.gradle.play.internal.run.PlayRunAdapterV25X;
import org.gradle.play.internal.run.PlayRunAdapterV26X;
import org.gradle.play.internal.run.VersionedPlayRunAdapter;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.process.internal.worker.WorkerProcessFactory;

public class PlayApplicationRunnerFactory {
    public static PlayApplicationRunner create(PlayPlatform playPlatform, WorkerProcessFactory workerFactory, FileCollectionFingerprinter fingerprinter, FileCollectionFactory fileCollectionFactory) {
        return new PlayApplicationRunner(workerFactory, PlayApplicationRunnerFactory.createPlayRunAdapter(playPlatform), fingerprinter, fileCollectionFactory);
    }

    public static VersionedPlayRunAdapter createPlayRunAdapter(PlayPlatform playPlatform) {
        switch (PlayMajorVersion.forPlatform(playPlatform)) {
            case PLAY_2_4_X: {
                return new PlayRunAdapterV24X();
            }
            case PLAY_2_5_X: {
                return new PlayRunAdapterV25X();
            }
            case PLAY_2_6_X: {
                return new PlayRunAdapterV26X();
            }
        }
        return new PlayRunAdapterV23X();
    }
}

