/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.vfs.impl;

import java.io.File;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.vfs.VirtualFileSystem;
import org.gradle.internal.vfs.impl.VfsRootReference;
import org.gradle.internal.watch.vfs.BuildFinishedFileSystemWatchingBuildOperationType;
import org.gradle.internal.watch.vfs.BuildLifecycleAwareVirtualFileSystem;
import org.gradle.internal.watch.vfs.BuildStartedFileSystemWatchingBuildOperationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchingNotSupportedVirtualFileSystem
implements BuildLifecycleAwareVirtualFileSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(WatchingNotSupportedVirtualFileSystem.class);
    private final VfsRootReference rootReference;

    public WatchingNotSupportedVirtualFileSystem(VfsRootReference rootReference) {
        this.rootReference = rootReference;
    }

    public SnapshotHierarchy getRoot() {
        return this.rootReference.getRoot();
    }

    public void update(VirtualFileSystem.UpdateFunction updateFunction) {
        this.rootReference.update(root -> updateFunction.update(root, SnapshotHierarchy.NodeDiffListener.NOOP));
    }

    @Override
    public void afterBuildStarted(boolean watchingEnabled, BuildLifecycleAwareVirtualFileSystem.VfsLogging vfsLogging, BuildLifecycleAwareVirtualFileSystem.WatchLogging watchLogging, BuildOperationRunner buildOperationRunner) {
        if (watchingEnabled) {
            LOGGER.warn("Watching the file system is not supported on this operating system.");
        }
        this.rootReference.update(vfsRoot -> (SnapshotHierarchy)buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<SnapshotHierarchy>(){

            public SnapshotHierarchy call(BuildOperationContext context) {
                context.setResult((Object)BuildStartedFileSystemWatchingBuildOperationType.Result.WATCHING_DISABLED);
                return vfsRoot.empty();
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Build started for file system watching").details((Object)BuildStartedFileSystemWatchingBuildOperationType.Details.INSTANCE);
            }
        }));
    }

    @Override
    public void registerWatchableHierarchy(File rootDirectoryForWatching) {
    }

    @Override
    public void beforeBuildFinished(boolean watchingEnabled, BuildLifecycleAwareVirtualFileSystem.VfsLogging vfsLogging, BuildLifecycleAwareVirtualFileSystem.WatchLogging watchLogging, BuildOperationRunner buildOperationRunner, int maximumNumberOfWatchedHierarchies) {
        this.rootReference.update(vfsRoot -> (SnapshotHierarchy)buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<SnapshotHierarchy>(){

            public SnapshotHierarchy call(BuildOperationContext context) {
                context.setResult((Object)BuildFinishedFileSystemWatchingBuildOperationType.Result.WATCHING_DISABLED);
                return vfsRoot.empty();
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Build finished for file system watching").details((Object)BuildFinishedFileSystemWatchingBuildOperationType.Details.INSTANCE);
            }
        }));
    }
}

