/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri2;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri2.MediaSource;

public class Sources
extends AbstractPacketExtension {
    public static final String ELEMENT = "sources";
    public static final String NAMESPACE = "jitsi:colibri2";
    public static final QName QNAME = new QName("jitsi:colibri2", "sources");

    public Sources() {
        super(NAMESPACE, ELEMENT);
    }

    private Sources(Builder b) {
        super(NAMESPACE, ELEMENT);
        for (MediaSource ms : b.mediaSources) {
            this.addChildExtension(ms);
        }
    }

    @NotNull
    public List<MediaSource> getMediaSources() {
        return this.getChildExtensionsOfType(MediaSource.class);
    }

    @Contract(value=" -> new")
    @NotNull
    public static Builder getBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<MediaSource> mediaSources = new ArrayList<MediaSource>();

        public Builder addMediaSource(MediaSource pt) {
            this.mediaSources.add(pt);
            return this;
        }

        private Builder() {
        }

        @Contract(value=" -> new")
        @NotNull
        public Sources build() {
            return new Sources(this);
        }
    }
}

