/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.roster.provider.RosterPacketProvider;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.formtypes.FormFieldRegistry;
import org.jivesoftware.smackx.xdata.AbstractMultiFormField;
import org.jivesoftware.smackx.xdata.AbstractSingleStringValueFormField;
import org.jivesoftware.smackx.xdata.BooleanFormField;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;
import org.jivesoftware.smackx.xdata.FormFieldWithOptions;
import org.jivesoftware.smackx.xdata.JidMultiFormField;
import org.jivesoftware.smackx.xdata.JidSingleFormField;
import org.jivesoftware.smackx.xdata.ListMultiFormField;
import org.jivesoftware.smackx.xdata.ListSingleFormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xdata.provider.FormFieldChildElementProvider;
import org.jivesoftware.smackx.xdata.provider.FormFieldChildElementProviderManager;
import org.jivesoftware.smackx.xdatalayout.provider.DataLayoutProvider;

public class DataFormProvider
extends ExtensionElementProvider<DataForm> {
    private static final Logger LOGGER = Logger.getLogger(DataFormProvider.class.getName());
    public static final DataFormProvider INSTANCE = new DataFormProvider();
    private static final Set<FieldNameAndFormType> UNKNOWN_FIELDS = new CopyOnWriteArraySet<FieldNameAndFormType>();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public DataForm parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        DataForm.Type dataFormType = DataForm.Type.fromString(parser.getAttributeValue("", "type"));
        DataForm.Builder dataForm = DataForm.builder(dataFormType);
        String formType = null;
        DataForm.ReportedData reportedData = null;
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name = parser.getName();
                    String namespace = parser.getNamespace();
                    XmlEnvironment elementXmlEnvironment = XmlEnvironment.from(parser, xmlEnvironment);
                    switch (name) {
                        case "instructions": {
                            dataForm.addInstruction(parser.nextText());
                            break;
                        }
                        case "title": {
                            dataForm.setTitle(parser.nextText());
                            break;
                        }
                        case "field": {
                            FormField formField = DataFormProvider.parseField(parser, elementXmlEnvironment, formType);
                            TextSingleFormField hiddenFormTypeField = formField.asHiddenFormTypeFieldIfPossible();
                            if (hiddenFormTypeField != null) {
                                if (formType != null) {
                                    throw new SmackParsingException("Multiple hidden form type fields");
                                }
                                formType = hiddenFormTypeField.getValue();
                            }
                            dataForm.addField(formField);
                            break;
                        }
                        case "item": {
                            DataForm.Item item = DataFormProvider.parseItem(parser, elementXmlEnvironment, formType, reportedData);
                            dataForm.addItem(item);
                            break;
                        }
                        case "reported": {
                            if (reportedData != null) {
                                throw new SmackParsingException("Data form with multiple <reported/> elements");
                            }
                            reportedData = DataFormProvider.parseReported(parser, elementXmlEnvironment, formType);
                            dataForm.setReportedData(reportedData);
                            break;
                        }
                        case "query": {
                            if (namespace.equals("jabber:iq:roster")) {
                                dataForm.addExtensionElement((Element)RosterPacketProvider.INSTANCE.parse(parser));
                                break;
                            }
                            break block0;
                        }
                        case "page": {
                            if (namespace.equals("http://jabber.org/protocol/xdata-layout")) {
                                dataForm.addExtensionElement(DataLayoutProvider.parse(parser));
                                break;
                            }
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return dataForm.build();
                }
            }
        }
    }

    private static FormField parseField(XmlPullParser parser, XmlEnvironment xmlEnvironment, String formType) throws XmlPullParserException, IOException, SmackParsingException {
        return DataFormProvider.parseField(parser, xmlEnvironment, formType, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static FormField parseField(XmlPullParser parser, XmlEnvironment xmlEnvironment, String formType, DataForm.ReportedData reportedData) throws XmlPullParserException, IOException, SmackParsingException {
        FormField.Builder builder;
        FormField reportedFormField;
        int initialDepth = parser.getDepth();
        String fieldName = parser.getAttributeValue("var");
        String label = parser.getAttributeValue("", "label");
        FormField.Type type2 = null;
        String fieldTypeString = parser.getAttributeValue("type");
        if (fieldTypeString != null) {
            type2 = FormField.Type.fromString(fieldTypeString);
        }
        ArrayList<FormField.Value> values2 = new ArrayList<FormField.Value>();
        ArrayList<FormField.Option> options2 = new ArrayList<FormField.Option>();
        ArrayList<FormFieldChildElement> childElements = new ArrayList<FormFieldChildElement>();
        boolean required = false;
        block19: while (true) {
            XmlPullParser.TagEvent eventType = parser.nextTag();
            switch (eventType) {
                case START_ELEMENT: {
                    QName qname = parser.getQName();
                    if (qname.equals(FormField.Value.QNAME)) {
                        FormField.Value value2 = DataFormProvider.parseValue(parser);
                        values2.add(value2);
                        break;
                    }
                    if (qname.equals(FormField.Option.QNAME)) {
                        FormField.Option option = DataFormProvider.parseOption(parser);
                        options2.add(option);
                        break;
                    }
                    if (qname.equals(FormField.Required.QNAME)) {
                        required = true;
                        break;
                    }
                    FormFieldChildElementProvider<?> provider = FormFieldChildElementProviderManager.getFormFieldChildElementProvider(qname);
                    if (provider == null) {
                        LOGGER.warning("Unknown form field child element " + qname + " ignored");
                        continue block19;
                    }
                    FormFieldChildElement formFieldChildElement = (FormFieldChildElement)provider.parse(parser, XmlEnvironment.from(parser, xmlEnvironment));
                    childElements.add(formFieldChildElement);
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() == initialDepth) break block19;
                }
            }
        }
        if (type2 == null && reportedData != null && (reportedFormField = reportedData.getField(fieldName)) != null) {
            type2 = reportedFormField.getType();
        }
        if (type2 == null) {
            if (fieldName.equals("FORM_TYPE")) {
                type2 = FormField.Type.hidden;
            } else {
                type2 = FormFieldRegistry.lookup(formType, fieldName);
                if (type2 == null) {
                    FieldNameAndFormType fieldNameAndFormType = new FieldNameAndFormType(fieldName, formType);
                    if (!UNKNOWN_FIELDS.contains(fieldNameAndFormType)) {
                        LOGGER.warning("The Field '" + fieldName + "' from FORM_TYPE '" + formType + "' is not registered. Field type is unknown, assuming text-single.");
                        UNKNOWN_FIELDS.add(fieldNameAndFormType);
                    }
                    type2 = FormField.Type.text_single;
                }
            }
        }
        switch (type2) {
            case bool: {
                builder = DataFormProvider.parseBooleanFormField(fieldName, values2);
                break;
            }
            case fixed: {
                builder = DataFormProvider.parseSingleKindFormField(FormField.fixedBuilder(fieldName), values2);
                break;
            }
            case hidden: {
                builder = DataFormProvider.parseSingleKindFormField(FormField.hiddenBuilder(fieldName), values2);
                break;
            }
            case jid_multi: {
                JidMultiFormField.Builder jidMultiBuilder = FormField.jidMultiBuilder(fieldName);
                for (FormField.Value value3 : values2) {
                    jidMultiBuilder.addValue(value3);
                }
                builder = jidMultiBuilder;
                break;
            }
            case jid_single: {
                DataFormProvider.ensureAtMostSingleValue(type2, values2);
                JidSingleFormField.Builder jidSingleBuilder = FormField.jidSingleBuilder(fieldName);
                if (!values2.isEmpty()) {
                    FormField.Value value3;
                    value3 = (FormField.Value)values2.get(0);
                    jidSingleBuilder.setValue(value3);
                }
                builder = jidSingleBuilder;
                break;
            }
            case list_multi: {
                ListMultiFormField.Builder listMultiBuilder = FormField.listMultiBuilder(fieldName);
                DataFormProvider.addOptionsToBuilder(options2, listMultiBuilder);
                builder = DataFormProvider.parseMultiKindFormField(listMultiBuilder, values2);
                break;
            }
            case list_single: {
                ListSingleFormField.Builder listSingleBuilder = FormField.listSingleBuilder(fieldName);
                DataFormProvider.addOptionsToBuilder(options2, listSingleBuilder);
                builder = DataFormProvider.parseSingleKindFormField(listSingleBuilder, values2);
                break;
            }
            case text_multi: {
                builder = DataFormProvider.parseMultiKindFormField(FormField.textMultiBuilder(fieldName), values2);
                break;
            }
            case text_private: {
                builder = DataFormProvider.parseSingleKindFormField(FormField.textPrivateBuilder(fieldName), values2);
                break;
            }
            case text_single: {
                builder = DataFormProvider.parseSingleKindFormField(FormField.textSingleBuilder(fieldName), values2);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type " + (Object)((Object)type2)));
            }
        }
        switch (type2) {
            case list_multi: 
            case list_single: {
                break;
            }
            default: {
                if (options2.isEmpty()) break;
                throw new SmackParsingException("Form fields of type " + (Object)((Object)type2) + " must not have options. This one had " + options2.size());
            }
        }
        if (label != null) {
            builder.setLabel(label);
        }
        builder.setRequired(required);
        builder.addFormFieldChildElements(childElements);
        return builder.build();
    }

    private static FormField.Builder<?, ?> parseBooleanFormField(String fieldName, List<FormField.Value> values2) throws SmackParsingException {
        BooleanFormField.Builder builder = FormField.booleanBuilder(fieldName);
        DataFormProvider.ensureAtMostSingleValue(builder.getType(), values2);
        if (values2.size() == 1) {
            FormField.Value value2 = values2.get(0);
            builder.setValue(value2);
        }
        return builder;
    }

    private static AbstractSingleStringValueFormField.Builder<?, ?> parseSingleKindFormField(AbstractSingleStringValueFormField.Builder<?, ?> builder, List<FormField.Value> values2) throws SmackParsingException {
        DataFormProvider.ensureAtMostSingleValue(builder.getType(), values2);
        if (values2.size() == 1) {
            String value2 = values2.get(0).getValue().toString();
            builder.setValue(value2);
        }
        return builder;
    }

    private static AbstractMultiFormField.Builder<?, ?> parseMultiKindFormField(AbstractMultiFormField.Builder<?, ?> builder, List<FormField.Value> values2) {
        for (FormField.Value value2 : values2) {
            builder.addValue(value2.getValue());
        }
        return builder;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static DataForm.Item parseItem(XmlPullParser parser, XmlEnvironment xmlEnvironment, String formType, DataForm.ReportedData reportedData) throws XmlPullParserException, IOException, SmackParsingException {
        int initialDepth = parser.getDepth();
        ArrayList<FormField> fields2 = new ArrayList<FormField>();
        while (true) {
            XmlPullParser.TagEvent eventType = parser.nextTag();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "field": {
                            FormField field = DataFormProvider.parseField(parser, XmlEnvironment.from(parser, xmlEnvironment), formType, reportedData);
                            fields2.add(field);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return new DataForm.Item(fields2);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static DataForm.ReportedData parseReported(XmlPullParser parser, XmlEnvironment xmlEnvironment, String formType) throws XmlPullParserException, IOException, SmackParsingException {
        int initialDepth = parser.getDepth();
        ArrayList<FormField> fields2 = new ArrayList<FormField>();
        while (true) {
            XmlPullParser.TagEvent eventType = parser.nextTag();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "field": {
                            FormField field = DataFormProvider.parseField(parser, XmlEnvironment.from(parser, xmlEnvironment), formType);
                            fields2.add(field);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return new DataForm.ReportedData(fields2);
                }
            }
        }
    }

    public static FormField.Value parseValue(XmlPullParser parser) throws IOException, XmlPullParserException {
        String value2 = parser.nextText();
        return new FormField.Value(value2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static FormField.Option parseOption(XmlPullParser parser) throws IOException, XmlPullParserException {
        int initialDepth = parser.getDepth();
        FormField.Option option = null;
        String label = parser.getAttributeValue("", "label");
        while (true) {
            XmlPullParser.TagEvent eventType = parser.nextTag();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "value": {
                            option = new FormField.Option(label, parser.nextText());
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return option;
                }
            }
        }
    }

    private static void ensureAtMostSingleValue(FormField.Type type2, List<FormField.Value> values2) throws SmackParsingException {
        if (values2.size() > 1) {
            throw new SmackParsingException((Object)((Object)type2) + " fields can have at most one value, this one had " + values2.size());
        }
    }

    private static void addOptionsToBuilder(Collection<FormField.Option> options2, FormFieldWithOptions.Builder<?> builder) {
        for (FormField.Option option : options2) {
            builder.addOption(option);
        }
    }

    private static final class FieldNameAndFormType {
        private final String fieldName;
        private final String formType;
        private final HashCode.Cache hashCodeCache = new HashCode.Cache();

        private FieldNameAndFormType(String fieldName, String formType) {
            this.fieldName = fieldName;
            this.formType = formType;
        }

        public int hashCode() {
            return this.hashCodeCache.getHashCode(b -> b.append(this.fieldName).append(this.formType).build());
        }

        public boolean equals(Object other) {
            return EqualsUtil.equals(this, other, (e, o) -> e.append(this.fieldName, o.fieldName).append(this.formType, o.formType));
        }
    }
}

