/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.tls.TlsUtils;

class ProvX509Key
implements BCX509Key {
    private final String keyType;
    private final PrivateKey privateKey;
    private final X509Certificate[] certificateChain;

    static ProvX509Key from(X509KeyManager x509KeyManager, String string, String string2) {
        if (null == x509KeyManager) {
            throw new NullPointerException("'x509KeyManager' cannot be null");
        }
        if (null == string || null == string2) {
            return null;
        }
        PrivateKey privateKey = x509KeyManager.getPrivateKey(string2);
        if (null == privateKey) {
            return null;
        }
        Object[] objectArray = x509KeyManager.getCertificateChain(string2);
        if (TlsUtils.isNullOrEmpty(objectArray)) {
            return null;
        }
        if (JsseUtils.containsNull(objectArray = (X509Certificate[])objectArray.clone())) {
            return null;
        }
        return new ProvX509Key(string, privateKey, (X509Certificate[])objectArray);
    }

    ProvX509Key(String string, PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
        this.keyType = string;
        this.privateKey = privateKey;
        this.certificateChain = x509CertificateArray;
    }

    public X509Certificate[] getCertificateChain() {
        return (X509Certificate[])this.certificateChain.clone();
    }

    public String getKeyType() {
        return this.keyType;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

