/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.codec.vp9;

import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.rtp.ParsedVideoPacket;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi_modified.impl.neomedia.codec.video.vp9.DePacketizer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b#\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 A2\u00020\u0001:\u0001AB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B[\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fJ\b\u0010:\u001a\u00020\u0000H\u0016J\u001c\u0010;\u001a\u0004\u0018\u00010<2\b\b\u0002\u0010=\u001a\u00020\u00052\b\b\u0002\u0010>\u001a\u00020?J\b\u0010@\u001a\u00020-H\u0016R$\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0019\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\u001b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u0011\u0010 \u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001dR\u0011\u0010\"\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001dR\u0011\u0010$\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001dR\u0014\u0010\u000b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u001dR\u0011\u0010&\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001dR\u0011\u0010'\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001dR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u001dR\u0014\u0010\n\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u001dR\u0011\u0010(\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001dR\u0011\u0010)\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001dR\u0014\u0010*\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0012R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R$\u0010\r\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b0\u0010\u0012\"\u0004\b1\u0010\u0014R\u0011\u00102\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0012R\u0011\u00104\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0012R\u0011\u00106\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u0012R\u0011\u00108\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u001d\u00a8\u0006B"}, d2={"Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Packet;", "Lorg/jitsi/nlj/rtp/ParsedVideoPacket;", "buffer", "", "offset", "", "length", "([BII)V", "isKeyframe", "", "isStartOfFrame", "isEndOfFrame", "encodingIndex", "pictureId", "TL0PICIDX", "([BIILjava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;)V", "newValue", "getTL0PICIDX", "()I", "setTL0PICIDX", "(I)V", "_TL0PICIDX", "_pictureId", "effectiveSpatialLayerIndex", "getEffectiveSpatialLayerIndex", "effectiveTemporalLayerIndex", "getEffectiveTemporalLayerIndex", "hasExtendedPictureId", "getHasExtendedPictureId", "()Z", "hasLayerIndices", "getHasLayerIndices", "hasPictureId", "getHasPictureId", "hasScalabilityStructure", "getHasScalabilityStructure", "hasTL0PICIDX", "getHasTL0PICIDX", "isEndOfPicture", "isInterPicturePredicted", "isSwitchingUpPoint", "isUpperLevelReference", "layerId", "getLayerId", "payloadVerification", "", "getPayloadVerification", "()Ljava/lang/String;", "getPictureId", "setPictureId", "scalabilityStructureNumSpatial", "getScalabilityStructureNumSpatial", "spatialLayerIndex", "getSpatialLayerIndex", "temporalLayerIndex", "getTemporalLayerIndex", "usesInterLayerDependency", "getUsesInterLayerDependency", "clone", "getScalabilityStructure", "Lorg/jitsi/nlj/RtpEncodingDesc;", "eid", "baseFrameRate", "", "toString", "Companion", "jitsi-media-transform"})
public final class Vp9Packet
extends ParsedVideoPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isKeyframe;
    private final boolean isStartOfFrame;
    private final boolean isEndOfFrame;
    private final boolean hasLayerIndices;
    private final boolean hasPictureId;
    private final boolean hasExtendedPictureId;
    private final boolean hasScalabilityStructure;
    private final boolean isUpperLevelReference;
    private final boolean isInterPicturePredicted;
    private int _TL0PICIDX;
    private int _pictureId;
    private final int temporalLayerIndex;
    private final int spatialLayerIndex;
    private final int effectiveTemporalLayerIndex;
    private final int effectiveSpatialLayerIndex;
    private final boolean isSwitchingUpPoint;
    private final boolean usesInterLayerDependency;
    @NotNull
    private static final Logger logger = LoggerExtensionsKt.createLogger$default(Companion, null, null, 3, null);
    private static final int Y_BIT = 16;
    private static final int G_BIT = 8;
    private static final int MAX_NUM_TLAYERS = 8;

    private Vp9Packet(byte[] buffer, int offset, int length, Boolean isKeyframe, Boolean isStartOfFrame, Boolean isEndOfFrame, Integer encodingIndex, Integer pictureId, Integer TL0PICIDX) {
        super(buffer, offset, length, encodingIndex);
        Boolean bl = isKeyframe;
        this.isKeyframe = bl != null ? bl : DePacketizer.VP9PayloadDescriptor.isKeyFrame(this.buffer, this.getPayloadOffset(), this.getPayloadLength());
        Boolean bl2 = isStartOfFrame;
        this.isStartOfFrame = bl2 != null ? bl2 : DePacketizer.VP9PayloadDescriptor.isStartOfFrame(buffer, this.getPayloadOffset(), this.getPayloadLength());
        Boolean bl3 = isEndOfFrame;
        this.isEndOfFrame = bl3 != null ? bl3 : DePacketizer.VP9PayloadDescriptor.isEndOfFrame(buffer, this.getPayloadOffset(), this.getPayloadLength());
        this.hasLayerIndices = DePacketizer.VP9PayloadDescriptor.hasLayerIndices(buffer, this.getPayloadOffset(), this.getPayloadLength());
        this.hasPictureId = DePacketizer.VP9PayloadDescriptor.hasPictureId(buffer, this.getPayloadOffset(), this.getPayloadLength());
        this.hasExtendedPictureId = DePacketizer.VP9PayloadDescriptor.hasExtendedPictureId(buffer, this.getPayloadOffset(), this.getPayloadLength());
        this.hasScalabilityStructure = DePacketizer.VP9PayloadDescriptor.hasScalabilityStructure(buffer, this.getPayloadOffset(), this.getPayloadLength());
        this.isUpperLevelReference = DePacketizer.VP9PayloadDescriptor.isUpperLevelReference(buffer, this.getPayloadOffset(), this.getPayloadLength());
        this.isInterPicturePredicted = DePacketizer.VP9PayloadDescriptor.isInterPicturePredicted(buffer, this.getPayloadOffset(), this.getPayloadLength());
        Integer n = TL0PICIDX;
        this._TL0PICIDX = n != null ? n : DePacketizer.VP9PayloadDescriptor.getTL0PICIDX(buffer, this.getPayloadOffset(), this.getPayloadLength());
        Integer n2 = pictureId;
        this._pictureId = n2 != null ? n2 : DePacketizer.VP9PayloadDescriptor.getPictureId(buffer, this.getPayloadOffset(), this.getPayloadLength());
        this.temporalLayerIndex = DePacketizer.VP9PayloadDescriptor.getTemporalLayerIndex(buffer, this.getPayloadOffset(), this.getPayloadLength());
        this.spatialLayerIndex = DePacketizer.VP9PayloadDescriptor.getSpatialLayerIndex(buffer, this.getPayloadOffset(), this.getPayloadLength());
        this.effectiveTemporalLayerIndex = this.hasLayerIndices ? this.temporalLayerIndex : 0;
        this.effectiveSpatialLayerIndex = this.hasLayerIndices ? this.spatialLayerIndex : 0;
        this.isSwitchingUpPoint = DePacketizer.VP9PayloadDescriptor.isSwitchingUpPoint(buffer, this.getPayloadOffset(), this.getPayloadLength());
        this.usesInterLayerDependency = DePacketizer.VP9PayloadDescriptor.usesInterLayerDependency(buffer, this.getPayloadOffset(), this.getPayloadLength());
    }

    public Vp9Packet(@NotNull byte[] buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this(buffer, offset, length, null, null, null, null, null, null);
    }

    @Override
    public boolean isKeyframe() {
        return this.isKeyframe;
    }

    @Override
    public boolean isStartOfFrame() {
        return this.isStartOfFrame;
    }

    @Override
    public boolean isEndOfFrame() {
        return this.isEndOfFrame;
    }

    @Override
    public int getLayerId() {
        return this.hasLayerIndices ? RtpLayerDesc.Companion.getIndex(0, this.spatialLayerIndex, this.temporalLayerIndex) : super.getLayerId();
    }

    public final boolean isEndOfPicture() {
        return this.isMarked();
    }

    public final boolean getHasLayerIndices() {
        return this.hasLayerIndices;
    }

    public final boolean getHasPictureId() {
        return this.hasPictureId;
    }

    public final boolean getHasExtendedPictureId() {
        return this.hasExtendedPictureId;
    }

    public final boolean getHasScalabilityStructure() {
        return this.hasScalabilityStructure;
    }

    public final boolean isUpperLevelReference() {
        return this.isUpperLevelReference;
    }

    public final boolean isInterPicturePredicted() {
        return this.isInterPicturePredicted;
    }

    public final int getTL0PICIDX() {
        return this._TL0PICIDX;
    }

    public final void setTL0PICIDX(int newValue) {
        if (newValue != -1 && !DePacketizer.VP9PayloadDescriptor.setTL0PICIDX(this.buffer, this.getPayloadOffset(), this.getPayloadLength(), newValue)) {
            Logger $this$cwarn$iv = logger;
            boolean $i$f$cwarn = false;
            if ($this$cwarn$iv.isWarnEnabled()) {
                Logger logger = $this$cwarn$iv;
                boolean bl = false;
                logger.warn("Failed to set the TL0PICIDX of a VP9 packet.");
            }
        }
        this._TL0PICIDX = newValue;
    }

    public final boolean getHasTL0PICIDX() {
        return this._TL0PICIDX != -1;
    }

    public final int getPictureId() {
        return this._pictureId;
    }

    public final void setPictureId(int newValue) {
        if (!DePacketizer.VP9PayloadDescriptor.setExtendedPictureId(this.buffer, this.getPayloadOffset(), this.getPayloadLength(), newValue)) {
            Logger $this$cwarn$iv = logger;
            boolean $i$f$cwarn = false;
            if ($this$cwarn$iv.isWarnEnabled()) {
                Logger logger = $this$cwarn$iv;
                boolean bl = false;
                logger.warn("Failed to set the picture id of a VP9 packet.");
            }
        }
        this._pictureId = newValue;
    }

    public final int getTemporalLayerIndex() {
        return this.temporalLayerIndex;
    }

    public final int getSpatialLayerIndex() {
        return this.spatialLayerIndex;
    }

    public final int getEffectiveTemporalLayerIndex() {
        return this.effectiveTemporalLayerIndex;
    }

    public final int getEffectiveSpatialLayerIndex() {
        return this.effectiveSpatialLayerIndex;
    }

    public final boolean isSwitchingUpPoint() {
        return this.isSwitchingUpPoint;
    }

    public final boolean getUsesInterLayerDependency() {
        return this.usesInterLayerDependency;
    }

    @Nullable
    public final RtpEncodingDesc getScalabilityStructure(int eid, double baseFrameRate) {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return Companion.getScalabilityStructure(this.buffer, this.getPayloadOffset(), this.getPayloadLength(), this.getSsrc(), eid, baseFrameRate);
    }

    public static /* synthetic */ RtpEncodingDesc getScalabilityStructure$default(Vp9Packet vp9Packet, int n, double d, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            d = 30.0;
        }
        return vp9Packet.getScalabilityStructure(n, d);
    }

    public final int getScalabilityStructureNumSpatial() {
        int off = DePacketizer.VP9PayloadDescriptor.getScalabilityStructureOffset(this.buffer, this.getPayloadOffset(), this.getPayloadLength());
        if (off == -1) {
            return -1;
        }
        byte ssHeader = this.buffer[off];
        return ((ssHeader & 0xE0) >> 5) + 1;
    }

    @Override
    @NotNull
    public String getPayloadVerification() {
        int rtpPayloadLength = this.getPayloadLength();
        int rtpPayloadOffset = this.getPayloadOffset();
        int vp9pdSize = DePacketizer.VP9PayloadDescriptor.getSize(this.buffer, rtpPayloadOffset, rtpPayloadLength);
        int vp9PayloadLength = rtpPayloadLength - vp9pdSize;
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        int hashCode2 = ByteArrayExtensionsKt.hashCodeOfSegment(this.buffer, rtpPayloadOffset + vp9pdSize, rtpPayloadOffset + rtpPayloadLength);
        return "type=VP9Packet len=" + vp9PayloadLength + " hashCode=" + hashCode2;
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + ", SID=" + this.spatialLayerIndex + ", TID=" + this.temporalLayerIndex;
    }

    @Override
    @NotNull
    public Vp9Packet clone() {
        return new Vp9Packet(this.cloneBuffer(10), 10, this.length, this.isKeyframe(), this.isStartOfFrame(), this.isEndOfFrame(), this.getQualityIndex(), this.getPictureId(), this.getTL0PICIDX());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Packet$Companion;", "", "()V", "G_BIT", "", "MAX_NUM_TLAYERS", "Y_BIT", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getScalabilityStructure", "Lorg/jitsi/nlj/RtpEncodingDesc;", "buffer", "", "payloadOffset", "payloadLength", "ssrc", "", "eid", "baseFrameRate", "", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final RtpEncodingDesc getScalabilityStructure(@NotNull byte[] buffer, int payloadOffset, int payloadLength, long ssrc2, int eid, double baseFrameRate) {
            int n;
            int $i$f$indexOfLast;
            int groupSize;
            Integer[] tlCounts;
            Integer[] heights;
            boolean hasPictureGroup;
            int numSpatial;
            block21: {
                int n2;
                int tid;
                Integer[] integerArray;
                int n3;
                Integer[] integerArray2;
                int n4;
                Intrinsics.checkNotNullParameter(buffer, "buffer");
                int off = DePacketizer.VP9PayloadDescriptor.getScalabilityStructureOffset(buffer, payloadOffset, payloadLength);
                if (off == -1) {
                    return null;
                }
                byte ssHeader = buffer[off];
                numSpatial = ((ssHeader & 0xE0) >> 5) + 1;
                boolean hasResolution = (ssHeader & Y_BIT) != 0;
                hasPictureGroup = (ssHeader & G_BIT) != 0;
                ++off;
                if (hasResolution) {
                    n4 = 0;
                    integerArray2 = new Integer[numSpatial];
                    while (n4 < numSpatial) {
                        n3 = n4++;
                        int height = (buffer[off += 2] & 0xFF) << 8 | buffer[off + 1] & 0xFF;
                        off += 2;
                        integerArray2[n3] = height;
                    }
                    integerArray = integerArray2;
                } else {
                    n4 = 0;
                    integerArray2 = new Integer[numSpatial];
                    while (n4 < numSpatial) {
                        n3 = n4++;
                        integerArray2[n3] = -1;
                    }
                    integerArray = integerArray2;
                }
                heights = integerArray;
                int n5 = 0;
                n3 = MAX_NUM_TLAYERS;
                Integer[] height = new Integer[n3];
                while (n5 < n3) {
                    int n6 = n5++;
                    height[n6] = 0;
                }
                tlCounts = height;
                if (hasPictureGroup) {
                    int groupSize2 = buffer[off];
                    ++off;
                    for (int i = 0; i < groupSize2; ++i) {
                        byte descByte = buffer[off];
                        tid = (descByte & 0xE0) >> 5;
                        int numRefs = (descByte & 0xC) >> 2;
                        ++off;
                        int n7 = tlCounts[tid];
                        tlCounts[tid] = n7 + 1;
                        for (int j = 0; j < numRefs; ++j) {
                            ++off;
                        }
                    }
                    n2 = groupSize2;
                } else {
                    tlCounts[0] = 1;
                    n2 = 1;
                }
                groupSize = n2;
                Integer[] $this$indexOfLast$iv = tlCounts;
                $i$f$indexOfLast = 0;
                tid = $this$indexOfLast$iv.length + -1;
                if (0 <= tid) {
                    do {
                        int index$iv = tid--;
                        int it = ((Number)$this$indexOfLast$iv[index$iv]).intValue();
                        boolean bl = false;
                        if (!(it > 0)) continue;
                        n = index$iv;
                        break block21;
                    } while (0 <= tid);
                }
                n = -1;
            }
            int numTemporal = n + 1;
            for (int t = 1; t < numTemporal; ++t) {
                $i$f$indexOfLast = t;
                tlCounts[$i$f$indexOfLast] = tlCounts[$i$f$indexOfLast] + tlCounts[t - 1];
            }
            ArrayList<RtpLayerDesc> layers = new ArrayList<RtpLayerDesc>();
            for (int s2 = 0; s2 < numSpatial; ++s2) {
                for (int t = 0; t < numTemporal; ++t) {
                    Object it;
                    RtpLayerDesc it2;
                    ArrayList<Object> dependencies = new ArrayList<Object>();
                    ArrayList<Object> softDependencies = new ArrayList<Object>();
                    if (s2 > 0) {
                        Object v3;
                        block22: {
                            Iterable iterable = layers;
                            for (Object t2 : iterable) {
                                it2 = (RtpLayerDesc)t2;
                                boolean bl = false;
                                if (!(it2.getSid() == s2 - 1 && it2.getTid() == t)) continue;
                                v3 = t2;
                                break block22;
                            }
                            v3 = null;
                        }
                        if ((RtpLayerDesc)v3 != null) {
                            boolean bl = false;
                            softDependencies.add(it);
                        }
                    }
                    if (t > 0) {
                        Object v4;
                        block23: {
                            it = layers;
                            Iterator bl = it.iterator();
                            while (bl.hasNext()) {
                                Object t2;
                                t2 = bl.next();
                                it2 = (RtpLayerDesc)t2;
                                boolean bl2 = false;
                                if (!(it2.getSid() == s2 && it2.getTid() == t - 1)) continue;
                                v4 = t2;
                                break block23;
                            }
                            v4 = null;
                        }
                        RtpLayerDesc rtpLayerDesc = v4;
                        if (rtpLayerDesc != null) {
                            it = rtpLayerDesc;
                            boolean bl = false;
                            dependencies.add(it);
                        }
                    }
                    int n8 = heights[s2];
                    double d = hasPictureGroup ? baseFrameRate * (double)tlCounts[t].intValue() / (double)groupSize : -1.0;
                    RtpLayerDesc[] rtpLayerDescArray = dependencies.toArray(new RtpLayerDesc[0]);
                    Intrinsics.checkNotNullExpressionValue(rtpLayerDescArray, "dependencies.toArray(arrayOf<RtpLayerDesc>())");
                    RtpLayerDesc[] rtpLayerDescArray2 = softDependencies.toArray(new RtpLayerDesc[0]);
                    Intrinsics.checkNotNullExpressionValue(rtpLayerDescArray2, "softDependencies.toArray(arrayOf<RtpLayerDesc>())");
                    RtpLayerDesc layerDesc = new RtpLayerDesc(eid, t, s2, n8, d, rtpLayerDescArray, rtpLayerDescArray2);
                    layers.add(layerDesc);
                }
            }
            RtpLayerDesc[] rtpLayerDescArray = layers.toArray(new RtpLayerDesc[0]);
            Intrinsics.checkNotNullExpressionValue(rtpLayerDescArray, "layers.toArray(arrayOf())");
            return new RtpEncodingDesc(ssrc2, rtpLayerDescArray, eid);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

