/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.util;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.TimeUtils;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0001\u001a*\u0010\b\u001a\u00020\u0007\"\u0004\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u00070\f\u001a\n\u0010\r\u001a\u00020\u0004*\u00020\u0001\"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"NEVER", "Ljava/time/Instant;", "instantOfEpochMicro", "epochMicro", "", "formatMilli", "", "Ljava/time/Duration;", "sumOf", "T", "", "selector", "Lkotlin/Function1;", "toEpochMicro", "jitsi-media-transform"})
@JvmName(name="ClockUtils")
public final class ClockUtils {
    @JvmField
    @NotNull
    public static final Instant NEVER;

    @NotNull
    public static final String formatMilli(@NotNull Instant $this$formatMilli) {
        Intrinsics.checkNotNullParameter($this$formatMilli, "<this>");
        String string = TimeUtils.formatTimeAsFullMillis($this$formatMilli.getEpochSecond(), $this$formatMilli.getNano());
        Intrinsics.checkNotNullExpressionValue(string, "formatTimeAsFullMillis(t\u2026s.epochSecond, this.nano)");
        return string;
    }

    @NotNull
    public static final String formatMilli(@NotNull Duration $this$formatMilli) {
        Intrinsics.checkNotNullParameter($this$formatMilli, "<this>");
        String string = TimeUtils.formatTimeAsFullMillis($this$formatMilli.getSeconds(), $this$formatMilli.getNano());
        Intrinsics.checkNotNullExpressionValue(string, "formatTimeAsFullMillis(this.seconds, this.nano)");
        return string;
    }

    public static final long toEpochMicro(@NotNull Instant $this$toEpochMicro) {
        long l;
        Intrinsics.checkNotNullParameter($this$toEpochMicro, "<this>");
        if ($this$toEpochMicro.getEpochSecond() < 0L && $this$toEpochMicro.getNano() > 0) {
            long micros = Math.multiplyExact($this$toEpochMicro.getEpochSecond() + 1L, 1000000L);
            long adjustment = $this$toEpochMicro.getNano() / 1000 - 1000000;
            l = Math.addExact(micros, adjustment);
        } else {
            long micros = Math.multiplyExact($this$toEpochMicro.getEpochSecond(), 1000000L);
            l = Math.addExact(micros, (long)($this$toEpochMicro.getNano() / 1000));
        }
        return l;
    }

    @NotNull
    public static final Instant instantOfEpochMicro(long epochMicro) {
        long secs = Math.floorDiv(epochMicro, 1000000L);
        long micros = Math.floorMod(epochMicro, 1000000L);
        Instant instant = Instant.ofEpochSecond(secs, micros * 1000L);
        Intrinsics.checkNotNullExpressionValue(instant, "ofEpochSecond(secs, micros * 1000L)");
        return instant;
    }

    @NotNull
    public static final <T> Duration sumOf(@NotNull Iterable<? extends T> $this$sumOf, @NotNull Function1<? super T, Duration> selector) {
        Intrinsics.checkNotNullParameter($this$sumOf, "<this>");
        Intrinsics.checkNotNullParameter(selector, "selector");
        Duration duration = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue(duration, "ZERO");
        Duration sum = duration;
        for (T element : $this$sumOf) {
            Intrinsics.checkNotNullExpressionValue(sum.plus(selector.invoke(element)), "sum += selector(element)");
        }
        return sum;
    }

    static {
        Instant instant = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue(instant, "MIN");
        NEVER = instant;
    }
}

