/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import javax.xml.namespace.QName;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.XmppElementUtil;

public class ExtensionElementFilter<E extends ExtensionElement>
implements StanzaFilter {
    private final Class<E> extensionElementClass;
    private final QName extensionElementQName;

    protected ExtensionElementFilter(Class<E> extensionElementClass) {
        this.extensionElementClass = extensionElementClass;
        this.extensionElementQName = XmppElementUtil.getQNameFor(extensionElementClass);
    }

    @Override
    public final boolean accept(Stanza stanza) {
        ExtensionElement extensionElement = stanza.getExtension(this.extensionElementQName);
        if (extensionElement == null) {
            return false;
        }
        if (!this.extensionElementClass.isInstance(extensionElement)) {
            return false;
        }
        ExtensionElement specificExtensionElement = (ExtensionElement)this.extensionElementClass.cast(extensionElement);
        return this.accept(specificExtensionElement);
    }

    public boolean accept(E extensionElement) {
        return true;
    }
}

