/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import io.quarkus.paths.ArchivePathTree;
import io.quarkus.paths.DirectoryPathTree;
import io.quarkus.paths.FilePathTree;
import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathVisit;
import io.quarkus.paths.PathVisitor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.Manifest;

public interface PathTree {
    public static PathTree ofDirectoryOrFile(Path p) {
        try {
            BasicFileAttributes fileAttributes = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
            return fileAttributes.isDirectory() ? new DirectoryPathTree(p) : new FilePathTree(p);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(p + " does not exist", e);
        }
    }

    public static PathTree ofDirectoryOrArchive(Path p) {
        try {
            BasicFileAttributes fileAttributes = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
            return fileAttributes.isDirectory() ? new DirectoryPathTree(p) : new ArchivePathTree(p);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(p + " does not exist", e);
        }
    }

    public static PathTree ofArchive(Path archive) {
        if (!Files.exists(archive, new LinkOption[0])) {
            throw new IllegalArgumentException(archive + " does not exist");
        }
        return new ArchivePathTree(archive);
    }

    public Collection<Path> getRoots();

    default public boolean isEmpty() {
        return this.getRoots().isEmpty();
    }

    public Manifest getManifest();

    public void walk(PathVisitor var1);

    public <T> T apply(String var1, Function<PathVisit, T> var2);

    public void accept(String var1, Consumer<PathVisit> var2);

    public boolean contains(String var1);

    public OpenPathTree open();
}

