/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.backup.resources;

import io.reactivex.rxjava3.core.Flowable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.infinispan.AdvancedCache;
import org.infinispan.cache.impl.InvocationHelper;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.context.Flag;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.encoding.impl.StorageConfigurationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.globalstate.ScopedState;
import org.infinispan.globalstate.impl.CacheState;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.reactive.publisher.PublisherTransformers;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManager;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.server.core.BackupManager;
import org.infinispan.server.core.backup.resources.AbstractContainerResource;
import org.infinispan.server.core.backup.resources.SecurityActions;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.function.SerializableFunction;
import org.reactivestreams.Publisher;

public class CacheResource
extends AbstractContainerResource {
    private static final String MEMCACHED_CACHE = "memcachedCache";
    private final EmbeddedCacheManager cm;
    private final ParserRegistry parserRegistry;

    CacheResource(BlockingManager blockingManager, ParserRegistry parserRegistry, EmbeddedCacheManager cm, BackupManager.Resources params, Path root) {
        super(BackupManager.Resources.Type.CACHES, params, blockingManager, root);
        this.cm = cm;
        this.parserRegistry = parserRegistry;
    }

    @Override
    public void prepareAndValidateBackup() {
        InternalCacheRegistry icr = (InternalCacheRegistry)SecurityActions.getGlobalComponentRegistry(this.cm).getComponent(InternalCacheRegistry.class);
        Set caches = this.wildcard ? this.cm.getCacheConfigurationNames() : this.resources;
        for (String cache : caches) {
            Configuration config = SecurityActions.getCacheConfiguration(this.cm, cache);
            if (this.wildcard) {
                if (config == null || config.isTemplate() || icr.isInternalCache(cache) || MEMCACHED_CACHE.equals(cache)) continue;
                this.resources.add(cache);
                continue;
            }
            if (config == null) {
                throw log.unableToFindResource(this.type.toString(), cache);
            }
            if (!config.isTemplate()) continue;
            throw new CacheException(String.format("Unable to backup %s '%s' as it is a template not a cache", new Object[]{this.type, cache}));
        }
    }

    @Override
    public CompletionStage<Void> backup() {
        AggregateCompletionStage stages = CompletionStages.aggregateCompletionStage();
        for (String cache : this.resources) {
            stages.dependsOn(this.createCacheBackup(cache));
        }
        return stages.freeze();
    }

    @Override
    public CompletionStage<Void> restore(ZipFile zip) {
        AggregateCompletionStage stages = CompletionStages.aggregateCompletionStage();
        for (String cacheName : this.resources) {
            stages.dependsOn(this.blockingManager.runBlocking(() -> {
                Path cacheRoot = this.root.resolve(cacheName);
                String configFile = this.configFile(cacheName);
                String zipPath = cacheRoot.resolve(configFile).toString();
                try (InputStream is = zip.getInputStream(zip.getEntry(zipPath));){
                    ConfigurationBuilderHolder builderHolder = this.parserRegistry.parse(is, null, MediaType.fromExtension((String)configFile));
                    Configuration config = ((ConfigurationBuilder)builderHolder.getNamedConfigurationBuilders().get(cacheName)).build();
                    log.debugf("Restoring Cache %s: %s", cacheName, config.toStringConfiguration(cacheName));
                    String configXml = config.toStringConfiguration(cacheName);
                    ClusterExecutor executor = SecurityActions.getClusterExecutor(this.cm);
                    AtomicReference cause = new AtomicReference();
                    CompletableFuture remoteCall = executor.submitConsumer((SerializableFunction & Serializable)m -> CacheResource.createCacheFunction(cacheName, configXml, m), (a, v, t) -> {
                        if (t != null) {
                            log.errorf("%s unable to create cache %s", a, cacheName);
                            cause.compareAndSet(null, t);
                        }
                    });
                    CompletionStages.join((CompletionStage)remoteCall);
                    if (cause.get() != null) {
                        throw new CacheException((Throwable)cause.get());
                    }
                    log.debugf("Define cache %s globally. config=%s", cacheName, configXml);
                    CacheState state = new CacheState(null, configXml, EnumSet.noneOf(CacheContainerAdmin.AdminFlag.class));
                    GlobalComponentRegistry gcr = SecurityActions.getGlobalComponentRegistry(this.cm);
                    ((GlobalConfigurationManager)gcr.getComponent(GlobalConfigurationManager.class)).getStateCache().getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).putIfAbsent((Object)new ScopedState("cache", cacheName), (Object)state);
                }
                catch (IOException e) {
                    throw new CacheException((Throwable)e);
                }
                String dataFile = this.dataFile(cacheName);
                String data = cacheRoot.resolve(dataFile).toString();
                ZipEntry zipEntry = zip.getEntry(data);
                if (zipEntry == null) {
                    return;
                }
                AdvancedCache cache = this.cm.getCache(cacheName).getAdvancedCache();
                ComponentRegistry cr = SecurityActions.getComponentRegistry(cache);
                CommandsFactory commandsFactory = cr.getCommandsFactory();
                KeyPartitioner keyPartitioner = (KeyPartitioner)cr.getComponent(KeyPartitioner.class);
                InvocationHelper invocationHelper = (InvocationHelper)cr.getComponent(InvocationHelper.class);
                StorageConfigurationManager scm = (StorageConfigurationManager)cr.getComponent(StorageConfigurationManager.class);
                PersistenceMarshaller persistenceMarshaller = cr.getPersistenceMarshaller();
                Marshaller userMarshaller = persistenceMarshaller.getUserMarshaller();
                boolean keyMarshalling = !scm.getKeyStorageMediaType().isBinary();
                boolean valueMarshalling = !scm.getValueStorageMediaType().isBinary();
                SerializationContextRegistry ctxRegistry = (SerializationContextRegistry)SecurityActions.getGlobalComponentRegistry(this.cm).getComponent(SerializationContextRegistry.class);
                ImmutableSerializationContext serCtx = ctxRegistry.getPersistenceCtx();
                int entries = 0;
                try (DataInputStream is = new DataInputStream(zip.getInputStream(zipEntry));){
                    while (is.available() > 0) {
                        CacheBackupEntry entry = CacheResource.readMessageStream(serCtx, CacheBackupEntry.class, is);
                        Object key = keyMarshalling ? CacheResource.unmarshall(entry.key, userMarshaller) : scm.getKeyWrapper().wrap((Object)entry.key);
                        Object value = valueMarshalling ? CacheResource.unmarshall(entry.value, userMarshaller) : scm.getValueWrapper().wrap((Object)entry.value);
                        Metadata metadata = (Metadata)CacheResource.unmarshall(entry.metadata, (Marshaller)persistenceMarshaller);
                        InternalMetadataImpl internalMetadataImpl = new InternalMetadataImpl(metadata, entry.created, entry.lastUsed);
                        PutKeyValueCommand cmd = commandsFactory.buildPutKeyValueCommand(key, value, keyPartitioner.getSegment(key), (Metadata)internalMetadataImpl, FlagBitSets.IGNORE_RETURN_VALUES);
                        cmd.setInternalMetadata(entry.internalMetadata);
                        invocationHelper.invoke((VisitableCommand)cmd, 1);
                        ++entries;
                    }
                }
                catch (IOException e) {
                    throw new CacheException((Throwable)e);
                }
                log.debugf("Cache %s restored %d entries", cacheName, entries);
            }, (Object)("restore-cache-" + cacheName)));
        }
        return stages.freeze();
    }

    private static Void createCacheFunction(String cacheName, String configXml, EmbeddedCacheManager m) {
        GlobalConfiguration globalConfig = SecurityActions.getGlobalConfiguration(m);
        log.debugf("Create cache %s locally. config=%s", cacheName, configXml);
        ConfigurationBuilderHolder cbh = new ParserRegistry().parse(configXml);
        Configuration configuration = ((ConfigurationBuilder)cbh.getNamedConfigurationBuilders().get(cacheName)).build(globalConfig);
        if (!m.getCacheConfigurationNames().contains(cacheName)) {
            m.defineConfiguration(cacheName, configuration);
        }
        m.getCache(cacheName);
        return null;
    }

    private CompletionStage<Void> createCacheBackup(String cacheName) {
        return this.blockingManager.supplyBlocking(() -> {
            DataOutputStream output;
            AdvancedCache cache = this.cm.getCache(cacheName).getAdvancedCache();
            Configuration configuration = SecurityActions.getCacheConfiguration(this.cm, cacheName);
            Path cacheRoot = this.root.resolve(cacheName);
            this.mkdirs(cacheRoot);
            String xmlFileName = this.configFile(cacheName);
            Path xmlPath = cacheRoot.resolve(xmlFileName);
            try (OutputStream os = Files.newOutputStream(xmlPath, new OpenOption[0]);){
                this.parserRegistry.serialize(os, cacheName, configuration);
            }
            catch (IOException e2) {
                throw new CacheException(String.format("Unable to create backup file '%s'", xmlFileName), (Throwable)e2);
            }
            ComponentRegistry cr = SecurityActions.getComponentRegistry(cache);
            ClusterPublisherManager clusterPublisherManager = (ClusterPublisherManager)cr.getClusterPublisherManager().running();
            SerializationContextRegistry ctxRegistry = (SerializationContextRegistry)cr.getGlobalComponentRegistry().getComponent(SerializationContextRegistry.class);
            ImmutableSerializationContext serCtx = ctxRegistry.getPersistenceCtx();
            String dataFileName = this.dataFile(cacheName);
            Path datFile = cacheRoot.resolve(dataFileName);
            StorageConfigurationManager scm = (StorageConfigurationManager)cr.getComponent(StorageConfigurationManager.class);
            boolean keyMarshalling = !scm.getKeyStorageMediaType().isBinary();
            boolean valueMarshalling = !scm.getValueStorageMediaType().isBinary();
            PersistenceMarshaller persistenceMarshaller = cr.getPersistenceMarshaller();
            Marshaller userMarshaller = persistenceMarshaller.getUserMarshaller();
            log.debugf("Backing up Cache %s", configuration.toStringConfiguration(cacheName));
            int bufferSize = configuration.clustering().stateTransfer().chunkSize();
            Flowable p = Flowable.fromPublisher((Publisher)clusterPublisherManager.entryPublisher(null, null, null, 0L, DeliveryGuarantee.EXACTLY_ONCE, bufferSize, PublisherTransformers.identity()).publisherWithoutSegments()).map(e -> {
                CacheBackupEntry be = new CacheBackupEntry();
                be.key = keyMarshalling ? this.marshall(e.getKey(), userMarshaller) : (byte[])scm.getKeyWrapper().unwrap(e.getKey());
                be.value = valueMarshalling ? this.marshall(e.getValue(), userMarshaller) : (byte[])scm.getValueWrapper().unwrap(e.getValue());
                be.metadata = this.marshall(e.getMetadata(), (Marshaller)persistenceMarshaller);
                be.internalMetadata = e.getInternalMetadata();
                be.created = e.getCreated();
                be.lastUsed = e.getLastUsed();
                return be;
            });
            try {
                output = new DataOutputStream(Files.newOutputStream(datFile, new OpenOption[0]));
            }
            catch (IOException e3) {
                throw Util.rewrapAsCacheException((Throwable)e3);
            }
            AtomicInteger entries = new AtomicInteger();
            CompletionStage stage = this.blockingManager.subscribeBlockingConsumer((Publisher)p, backup -> {
                entries.incrementAndGet();
                try {
                    CacheResource.writeMessageStream(backup, serCtx, output);
                }
                catch (IOException ex) {
                    throw Util.rewrapAsCacheException((Throwable)ex);
                }
            }, (Object)"backup-cache-entries");
            return stage.whenComplete((Void2, t) -> {
                if (t == null) {
                    log.debugf("Cache %s backed up %d entries", cacheName, entries.get());
                }
                Util.close((AutoCloseable)output);
            });
        }, (Object)"backup-cache").thenCompose(Function.identity());
    }

    private String configFile(String cache) {
        return String.format("%s.xml", cache);
    }

    private String dataFile(String cache) {
        return String.format("%s.dat", cache);
    }

    private byte[] marshall(Object key, Marshaller marshaller) {
        try {
            return marshaller.objectToByteBuffer(key);
        }
        catch (IOException | InterruptedException e) {
            throw new MarshallingException((Throwable)e);
        }
    }

    private static <T> T unmarshall(byte[] bytes, Marshaller marshaller) {
        try {
            return (T)marshaller.objectFromByteBuffer(bytes);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new MarshallingException((Throwable)e);
        }
    }

    @ProtoTypeId(value=5401)
    public static class CacheBackupEntry {
        @ProtoField(number=1)
        byte[] key;
        @ProtoField(number=2)
        byte[] value;
        @ProtoField(number=3)
        byte[] metadata;
        @ProtoField(number=4)
        PrivateMetadata internalMetadata;
        @ProtoField(number=5, defaultValue="-1")
        long created;
        @ProtoField(number=6, defaultValue="-1")
        long lastUsed;
    }
}

