/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.transaction;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.DefaultKeycloakSession;
import org.keycloak.services.resources.KeycloakApplication;

public interface TransactionalSessionHandler {
    default public KeycloakSession create() {
        KeycloakSessionFactory sessionFactory = KeycloakApplication.getSessionFactory();
        KeycloakSession session = sessionFactory.create();
        session.getTransactionManager().begin();
        return session;
    }

    default public void close(KeycloakSession session) {
        if (session == null || ((DefaultKeycloakSession)DefaultKeycloakSession.class.cast(session)).isClosed()) {
            return;
        }
        session.close();
    }
}

