/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.nio.file.Paths;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.GlobalStateConfiguration;
import org.infinispan.configuration.global.SecurityActions;

public class TemporaryGlobalStatePathConfiguration {
    public static final AttributeDefinition<String> PATH = AttributeDefinition.builder((String)"path", null, String.class).initializer(() -> Paths.get(SecurityActions.getSystemProperty("java.io.tmpdir"), new String[0]).toAbsolutePath().toString()).immutable().build();
    public static final AttributeDefinition<String> RELATIVE_TO = AttributeDefinition.builder((String)"relativeTo", null, String.class).immutable().build();
    private final Attribute<String> path;
    private final Attribute<String> relativeTo;
    private final String location;
    private final AttributeSet attributes;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalStateConfiguration.class, new AttributeDefinition[]{PATH, RELATIVE_TO});
    }

    public TemporaryGlobalStatePathConfiguration(AttributeSet attributes, String location) {
        this.attributes = attributes.checkProtection();
        this.path = attributes.attribute(PATH);
        this.relativeTo = attributes.attribute(RELATIVE_TO);
        this.location = location;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String getLocation() {
        return this.location;
    }

    public String path() {
        return (String)this.path.get();
    }

    public String relativeTo() {
        return (String)this.relativeTo.get();
    }
}

