/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.client;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.infinispan.api.annotations.indexing.Basic;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.api.annotations.indexing.Keyword;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoField;
import org.keycloak.models.map.annotations.IgnoreForEntityImplementationGenerator;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.storage.hotRod.client.HotRodClientEntityDelegate;
import org.keycloak.models.map.storage.hotRod.client.HotRodClientEntitySchemaImpl;
import org.keycloak.models.map.storage.hotRod.client.HotRodProtocolMapperEntity;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.CommonPrimitivesProtoSchemaInitializer;
import org.keycloak.models.map.storage.hotRod.common.HotRodAttributeEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodPair;
import org.keycloak.models.map.storage.hotRod.common.UpdatableHotRodEntityDelegateImpl;

@Indexed
@ProtoDoc(value="schema-version: 1")
public class HotRodClientEntity
extends AbstractHotRodEntity {
    @IgnoreForEntityImplementationGenerator
    public static final int VERSION = 1;
    @Basic(projectable=true)
    @ProtoField(number=1)
    public Integer entityVersion = 1;
    @Basic(projectable=true, sortable=true)
    @ProtoField(number=2)
    public String id;
    @Basic(sortable=true)
    @ProtoField(number=3)
    public String realmId;
    @Keyword(sortable=true, normalizer="lowercase")
    @ProtoField(number=4)
    public String clientId;
    @ProtoField(number=5)
    public String name;
    @ProtoField(number=6)
    public String description;
    @ProtoField(number=7)
    public Set<String> redirectUris;
    @ProtoField(number=8)
    public Boolean enabled;
    @ProtoField(number=9)
    public Boolean alwaysDisplayInConsole;
    @ProtoField(number=10)
    public String clientAuthenticatorType;
    @ProtoField(number=11)
    public String secret;
    @ProtoField(number=12)
    public String registrationToken;
    @ProtoField(number=13)
    public String protocol;
    @Basic(sortable=true)
    @ProtoField(number=14)
    public Set<HotRodAttributeEntity> attributes;
    @ProtoField(number=15)
    public Set<HotRodPair<String, String>> authenticationFlowBindingOverrides;
    @ProtoField(number=16)
    public Boolean publicClient;
    @ProtoField(number=17)
    public Boolean fullScopeAllowed;
    @ProtoField(number=18)
    public Boolean frontchannelLogout;
    @ProtoField(number=19)
    public Long notBefore;
    @ProtoField(number=20)
    public Set<String> scope;
    @ProtoField(number=21)
    public Set<String> webOrigins;
    @ProtoField(number=22)
    public Set<HotRodProtocolMapperEntity> protocolMappers;
    @ProtoField(number=23)
    public Set<HotRodPair<String, Boolean>> clientScopes;
    @Basic(sortable=true)
    @ProtoField(number=24, collectionImplementation=LinkedList.class)
    public Collection<String> scopeMappings;
    @ProtoField(number=25)
    public Boolean surrogateAuthRequired;
    @ProtoField(number=26)
    public String managementUrl;
    @ProtoField(number=27)
    public String baseUrl;
    @ProtoField(number=28)
    public Boolean bearerOnly;
    @ProtoField(number=29)
    public Boolean consentRequired;
    @ProtoField(number=30)
    public String rootUrl;
    @ProtoField(number=31)
    public Boolean standardFlowEnabled;
    @ProtoField(number=32)
    public Boolean implicitFlowEnabled;
    @ProtoField(number=33)
    public Boolean directAccessGrantsEnabled;
    @ProtoField(number=34)
    public Boolean serviceAccountsEnabled;
    @ProtoField(number=35)
    public Integer nodeReRegistrationTimeout;

    public boolean equals(Object o) {
        return HotRodClientEntityDelegate.entityEquals(this, o);
    }

    public int hashCode() {
        return HotRodClientEntityDelegate.entityHashCode(this);
    }

    public static abstract class AbstractHotRodClientEntityDelegate
    extends UpdatableHotRodEntityDelegateImpl<HotRodClientEntity>
    implements MapClientEntity {
        public String getId() {
            return ((HotRodClientEntity)this.getHotRodEntity()).id;
        }

        public void setId(String id) {
            HotRodClientEntity entity = (HotRodClientEntity)this.getHotRodEntity();
            if (entity.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            entity.id = id;
            entity.updated = entity.updated | id != null;
        }

        public void setClientId(String clientId) {
            HotRodClientEntity entity = (HotRodClientEntity)this.getHotRodEntity();
            entity.updated = entity.updated | !Objects.equals(entity.clientId, clientId);
            entity.clientId = clientId;
        }

        public Stream<String> getClientScopes(boolean defaultScope) {
            Map clientScopes = this.getClientScopes();
            return clientScopes == null ? Stream.empty() : clientScopes.entrySet().stream().filter(me -> Objects.equals(me.getValue(), defaultScope)).map(Map.Entry::getKey);
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={HotRodClientEntity.class, HotRodProtocolMapperEntity.class}, schemaFilePath="proto/", schemaPackageName="kc", dependsOn={CommonPrimitivesProtoSchemaInitializer.class})
    public static interface HotRodClientEntitySchema
    extends GeneratedSchema {
        public static final HotRodClientEntitySchema INSTANCE = new HotRodClientEntitySchemaImpl();
    }
}

