/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.deployment;

import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.change.Change;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.database.Database;
import liquibase.datatype.LiquibaseDataType;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.executor.Executor;
import liquibase.lockservice.LockService;
import liquibase.lockservice.StandardLockService;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.NamespaceDetails;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.precondition.Precondition;
import liquibase.servicelocator.LiquibaseService;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.sqlgenerator.SqlGenerator;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.keycloak.config.StorageOptions;
import org.keycloak.connections.jpa.updater.liquibase.lock.DummyLockService;
import org.keycloak.quarkus.deployment.KeycloakProcessor;
import org.keycloak.quarkus.runtime.KeycloakRecorder;
import org.keycloak.quarkus.runtime.configuration.Configuration;

class LiquibaseProcessor {
    LiquibaseProcessor() {
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void configure(KeycloakRecorder recorder, List<JdbcDataSourceBuildItem> jdbcDataSources, CombinedIndexBuildItem indexBuildItem) {
        DotName liquibaseServiceName = DotName.createSimple((String)LiquibaseService.class.getName());
        HashMap<String, List<Object>> services = new HashMap<String, List<Object>>();
        IndexView index = indexBuildItem.getIndex();
        JdbcDataSourceBuildItem dataSourceBuildItem = KeycloakProcessor.getDefaultDataSource(jdbcDataSources);
        String dbKind = dataSourceBuildItem.getDbKind();
        for (Class c : Arrays.asList(DatabaseObjectComparator.class, NamespaceDetails.class, Precondition.class, Database.class, Change.class, SnapshotGenerator.class, ChangeLogHistoryService.class, LiquibaseDataType.class, Executor.class, SqlGenerator.class)) {
            ArrayList<String> impls = new ArrayList<String>();
            services.put(c.getName(), impls);
            HashSet<ClassInfo> classes = new HashSet<ClassInfo>();
            if (c.isInterface()) {
                classes.addAll(index.getAllKnownImplementors(DotName.createSimple((String)c.getName())));
            } else {
                classes.addAll(index.getAllKnownSubclasses(DotName.createSimple((String)c.getName())));
            }
            this.filterImplementations(c, dbKind, classes);
            for (ClassInfo found : classes) {
                AnnotationInstance annotationInstance;
                if (Modifier.isAbstract(found.flags()) || Modifier.isInterface(found.flags()) || !found.hasNoArgsConstructor() || !Modifier.isPublic(found.flags()) || (annotationInstance = found.classAnnotation(liquibaseServiceName)) != null && annotationInstance.value("skip").asBoolean()) continue;
                impls.add(found.name().toString());
            }
        }
        if (StorageOptions.StorageType.jpa.name().equals(Configuration.getOptionalValue((String)"kc.".concat(StorageOptions.STORAGE.getKey())).orElse(null))) {
            services.put(LockService.class.getName(), Collections.singletonList(StandardLockService.class.getName()));
        } else {
            services.put(LockService.class.getName(), Collections.singletonList(DummyLockService.class.getName()));
        }
        services.put(ChangeLogParser.class.getName(), Collections.singletonList(XMLChangeLogSAXParser.class.getName()));
        recorder.configureLiquibase(services);
    }

    private void filterImplementations(Class<?> types, String dbKind, Set<ClassInfo> classes) {
        if (Database.class.equals(types)) {
            classes.removeIf(classInfo -> !org.keycloak.config.database.Database.isLiquibaseDatabaseSupported((String)classInfo.name().toString(), (String)dbKind));
        }
    }
}

