/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.authorization.permission.entity;

import java.util.Objects;
import java.util.UUID;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.keycloak.models.map.authorization.entity.MapPermissionTicketEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UuidValidator;
import org.keycloak.models.map.storage.jpa.Constants;
import org.keycloak.models.map.storage.jpa.JpaRootVersionedEntity;
import org.keycloak.models.map.storage.jpa.authorization.permission.entity.JpaPermissionMetadata;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;

@Entity
@Table(name="kc_authz_permission", uniqueConstraints={@UniqueConstraint(columnNames={"realmId", "resourceServerId", "scopeId", "resourceId", "owner", "requester"})})
@TypeDefs(value={@TypeDef(name="jsonb", typeClass=JsonbType.class)})
public class JpaPermissionEntity
extends MapPermissionTicketEntity.AbstractMapPermissionTicketEntity
implements JpaRootVersionedEntity,
ManagedEntity,
PersistentAttributeInterceptable {
    @Id
    @Column
    private UUID id;
    @Version
    @Column
    private int version;
    @Type(type="jsonb")
    @Column(columnDefinition="jsonb")
    private JpaPermissionMetadata metadata;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private Integer entityVersion;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String realmId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String owner;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String requester;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private UUID resourceServerId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private UUID scopeId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private UUID policyId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private UUID resourceId;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;

    public JpaPermissionEntity() {
        this.metadata = new JpaPermissionMetadata();
    }

    public JpaPermissionEntity(DeepCloner cloner) {
        this.metadata = new JpaPermissionMetadata(cloner);
    }

    public JpaPermissionEntity(UUID id, int version, Integer entityVersion, String realmId, UUID resourceServerId, String owner, UUID scopeId, UUID policyId, String requester, UUID resourceId) {
        this.$$_hibernate_write_id(id);
        this.$$_hibernate_write_version(version);
        this.$$_hibernate_write_entityVersion(entityVersion);
        this.$$_hibernate_write_realmId(realmId);
        this.$$_hibernate_write_resourceServerId(resourceServerId);
        this.$$_hibernate_write_owner(owner);
        this.$$_hibernate_write_scopeId(scopeId);
        this.$$_hibernate_write_policyId(policyId);
        this.$$_hibernate_write_requester(requester);
        this.$$_hibernate_write_resourceId(resourceId);
        this.metadata = null;
    }

    public boolean isMetadataInitialized() {
        return this.$$_hibernate_read_metadata() != null;
    }

    @Override
    public Integer getEntityVersion() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getEntityVersion();
        }
        return this.$$_hibernate_read_entityVersion();
    }

    @Override
    public void setEntityVersion(Integer entityVersion) {
        this.$$_hibernate_read_metadata().setEntityVersion(entityVersion);
    }

    @Override
    public Integer getCurrentSchemaVersion() {
        return Constants.CURRENT_SCHEMA_VERSION_AUTHZ_PERMISSION;
    }

    @Override
    public int getVersion() {
        return this.$$_hibernate_read_version();
    }

    public String getId() {
        return this.$$_hibernate_read_id() == null ? null : this.$$_hibernate_read_id().toString();
    }

    public void setId(String id) {
        String validatedId = UuidValidator.validateAndConvert((String)id);
        this.$$_hibernate_write_id(UUID.fromString(validatedId));
    }

    public String getRealmId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getRealmId();
        }
        return this.$$_hibernate_read_realmId();
    }

    public void setRealmId(String realmId) {
        this.$$_hibernate_read_metadata().setRealmId(realmId);
    }

    public String getOwner() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getOwner();
        }
        return this.$$_hibernate_read_owner();
    }

    public void setOwner(String owner) {
        this.$$_hibernate_read_metadata().setOwner(owner);
    }

    public String getRequester() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getRequester();
        }
        return this.$$_hibernate_read_requester();
    }

    public void setRequester(String requester) {
        this.$$_hibernate_read_metadata().setRequester(requester);
    }

    public Long getCreatedTimestamp() {
        return this.$$_hibernate_read_metadata().getCreatedTimestamp();
    }

    public void setCreatedTimestamp(Long createdTimestamp) {
        this.$$_hibernate_read_metadata().setCreatedTimestamp(createdTimestamp);
    }

    public Long getGrantedTimestamp() {
        return this.$$_hibernate_read_metadata().getGrantedTimestamp();
    }

    public void setGrantedTimestamp(Long grantedTimestamp) {
        this.$$_hibernate_read_metadata().setGrantedTimestamp(grantedTimestamp);
    }

    public String getResourceId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getResourceId();
        }
        return this.$$_hibernate_read_resourceId() == null ? null : this.$$_hibernate_read_resourceId().toString();
    }

    public void setResourceId(String resourceId) {
        this.$$_hibernate_read_metadata().setResourceId(resourceId);
    }

    public String getScopeId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getScopeId();
        }
        return this.$$_hibernate_read_scopeId() == null ? null : this.$$_hibernate_read_scopeId().toString();
    }

    public void setScopeId(String scopeId) {
        this.$$_hibernate_read_metadata().setScopeId(scopeId);
    }

    public String getResourceServerId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getResourceServerId();
        }
        return this.$$_hibernate_read_resourceServerId() == null ? null : this.$$_hibernate_read_resourceServerId().toString();
    }

    public void setResourceServerId(String resourceServerId) {
        this.$$_hibernate_read_metadata().setResourceServerId(resourceServerId);
    }

    public String getPolicyId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getPolicyId();
        }
        return this.$$_hibernate_read_policyId() == null ? null : this.$$_hibernate_read_policyId().toString();
    }

    public void setPolicyId(String policyId) {
        this.$$_hibernate_read_metadata().setPolicyId(policyId);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JpaPermissionEntity)) {
            return false;
        }
        return Objects.equals(this.getId(), ((JpaPermissionEntity)obj).getId());
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public UUID $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)uUID);
            return;
        }
        this.id = uUID;
    }

    public int $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().readInt((Object)this, "version", this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(int n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().writeInt((Object)this, "version", this.version, n);
            return;
        }
        this.version = n;
    }

    public JpaPermissionMetadata $$_hibernate_read_metadata() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.metadata = (JpaPermissionMetadata)this.$$_hibernate_getInterceptor().readObject((Object)this, "metadata", (Object)this.metadata);
        }
        return this.metadata;
    }

    public Integer $$_hibernate_read_entityVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "entityVersion", (Object)this.entityVersion);
        }
        return this.entityVersion;
    }

    public void $$_hibernate_write_entityVersion(Integer n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "entityVersion", (Object)this.entityVersion, (Object)n);
            return;
        }
        this.entityVersion = n;
    }

    public String $$_hibernate_read_realmId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "realmId", (Object)this.realmId);
        }
        return this.realmId;
    }

    public void $$_hibernate_write_realmId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "realmId", (Object)this.realmId, (Object)string);
            return;
        }
        this.realmId = string;
    }

    public String $$_hibernate_read_owner() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "owner", (Object)this.owner);
        }
        return this.owner;
    }

    public void $$_hibernate_write_owner(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "owner", (Object)this.owner, (Object)string);
            return;
        }
        this.owner = string;
    }

    public String $$_hibernate_read_requester() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.requester = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "requester", (Object)this.requester);
        }
        return this.requester;
    }

    public void $$_hibernate_write_requester(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.requester = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "requester", (Object)this.requester, (Object)string);
            return;
        }
        this.requester = string;
    }

    public UUID $$_hibernate_read_resourceServerId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceServerId = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "resourceServerId", (Object)this.resourceServerId);
        }
        return this.resourceServerId;
    }

    public void $$_hibernate_write_resourceServerId(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceServerId = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "resourceServerId", (Object)this.resourceServerId, (Object)uUID);
            return;
        }
        this.resourceServerId = uUID;
    }

    public UUID $$_hibernate_read_scopeId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.scopeId = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "scopeId", (Object)this.scopeId);
        }
        return this.scopeId;
    }

    public void $$_hibernate_write_scopeId(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.scopeId = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "scopeId", (Object)this.scopeId, (Object)uUID);
            return;
        }
        this.scopeId = uUID;
    }

    public UUID $$_hibernate_read_policyId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.policyId = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "policyId", (Object)this.policyId);
        }
        return this.policyId;
    }

    public void $$_hibernate_write_policyId(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.policyId = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "policyId", (Object)this.policyId, (Object)uUID);
            return;
        }
        this.policyId = uUID;
    }

    public UUID $$_hibernate_read_resourceId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceId = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "resourceId", (Object)this.resourceId);
        }
        return this.resourceId;
    }

    public void $$_hibernate_write_resourceId(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceId = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "resourceId", (Object)this.resourceId, (Object)uUID);
            return;
        }
        this.resourceId = uUID;
    }
}

