/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.RequestScopedSessionHolder;
import io.quarkus.hibernate.orm.runtime.session.TransactionScopedSession;
import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

@ApplicationScoped
public class TransactionSessions {
    @Inject
    JPAConfig jpaConfig;
    @Inject
    Instance<RequestScopedSessionHolder> requestScopedSession;
    private final ConcurrentMap<String, TransactionScopedSession> sessions = new ConcurrentHashMap<String, TransactionScopedSession>();

    public Session getSession(String unitName) {
        TransactionScopedSession session = (TransactionScopedSession)this.sessions.get(unitName);
        if (session != null) {
            return session;
        }
        return this.sessions.computeIfAbsent(unitName, un -> new TransactionScopedSession(this.getTransactionManager(), this.getTransactionSynchronizationRegistry(), (SessionFactory)this.jpaConfig.getEntityManagerFactory((String)un).unwrap(SessionFactory.class), (String)un, this.requestScopedSession));
    }

    private TransactionManager getTransactionManager() {
        return (TransactionManager)Arc.container().instance(TransactionManager.class, new Annotation[0]).get();
    }

    private TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return (TransactionSynchronizationRegistry)Arc.container().instance(TransactionSynchronizationRegistry.class, new Annotation[0]).get();
    }
}

