/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.service;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.id.Assigned;
import org.hibernate.id.Configurable;
import org.hibernate.id.ForeignGenerator;
import org.hibernate.id.GUIDGenerator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.IncrementGenerator;
import org.hibernate.id.SelectGenerator;
import org.hibernate.id.SequenceHiLoGenerator;
import org.hibernate.id.SequenceIdentityGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.id.factory.spi.MutableIdentifierGeneratorFactory;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.Type;

final class QuarkusSimplifiedIdentifierGeneratorFactory
implements MutableIdentifierGeneratorFactory,
ServiceRegistryAwareService {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(QuarkusSimplifiedIdentifierGeneratorFactory.class);
    private ServiceRegistry serviceRegistry;
    private Dialect dialect;
    private ConcurrentHashMap<String, Class> generatorStrategyToClassNameMap = new ConcurrentHashMap();

    public QuarkusSimplifiedIdentifierGeneratorFactory() {
        this.register("uuid2", UUIDGenerator.class);
        this.register("guid", GUIDGenerator.class);
        this.register("uuid", UUIDHexGenerator.class);
        this.register("uuid.hex", UUIDHexGenerator.class);
        this.register("assigned", Assigned.class);
        this.register("identity", IdentityGenerator.class);
        this.register("select", SelectGenerator.class);
        this.register("sequence", SequenceStyleGenerator.class);
        this.register("seqhilo", SequenceHiLoGenerator.class);
        this.register("increment", IncrementGenerator.class);
        this.register("foreign", ForeignGenerator.class);
        this.register("sequence-identity", SequenceIdentityGenerator.class);
        this.register("enhanced-sequence", SequenceStyleGenerator.class);
        this.register("enhanced-table", TableGenerator.class);
    }

    public void register(String strategy, Class generatorClass) {
        LOG.debugf("Registering IdentifierGenerator strategy [%s] -> [%s]", (Object)strategy, (Object)generatorClass.getName());
        Class previous = this.generatorStrategyToClassNameMap.put(strategy, generatorClass);
        if (previous != null) {
            LOG.debugf("    - overriding [%s]", (Object)previous.getName());
        }
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
    }

    public IdentifierGenerator createIdentifierGenerator(String strategy, Type type, Properties config) {
        try {
            Class clazz = this.getIdentifierGeneratorClass(strategy);
            IdentifierGenerator identifierGenerator = (IdentifierGenerator)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (identifierGenerator instanceof Configurable) {
                identifierGenerator.configure(type, config, this.serviceRegistry);
            }
            return identifierGenerator;
        }
        catch (Exception e) {
            String entityName = config.getProperty("entity_name");
            throw new MappingException("Could not instantiate id generator [entity-name=" + entityName + "]", (Throwable)e);
        }
    }

    public Class getIdentifierGeneratorClass(String strategy) {
        if ("hilo".equals(strategy)) {
            throw new UnsupportedOperationException("Support for 'hilo' generator has been removed");
        }
        String resolvedStrategy = "native".equals(strategy) ? this.getDialect().getNativeIdentifierGeneratorStrategy() : strategy;
        Class generatorClass = this.generatorStrategyToClassNameMap.get(resolvedStrategy);
        try {
            if (generatorClass == null) {
                ClassLoaderService cls = (ClassLoaderService)this.serviceRegistry.getService(ClassLoaderService.class);
                generatorClass = cls.classForName(resolvedStrategy);
            }
        }
        catch (ClassLoadingException e) {
            throw new MappingException("Could not interpret id generator strategy [" + strategy + "]");
        }
        return generatorClass;
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.dialect = ((JdbcEnvironment)serviceRegistry.getService(JdbcEnvironment.class)).getDialect();
    }
}

