/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Function;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.UnresolvedTypeVariable;
import org.jboss.jandex.WildcardType;
import org.objectweb.asm.MethodVisitor;

public class AsmUtil {
    private static boolean hasThrowsSignature(MethodInfo method) {
        for (Type type : method.exceptions()) {
            if (type.kind() != Type.Kind.TYPE_VARIABLE && type.kind() != Type.Kind.UNRESOLVED_TYPE_VARIABLE) continue;
            return true;
        }
        return false;
    }

    private static void typeParameter(TypeVariable typeParameter, StringBuilder result, Function<String, String> typeArgMapper) {
        result.append(typeParameter.identifier());
        if (AsmUtil.hasImplicitObjectBound(typeParameter)) {
            result.append(':');
        }
        for (Type bound : typeParameter.bounds()) {
            result.append(':');
            AsmUtil.toSignature(result, bound, typeArgMapper, false);
        }
    }

    private static boolean hasImplicitObjectBound(TypeVariable typeParameter) {
        boolean result = false;
        try {
            Method method = TypeVariable.class.getDeclaredMethod("hasImplicitObjectBound", new Class[0]);
            method.setAccessible(true);
            result = (Boolean)method.invoke((Object)typeParameter, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static String getDescriptor(MethodInfo method, Function<String, String> typeArgMapper) {
        List parameters = method.parameterTypes();
        StringBuilder descriptor = new StringBuilder("(");
        for (Type type : parameters) {
            AsmUtil.toSignature(descriptor, type, typeArgMapper, true);
        }
        descriptor.append(")");
        AsmUtil.toSignature(descriptor, method.returnType(), typeArgMapper, true);
        return descriptor.toString();
    }

    public static String getDescriptor(Type type, Function<String, String> typeArgMapper) {
        StringBuilder sb = new StringBuilder();
        AsmUtil.toSignature(sb, type, typeArgMapper, true);
        return sb.toString();
    }

    public static String getSignature(Type type, Function<String, String> typeArgMapper) {
        StringBuilder sb = new StringBuilder();
        AsmUtil.toSignature(sb, type, typeArgMapper, false);
        return sb.toString();
    }

    private static void toSignature(StringBuilder sb, Type type, Function<String, String> typeArgMapper, boolean erased) {
        switch (type.kind()) {
            case ARRAY: {
                ArrayType arrayType = type.asArrayType();
                for (int i = 0; i < arrayType.dimensions(); ++i) {
                    sb.append('[');
                }
                AsmUtil.toSignature(sb, arrayType.component(), typeArgMapper, erased);
                break;
            }
            case CLASS: {
                sb.append('L').append(type.asClassType().name().toString('/')).append(';');
                break;
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType parameterizedType = type.asParameterizedType();
                Type owner = parameterizedType.owner();
                if (owner != null && owner.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                    AsmUtil.toSignature(sb, owner, typeArgMapper, erased);
                    assert (sb.charAt(sb.length() - 1) == ';');
                    sb.setCharAt(sb.length() - 1, '.');
                    sb.append(parameterizedType.name().local());
                } else {
                    sb.append('L').append(parameterizedType.name().toString('/'));
                }
                if (!erased && !parameterizedType.arguments().isEmpty()) {
                    sb.append('<');
                    for (Type argument : parameterizedType.arguments()) {
                        AsmUtil.toSignature(sb, argument, typeArgMapper, erased);
                    }
                    sb.append('>');
                }
                sb.append(';');
                break;
            }
            case PRIMITIVE: {
                PrimitiveType.Primitive primitive = type.asPrimitiveType().primitive();
                switch (primitive) {
                    case BOOLEAN: {
                        sb.append('Z');
                        break;
                    }
                    case BYTE: {
                        sb.append('B');
                        break;
                    }
                    case CHAR: {
                        sb.append('C');
                        break;
                    }
                    case DOUBLE: {
                        sb.append('D');
                        break;
                    }
                    case FLOAT: {
                        sb.append('F');
                        break;
                    }
                    case INT: {
                        sb.append('I');
                        break;
                    }
                    case LONG: {
                        sb.append('J');
                        break;
                    }
                    case SHORT: {
                        sb.append('S');
                    }
                }
                break;
            }
            case TYPE_VARIABLE: {
                TypeVariable typeVariable = type.asTypeVariable();
                String mappedSignature = typeArgMapper.apply(typeVariable.identifier());
                if (mappedSignature != null) {
                    sb.append(mappedSignature);
                    break;
                }
                if (erased) {
                    AsmUtil.toSignature(sb, (Type)typeVariable.bounds().get(0), typeArgMapper, erased);
                    break;
                }
                sb.append('T').append(typeVariable.identifier()).append(';');
                break;
            }
            case UNRESOLVED_TYPE_VARIABLE: {
                UnresolvedTypeVariable unresolvedTypeVariable = type.asUnresolvedTypeVariable();
                String mappedSignature2 = typeArgMapper.apply(unresolvedTypeVariable.identifier());
                if (mappedSignature2 != null) {
                    sb.append(mappedSignature2);
                    break;
                }
                if (erased) break;
                sb.append("T").append(unresolvedTypeVariable.identifier()).append(";");
                break;
            }
            case VOID: {
                sb.append('V');
                break;
            }
            case WILDCARD_TYPE: {
                if (erased) break;
                WildcardType wildcardType = type.asWildcardType();
                if (wildcardType.superBound() != null) {
                    sb.append('-');
                    AsmUtil.toSignature(sb, wildcardType.superBound(), typeArgMapper, erased);
                    break;
                }
                if (ClassType.OBJECT_TYPE.equals((Object)wildcardType.extendsBound())) {
                    sb.append('*');
                    break;
                }
                sb.append('+');
                AsmUtil.toSignature(sb, wildcardType.extendsBound(), typeArgMapper, erased);
                break;
            }
        }
    }

    public static void unboxIfRequired(MethodVisitor mv, Type jandexType) {
        if (jandexType.kind() == Type.Kind.PRIMITIVE) {
            switch (jandexType.asPrimitiveType().primitive()) {
                case BOOLEAN: {
                    AsmUtil.unbox(mv, "java/lang/Boolean", "booleanValue", "Z");
                    break;
                }
                case BYTE: {
                    AsmUtil.unbox(mv, "java/lang/Byte", "byteValue", "B");
                    break;
                }
                case CHAR: {
                    AsmUtil.unbox(mv, "java/lang/Character", "charValue", "C");
                    break;
                }
                case DOUBLE: {
                    AsmUtil.unbox(mv, "java/lang/Double", "doubleValue", "D");
                    break;
                }
                case FLOAT: {
                    AsmUtil.unbox(mv, "java/lang/Float", "floatValue", "F");
                    break;
                }
                case INT: {
                    AsmUtil.unbox(mv, "java/lang/Integer", "intValue", "I");
                    break;
                }
                case LONG: {
                    AsmUtil.unbox(mv, "java/lang/Long", "longValue", "J");
                    break;
                }
                case SHORT: {
                    AsmUtil.unbox(mv, "java/lang/Short", "shortValue", "S");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown primitive type: " + jandexType);
                }
            }
        }
    }

    public static void unboxIfRequired(MethodVisitor mv, org.objectweb.asm.Type type) {
        if (type.getSort() <= 8) {
            switch (type.getSort()) {
                case 1: {
                    AsmUtil.unbox(mv, "java/lang/Boolean", "booleanValue", "Z");
                    break;
                }
                case 3: {
                    AsmUtil.unbox(mv, "java/lang/Byte", "byteValue", "B");
                    break;
                }
                case 2: {
                    AsmUtil.unbox(mv, "java/lang/Character", "charValue", "C");
                    break;
                }
                case 8: {
                    AsmUtil.unbox(mv, "java/lang/Double", "doubleValue", "D");
                    break;
                }
                case 6: {
                    AsmUtil.unbox(mv, "java/lang/Float", "floatValue", "F");
                    break;
                }
                case 5: {
                    AsmUtil.unbox(mv, "java/lang/Integer", "intValue", "I");
                    break;
                }
                case 7: {
                    AsmUtil.unbox(mv, "java/lang/Long", "longValue", "J");
                    break;
                }
                case 4: {
                    AsmUtil.unbox(mv, "java/lang/Short", "shortValue", "S");
                }
            }
        }
    }

    private static void unbox(MethodVisitor mv, String owner, String methodName, String returnTypeSignature) {
        mv.visitTypeInsn(192, owner);
        mv.visitMethodInsn(182, owner, methodName, "()" + returnTypeSignature, false);
    }
}

