/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.logs.SdkLogEmitterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OpenTelemetrySdk
implements OpenTelemetry {
    private final ObfuscatedTracerProvider tracerProvider;
    private final ObfuscatedMeterProvider meterProvider;
    private final SdkLogEmitterProvider logEmitterProvider;
    private final ContextPropagators propagators;

    OpenTelemetrySdk(SdkTracerProvider tracerProvider, SdkMeterProvider meterProvider, SdkLogEmitterProvider logEmitterProvider, ContextPropagators propagators) {
        this.tracerProvider = new ObfuscatedTracerProvider(tracerProvider);
        this.meterProvider = new ObfuscatedMeterProvider(meterProvider);
        this.logEmitterProvider = logEmitterProvider;
        this.propagators = propagators;
    }

    public static OpenTelemetrySdkBuilder builder() {
        return new OpenTelemetrySdkBuilder();
    }

    public TracerProvider getTracerProvider() {
        return this.tracerProvider;
    }

    public SdkTracerProvider getSdkTracerProvider() {
        return this.tracerProvider.unobfuscate();
    }

    public MeterProvider getMeterProvider() {
        return this.meterProvider;
    }

    public SdkMeterProvider getSdkMeterProvider() {
        return this.meterProvider.unobfuscate();
    }

    public SdkLogEmitterProvider getSdkLogEmitterProvider() {
        return this.logEmitterProvider;
    }

    public ContextPropagators getPropagators() {
        return this.propagators;
    }

    public String toString() {
        return "OpenTelemetrySdk{tracerProvider=" + this.tracerProvider.unobfuscate() + ", meterProvider=" + this.meterProvider.unobfuscate() + "}";
    }

    @ThreadSafe
    static class ObfuscatedTracerProvider
    implements TracerProvider {
        private final SdkTracerProvider delegate;

        ObfuscatedTracerProvider(SdkTracerProvider delegate) {
            this.delegate = delegate;
        }

        public Tracer get(String instrumentationScopeName) {
            return this.delegate.get(instrumentationScopeName);
        }

        public Tracer get(String instrumentationScopeName, String instrumentationScopeVersion) {
            return this.delegate.get(instrumentationScopeName, instrumentationScopeVersion);
        }

        public TracerBuilder tracerBuilder(String instrumentationScopeName) {
            return this.delegate.tracerBuilder(instrumentationScopeName);
        }

        public SdkTracerProvider unobfuscate() {
            return this.delegate;
        }
    }

    @ThreadSafe
    static class ObfuscatedMeterProvider
    implements MeterProvider {
        private final SdkMeterProvider delegate;

        ObfuscatedMeterProvider(SdkMeterProvider delegate) {
            this.delegate = delegate;
        }

        public MeterBuilder meterBuilder(String instrumentationScopeName) {
            return this.delegate.meterBuilder(instrumentationScopeName);
        }

        public SdkMeterProvider unobfuscate() {
            return this.delegate;
        }
    }
}

