/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.AbstractLoginProtocolFactory;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.protocol.saml.SamlProtocol;
import org.keycloak.protocol.saml.SamlRepresentationAttributes;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.protocol.saml.mappers.RoleListMapper;
import org.keycloak.protocol.saml.mappers.UserPropertyAttributeStatementMapper;
import org.keycloak.representations.idm.CertificateRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.constants.X500SAMLProfileConstants;
import org.keycloak.saml.validators.DestinationValidator;

public class SamlProtocolFactory
extends AbstractLoginProtocolFactory {
    public static final String SCOPE_ROLE_LIST = "role_list";
    private static final String ROLE_LIST_CONSENT_TEXT = "${samlRoleListScopeConsentText}";
    private DestinationValidator destinationValidator;
    private Map<String, ProtocolMapperModel> builtins = new HashMap<String, ProtocolMapperModel>();
    private List<ProtocolMapperModel> defaultBuiltins = new ArrayList<ProtocolMapperModel>();

    public Object createProtocolEndpoint(KeycloakSession session, EventBuilder event) {
        return new SamlService(session, event, this.destinationValidator);
    }

    public LoginProtocol create(KeycloakSession session) {
        return new SamlProtocol().setSession(session);
    }

    public void init(Config.Scope config) {
        ProtocolMapperModel model = UserPropertyAttributeStatementMapper.createAttributeMapper("X500 email", "email", X500SAMLProfileConstants.EMAIL.get(), JBossSAMLURIConstants.ATTRIBUTE_FORMAT_URI.get(), X500SAMLProfileConstants.EMAIL.getFriendlyName(), true, "${email}");
        this.builtins.put("X500 email", model);
        model = UserPropertyAttributeStatementMapper.createAttributeMapper("X500 givenName", "firstName", X500SAMLProfileConstants.GIVEN_NAME.get(), JBossSAMLURIConstants.ATTRIBUTE_FORMAT_URI.get(), X500SAMLProfileConstants.GIVEN_NAME.getFriendlyName(), true, "${givenName}");
        this.builtins.put("X500 givenName", model);
        model = UserPropertyAttributeStatementMapper.createAttributeMapper("X500 surname", "lastName", X500SAMLProfileConstants.SURNAME.get(), JBossSAMLURIConstants.ATTRIBUTE_FORMAT_URI.get(), X500SAMLProfileConstants.SURNAME.getFriendlyName(), true, "${familyName}");
        this.builtins.put("X500 surname", model);
        model = RoleListMapper.create("role list", "Role", "Basic", null, false);
        this.builtins.put("role list", model);
        this.defaultBuiltins.add(model);
        this.destinationValidator = DestinationValidator.forProtocolMap((String[])config.getArray("knownProtocols"));
    }

    public String getId() {
        return "saml";
    }

    public Map<String, ProtocolMapperModel> getBuiltinMappers() {
        return this.builtins;
    }

    protected void createDefaultClientScopesImpl(RealmModel newRealm) {
        ClientScopeModel roleListScope = newRealm.addClientScope(SCOPE_ROLE_LIST);
        roleListScope.setDescription("SAML role list");
        roleListScope.setDisplayOnConsentScreen(true);
        roleListScope.setConsentScreenText(ROLE_LIST_CONSENT_TEXT);
        roleListScope.setProtocol(this.getId());
        roleListScope.addProtocolMapper(this.builtins.get("role list"));
        newRealm.addDefaultClientScope(roleListScope, true);
    }

    protected void addDefaults(ClientModel client) {
    }

    public void setupClientDefaults(ClientRepresentation clientRep, ClientModel newClient) {
        SamlRepresentationAttributes rep = new SamlRepresentationAttributes(clientRep.getAttributes());
        SamlClient client = new SamlClient(newClient);
        if (clientRep.isStandardFlowEnabled() == null) {
            newClient.setStandardFlowEnabled(true);
        }
        if (rep.getCanonicalizationMethod() == null) {
            client.setCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#");
        }
        if (rep.getSignatureAlgorithm() == null) {
            client.setSignatureAlgorithm(SignatureAlgorithm.RSA_SHA256);
        }
        if (rep.getNameIDFormat() == null) {
            client.setNameIDFormat("username");
        }
        if (rep.getIncludeAuthnStatement() == null) {
            client.setIncludeAuthnStatement(true);
        }
        if (rep.getForceNameIDFormat() == null) {
            client.setForceNameIDFormat(false);
        }
        if (rep.getAllowEcpFlow() == null) {
            client.setAllowECPFlow(false);
        }
        if (rep.getSamlServerSignature() == null) {
            client.setRequiresRealmSignature(true);
        }
        if (rep.getForcePostBinding() == null) {
            client.setForcePostBinding(true);
        }
        if (rep.getClientSignature() == null) {
            client.setRequiresClientSignature(true);
        }
        if (client.requiresClientSignature() && client.getClientSigningCertificate() == null) {
            CertificateRepresentation info = KeycloakModelUtils.generateKeyPairCertificate((String)newClient.getClientId());
            client.setClientSigningCertificate(info.getCertificate());
            client.setClientSigningPrivateKey(info.getPrivateKey());
        }
        if (clientRep.isFrontchannelLogout() == null) {
            newClient.setFrontchannelLogout(true);
        }
        client.setArtifactBindingIdentifierFrom(clientRep.getClientId());
    }
}

