/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.factory;

import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.factory.CacheBaseCounterFactory;
import org.infinispan.counter.impl.factory.WeakCounterFactory;
import org.infinispan.counter.impl.manager.InternalCounterAdmin;
import org.infinispan.counter.impl.weak.WeakCounterImpl;
import org.infinispan.counter.impl.weak.WeakCounterKey;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.concurrent.CompletionStages;

@Scope(value=Scopes.GLOBAL)
public class CacheBasedWeakCounterFactory
extends CacheBaseCounterFactory<WeakCounterKey>
implements WeakCounterFactory {
    @Override
    public CompletionStage<InternalCounterAdmin> createWeakCounter(String name, CounterConfiguration configuration) {
        assert (configuration.type() == CounterType.WEAK);
        return this.cache(configuration).thenCompose(cache -> {
            WeakCounterImpl counter = new WeakCounterImpl(name, (AdvancedCache<WeakCounterKey, CounterValue>)cache, configuration, this.notificationManager);
            return this.registerListeners((Cache<? extends CounterKey, CounterValue>)cache).thenCompose(___ -> counter.init());
        });
    }

    @Override
    public CompletionStage<Void> removeWeakCounter(String name, CounterConfiguration configuration) {
        return this.getCounterCacheAsync().thenCompose(cache -> WeakCounterImpl.removeWeakCounter((Cache<WeakCounterKey, CounterValue>)cache, configuration, name));
    }

    private CompletionStage<Void> registerListeners(Cache<? extends CounterKey, CounterValue> cache) {
        CompletionStage<Void> topologyStage = this.notificationManager.registerTopologyListener(cache);
        CompletionStage<Void> valueStage = this.notificationManager.registerCounterValueListener(cache);
        return CompletionStages.allOf(topologyStage, valueStage);
    }
}

