/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.aesh.cl.activation.CommandActivator;
import org.jboss.aesh.cl.activation.NullCommandActivator;
import org.jboss.aesh.cl.internal.ProcessedCommand;
import org.jboss.aesh.cl.internal.ProcessedOption;
import org.jboss.aesh.cl.parser.CommandLineParserException;
import org.jboss.aesh.cl.populator.CommandPopulator;
import org.jboss.aesh.cl.result.NullResultHandler;
import org.jboss.aesh.cl.result.ResultHandler;
import org.jboss.aesh.cl.validator.CommandValidator;
import org.jboss.aesh.cl.validator.NullCommandValidator;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.util.ReflectionUtil;

public class ProcessedCommandBuilder {
    private String name;
    private String description;
    private CommandValidator<?> validator;
    private ResultHandler resultHandler;
    private ProcessedOption argument;
    private final List<ProcessedOption> options = new ArrayList<ProcessedOption>();
    private CommandPopulator populator;
    private Command command;
    private List<String> aliases;
    private CommandActivator activator;

    public ProcessedCommandBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ProcessedCommandBuilder aliases(List<String> aliases) {
        this.aliases = aliases == null ? Collections.emptyList() : Collections.unmodifiableList(aliases);
        return this;
    }

    public ProcessedCommandBuilder description(String usage) {
        this.description = usage;
        return this;
    }

    public ProcessedCommandBuilder argument(ProcessedOption argument) {
        this.argument = argument;
        return this;
    }

    public ProcessedCommandBuilder validator(CommandValidator<?> validator) {
        this.validator = validator;
        return this;
    }

    public ProcessedCommandBuilder validator(Class<? extends CommandValidator> validator) {
        this.validator = this.initValidator(validator);
        return this;
    }

    private CommandValidator initValidator(Class<? extends CommandValidator> validator) {
        if (validator != null && !validator.equals(NullCommandValidator.class)) {
            return ReflectionUtil.newInstance(validator);
        }
        return new NullCommandValidator();
    }

    public ProcessedCommandBuilder resultHandler(Class<? extends ResultHandler> resultHandler) {
        this.resultHandler = this.initResultHandler(resultHandler);
        return this;
    }

    private ResultHandler initResultHandler(Class<? extends ResultHandler> resultHandler) {
        if (resultHandler != null && !resultHandler.equals(NullResultHandler.class)) {
            return ReflectionUtil.newInstance(resultHandler);
        }
        return new NullResultHandler();
    }

    public ProcessedCommandBuilder resultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
        return this;
    }

    public ProcessedCommandBuilder populator(CommandPopulator populator) {
        this.populator = populator;
        return this;
    }

    public ProcessedCommandBuilder activator(CommandActivator activator) {
        this.activator = activator;
        return this;
    }

    public ProcessedCommandBuilder activator(Class<? extends CommandActivator> activator) {
        this.activator = this.initActivator(activator);
        return this;
    }

    private CommandActivator initActivator(Class<? extends CommandActivator> activator) {
        if (activator != null && activator != NullCommandActivator.class) {
            return ReflectionUtil.newInstance(activator);
        }
        return new NullCommandActivator();
    }

    public ProcessedCommandBuilder command(Command command) {
        this.command = command;
        return this;
    }

    public ProcessedCommandBuilder command(Class<? extends Command> command) {
        this.command = ReflectionUtil.newInstance(command);
        return this;
    }

    public ProcessedCommandBuilder addOption(ProcessedOption option) {
        this.options.add(option);
        return this;
    }

    public ProcessedCommandBuilder addOptions(List<ProcessedOption> options) {
        if (options != null) {
            this.options.addAll(options);
        }
        return this;
    }

    public ProcessedCommand create() throws CommandLineParserException {
        if (this.name == null || this.name.length() < 1) {
            throw new CommandLineParserException("The parameter name must be defined");
        }
        if (this.validator == null) {
            this.validator = new NullCommandValidator();
        }
        if (this.resultHandler == null) {
            this.resultHandler = new NullResultHandler();
        }
        return new ProcessedCommand<Command>(this.name, this.aliases, this.command, this.description, this.validator, this.resultHandler, this.argument, this.options, this.populator, this.activator);
    }
}

