/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.authorization.adapter.MapResourceAdapter;
import org.keycloak.models.map.authorization.entity.MapResourceEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.HasRealmId;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;

public class MapResourceStore
implements ResourceStore {
    private static final Logger LOG = Logger.getLogger(MapResourceStore.class);
    private final AuthorizationProvider authorizationProvider;
    final MapKeycloakTransaction<MapResourceEntity, Resource> tx;
    private final KeycloakSession session;
    private final boolean txHasRealmId;

    public MapResourceStore(KeycloakSession session, MapStorage<MapResourceEntity, Resource> resourceStore, AuthorizationProvider provider) {
        this.tx = resourceStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
        this.authorizationProvider = provider;
        this.session = session;
        this.txHasRealmId = this.tx instanceof HasRealmId;
    }

    private Function<MapResourceEntity, Resource> entityToAdapterFunc(RealmModel realm, ResourceServer resourceServer) {
        return origEntity -> new MapResourceAdapter(realm, resourceServer, (MapResourceEntity)origEntity, this.authorizationProvider.getStoreFactory());
    }

    private MapKeycloakTransaction<MapResourceEntity, Resource> txInRealm(RealmModel realm) {
        if (this.txHasRealmId) {
            ((HasRealmId)((Object)this.tx)).setRealmId(realm == null ? null : realm.getId());
        }
        return this.tx;
    }

    private DefaultModelCriteria<Resource> forRealmAndResourceServer(RealmModel realm, ResourceServer resourceServer) {
        DefaultModelCriteria mcb = (DefaultModelCriteria)DefaultModelCriteria.criteria().compare(Resource.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        return resourceServer == null ? mcb : (DefaultModelCriteria)mcb.compare(Resource.SearchableFields.RESOURCE_SERVER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{resourceServer.getId()});
    }

    public Resource create(ResourceServer resourceServer, String id, String name, String owner) {
        LOG.tracef("create(%s, %s, %s, %s)%s", new Object[]{id, name, resourceServer, owner, StackUtil.getShortStackTrace()});
        RealmModel realm = resourceServer.getRealm();
        DefaultModelCriteria mcb = (DefaultModelCriteria)((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(Resource.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{name})).compare(Resource.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, new Object[]{owner});
        if (this.txInRealm(realm).exists(QueryParameters.withCriteria(mcb))) {
            throw new ModelDuplicateException("Resource with name '" + name + "' for " + resourceServer.getId() + " already exists for request owner " + owner);
        }
        MapResourceEntity entity = DeepCloner.DUMB_CLONER.newInstance(MapResourceEntity.class);
        entity.setId(id);
        entity.setName(name);
        entity.setResourceServerId(resourceServer.getId());
        entity.setOwner(owner);
        entity.setRealmId(realm.getId());
        entity = this.txInRealm(realm).create(entity);
        return entity == null ? null : this.entityToAdapterFunc(realm, resourceServer).apply(entity);
    }

    public void delete(RealmModel realm, String id) {
        LOG.tracef("delete(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        Resource resource = this.findById(realm, null, id);
        if (resource == null) {
            return;
        }
        this.txInRealm(realm).delete(id);
    }

    public Resource findById(RealmModel realm, ResourceServer resourceServer, String id) {
        LOG.tracef("findById(%s, %s)%s", (Object)id, (Object)resourceServer, StackUtil.getShortStackTrace());
        if (id == null) {
            return null;
        }
        return this.txInRealm(realm).read(QueryParameters.withCriteria((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(Resource.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{id}))).findFirst().map(this.entityToAdapterFunc(realm, resourceServer)).orElse(null);
    }

    public void findByOwner(RealmModel realm, ResourceServer resourceServer, String ownerId, Consumer<Resource> consumer) {
        LOG.tracef("findByOwner(%s, %s, %s)%s", new Object[]{realm, resourceServer, resourceServer, ownerId, StackUtil.getShortStackTrace()});
        this.txInRealm(realm).read(QueryParameters.withCriteria((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(Resource.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, new Object[]{ownerId}))).map(this.entityToAdapterFunc(realm, resourceServer)).forEach(consumer);
    }

    public List<Resource> findByResourceServer(ResourceServer resourceServer) {
        LOG.tracef("findByResourceServer(%s)%s", (Object)resourceServer, StackUtil.getShortStackTrace());
        RealmModel realm = resourceServer.getRealm();
        return this.txInRealm(realm).read(QueryParameters.withCriteria(this.forRealmAndResourceServer(realm, resourceServer))).map(this.entityToAdapterFunc(realm, resourceServer)).collect(Collectors.toList());
    }

    public List<Resource> find(RealmModel realm, ResourceServer resourceServer, Map<Resource.FilterOption, String[]> attributes, Integer firstResult, Integer maxResults) {
        LOG.tracef("findByResourceServer(%s, %s, %s, %d, %d)%s", new Object[]{realm, resourceServer, attributes, firstResult, maxResults, StackUtil.getShortStackTrace()});
        DefaultModelCriteria mcb = (DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).and((DefaultModelCriteria[])attributes.entrySet().stream().map(this::filterEntryToDefaultModelCriteria).toArray(DefaultModelCriteria[]::new));
        return this.txInRealm(realm).read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResults, Resource.SearchableFields.NAME)).map(this.entityToAdapterFunc(realm, resourceServer)).collect(Collectors.toList());
    }

    private DefaultModelCriteria<Resource> filterEntryToDefaultModelCriteria(Map.Entry<Resource.FilterOption, String[]> entry) {
        Resource.FilterOption name = entry.getKey();
        String[] value = entry.getValue();
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        switch (name) {
            case ID: 
            case SCOPE_ID: 
            case OWNER: 
            case URI: {
                return (DefaultModelCriteria)mcb.compare(name.getSearchableModelField(), ModelCriteriaBuilder.Operator.IN, new Object[]{Arrays.asList(value)});
            }
            case URI_NOT_NULL: {
                return (DefaultModelCriteria)mcb.compare(Resource.SearchableFields.URI, ModelCriteriaBuilder.Operator.EXISTS, new Object[0]);
            }
            case OWNER_MANAGED_ACCESS: {
                return (DefaultModelCriteria)mcb.compare(Resource.SearchableFields.OWNER_MANAGED_ACCESS, ModelCriteriaBuilder.Operator.EQ, new Object[]{Boolean.valueOf(value[0])});
            }
            case EXACT_NAME: {
                return (DefaultModelCriteria)mcb.compare(Resource.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{value[0]});
            }
            case NAME: {
                return (DefaultModelCriteria)mcb.compare(Resource.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + value[0] + "%"});
            }
            case TYPE: {
                return (DefaultModelCriteria)mcb.compare(Resource.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + value[0] + "%"});
            }
        }
        throw new IllegalArgumentException("Unsupported filter [" + name + "]");
    }

    public void findByScopes(ResourceServer resourceServer, Set<Scope> scopes, Consumer<Resource> consumer) {
        LOG.tracef("findByScope(%s, %s, %s)%s", new Object[]{scopes, resourceServer, consumer, StackUtil.getShortStackTrace()});
        RealmModel realm = resourceServer.getRealm();
        this.txInRealm(realm).read(QueryParameters.withCriteria((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(Resource.SearchableFields.SCOPE_ID, ModelCriteriaBuilder.Operator.IN, new Object[]{scopes.stream().map(Scope::getId)}))).map(this.entityToAdapterFunc(realm, resourceServer)).forEach(consumer);
    }

    public Resource findByName(ResourceServer resourceServer, String name, String ownerId) {
        LOG.tracef("findByName(%s, %s, %s)%s", new Object[]{name, ownerId, resourceServer, StackUtil.getShortStackTrace()});
        RealmModel realm = resourceServer.getRealm();
        return this.txInRealm(realm).read(QueryParameters.withCriteria((DefaultModelCriteria)((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(Resource.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, new Object[]{ownerId})).compare(Resource.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{name}))).findFirst().map(this.entityToAdapterFunc(realm, resourceServer)).orElse(null);
    }

    public void findByType(ResourceServer resourceServer, String type, Consumer<Resource> consumer) {
        LOG.tracef("findByType(%s, %s, %s)%s", new Object[]{type, resourceServer, consumer, StackUtil.getShortStackTrace()});
        RealmModel realm = this.authorizationProvider.getRealm();
        this.txInRealm(realm).read(QueryParameters.withCriteria((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(Resource.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.EQ, new Object[]{type}))).map(this.entityToAdapterFunc(realm, resourceServer)).forEach(consumer);
    }

    public void findByType(ResourceServer resourceServer, String type, String owner, Consumer<Resource> consumer) {
        LOG.tracef("findByType(%s, %s, %s, %s)%s", new Object[]{type, owner, resourceServer, consumer, StackUtil.getShortStackTrace()});
        RealmModel realm = resourceServer.getRealm();
        DefaultModelCriteria mcb = (DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(Resource.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.EQ, new Object[]{type});
        if (owner != null) {
            mcb = (DefaultModelCriteria)mcb.compare(Resource.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, new Object[]{owner});
        }
        this.txInRealm(realm).read(QueryParameters.withCriteria(mcb)).map(this.entityToAdapterFunc(realm, resourceServer)).forEach(consumer);
    }

    public void findByTypeInstance(ResourceServer resourceServer, String type, Consumer<Resource> consumer) {
        LOG.tracef("findByTypeInstance(%s, %s, %s)%s", new Object[]{type, resourceServer, consumer, StackUtil.getShortStackTrace()});
        RealmModel realm = resourceServer.getRealm();
        this.txInRealm(realm).read(QueryParameters.withCriteria((DefaultModelCriteria)((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(Resource.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.NE, new Object[]{resourceServer.getClientId()})).compare(Resource.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.EQ, new Object[]{type}))).map(this.entityToAdapterFunc(realm, resourceServer)).forEach(consumer);
    }

    public void preRemove(RealmModel realm) {
        LOG.tracef("preRemove(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(Resource.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        this.txInRealm(realm).delete(QueryParameters.withCriteria(mcb));
    }

    public void preRemove(RealmModel realm, ResourceServer resourceServer) {
        LOG.tracef("preRemove(%s, %s)%s", (Object)realm, (Object)resourceServer, StackUtil.getShortStackTrace());
        this.txInRealm(realm).delete(QueryParameters.withCriteria(this.forRealmAndResourceServer(resourceServer.getRealm(), resourceServer)));
    }
}

