/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelException;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;

public abstract class AbstractMapProviderFactory<T extends Provider, V extends AbstractEntity, M>
implements AmphibianProviderFactory<T>,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "map";
    public static final String CONFIG_STORAGE = "storage";
    protected final Logger LOG = Logger.getLogger(this.getClass());
    public static final AtomicInteger uniqueCounter = new AtomicInteger();
    private final String uniqueKey = this.getClass().getName() + uniqueCounter.incrementAndGet();
    protected final Class<M> modelType;
    private final Class<T> providerType;
    private Config.Scope storageConfigScope;

    protected AbstractMapProviderFactory(Class<M> modelType, Class<T> providerType) {
        this.modelType = modelType;
        this.providerType = providerType;
    }

    public abstract T createNew(KeycloakSession var1);

    public T create(KeycloakSession session) {
        Object provider = (Provider)session.getAttribute(this.uniqueKey, this.providerType);
        if (provider != null) {
            return (T)provider;
        }
        provider = this.createNew(session);
        session.setAttribute(this.uniqueKey, provider);
        return (T)provider;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public MapStorage<V, M> getStorage(KeycloakSession session) {
        ProviderFactory<MapStorageProvider> storageProviderFactory = AbstractMapProviderFactory.getProviderFactoryOrComponentFactory(session, this.storageConfigScope);
        MapStorageProvider factory = (MapStorageProvider)storageProviderFactory.create(session);
        session.enlistForClose((Provider)factory);
        return factory.getStorage(this.modelType, new MapStorageProviderFactory.Flag[0]);
    }

    public static ProviderFactory<MapStorageProvider> getProviderFactoryOrComponentFactory(KeycloakSession session, Config.Scope storageConfigScope) {
        ProviderFactory storageProviderFactory;
        if (!AbstractMapProviderFactory.hasRealmSpecificStorage(session, storageConfigScope)) {
            String provider = storageConfigScope.get("provider");
            if (provider == null) {
                storageProviderFactory = session.getKeycloakSessionFactory().getProviderFactory(MapStorageProvider.class);
            } else {
                storageProviderFactory = session.getKeycloakSessionFactory().getProviderFactory(MapStorageProvider.class, provider);
                Objects.requireNonNull(storageProviderFactory, "Could not find map storage provider " + provider);
            }
        } else {
            throw new ModelException("not supported yet");
        }
        return storageProviderFactory;
    }

    private static boolean hasRealmSpecificStorage(KeycloakSession session, Config.Scope storageConfigScope) {
        return false;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void init(Config.Scope config) {
        this.storageConfigScope = config.scope(new String[]{CONFIG_STORAGE});
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }

    public static enum MapProviderObjectType implements InvalidationHandler.InvalidableObjectType
    {
        CLIENT_BEFORE_REMOVE,
        CLIENT_AFTER_REMOVE,
        CLIENT_SCOPE_BEFORE_REMOVE,
        CLIENT_SCOPE_AFTER_REMOVE,
        GROUP_BEFORE_REMOVE,
        GROUP_AFTER_REMOVE,
        REALM_BEFORE_REMOVE,
        REALM_AFTER_REMOVE,
        RESOURCE_SERVER_BEFORE_REMOVE,
        RESOURCE_SERVER_AFTER_REMOVE,
        ROLE_BEFORE_REMOVE,
        ROLE_AFTER_REMOVE,
        USER_BEFORE_REMOVE,
        USER_AFTER_REMOVE;

    }
}

