/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.userSession;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.keycloak.common.util.Time;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelIllegalStateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.common.ExpirationUtils;
import org.keycloak.models.map.common.TimeAdapter;
import org.keycloak.models.map.userSession.AbstractUserSessionModel;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionAdapter;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionEntity;
import org.keycloak.models.map.userSession.SessionExpiration;

public class MapUserSessionAdapter
extends AbstractUserSessionModel {
    public MapUserSessionAdapter(KeycloakSession session, RealmModel realm, MapUserSessionEntity entity) {
        super(session, realm, entity);
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public String getBrokerSessionId() {
        return this.entity.getBrokerSessionId();
    }

    public String getBrokerUserId() {
        return this.entity.getBrokerUserId();
    }

    public UserModel getUser() {
        return this.session.users().getUserById(this.getRealm(), this.entity.getUserId());
    }

    public String getLoginUsername() {
        return this.entity.getLoginUsername();
    }

    public String getIpAddress() {
        return this.entity.getIpAddress();
    }

    public String getAuthMethod() {
        return this.entity.getAuthMethod();
    }

    public boolean isRememberMe() {
        Boolean rememberMe = this.entity.isRememberMe();
        return rememberMe != null ? rememberMe : false;
    }

    public int getStarted() {
        Long started = this.entity.getTimestamp();
        return started != null ? TimeAdapter.fromLongWithTimeInSecondsToIntegerWithTimeInSeconds(TimeAdapter.fromMilliSecondsToSeconds(started)) : 0;
    }

    public int getLastSessionRefresh() {
        Long lastSessionRefresh = this.entity.getLastSessionRefresh();
        return lastSessionRefresh != null ? TimeAdapter.fromLongWithTimeInSecondsToIntegerWithTimeInSeconds(TimeAdapter.fromMilliSecondsToSeconds(lastSessionRefresh)) : 0;
    }

    public void setLastSessionRefresh(int seconds) {
        this.entity.setLastSessionRefresh(TimeAdapter.fromSecondsToMilliseconds(seconds));
        SessionExpiration.setUserSessionExpiration(this.entity, this.realm);
    }

    public boolean isOffline() {
        Boolean offline = this.entity.isOffline();
        return offline != null ? offline : false;
    }

    public Map<String, AuthenticatedClientSessionModel> getAuthenticatedClientSessions() {
        Set<MapAuthenticatedClientSessionEntity> authenticatedClientSessions = this.entity.getAuthenticatedClientSessions();
        if (authenticatedClientSessions == null) {
            return Collections.emptyMap();
        }
        return authenticatedClientSessions.stream().filter(this::filterAndRemoveExpiredClientSessions).filter(this::matchingOfflineFlag).filter(this::filterAndRemoveClientSessionWithoutClient).collect(Collectors.toMap(MapAuthenticatedClientSessionEntity::getClientId, this::clientSessionEntityToModel));
    }

    private AuthenticatedClientSessionModel clientSessionEntityToModel(MapAuthenticatedClientSessionEntity clientSessionEntity) {
        return new MapAuthenticatedClientSessionAdapter(this.session, this.realm, this, clientSessionEntity){

            public void detachFromUserSession() {
                MapUserSessionAdapter.this.entity.removeAuthenticatedClientSession(this.entity.getClientId());
                this.userSession = null;
            }
        };
    }

    public boolean filterAndRemoveExpiredClientSessions(MapAuthenticatedClientSessionEntity clientSession) {
        try {
            if (ExpirationUtils.isExpired(clientSession, false)) {
                this.entity.removeAuthenticatedClientSession(clientSession.getClientId());
                return false;
            }
        }
        catch (ModelIllegalStateException ex) {
            this.entity.removeAuthenticatedClientSession(clientSession.getClientId());
            return false;
        }
        return true;
    }

    public boolean filterAndRemoveClientSessionWithoutClient(MapAuthenticatedClientSessionEntity clientSession) {
        ClientModel client = this.realm.getClientById(clientSession.getClientId());
        if (client == null) {
            this.entity.removeAuthenticatedClientSession(clientSession.getId());
            return false;
        }
        return true;
    }

    public boolean matchingOfflineFlag(MapAuthenticatedClientSessionEntity clientSession) {
        Boolean isClientSessionOffline = clientSession.isOffline();
        if (isClientSessionOffline == null) {
            return !this.isOffline();
        }
        return this.isOffline() == isClientSessionOffline.booleanValue();
    }

    public AuthenticatedClientSessionModel getAuthenticatedClientSessionByClient(String clientUUID) {
        return this.entity.getAuthenticatedClientSession(clientUUID).filter(this::filterAndRemoveExpiredClientSessions).filter(this::matchingOfflineFlag).filter(this::filterAndRemoveClientSessionWithoutClient).map(this::clientSessionEntityToModel).orElse(null);
    }

    public void removeAuthenticatedClientSessions(Collection<String> removedClientUKS) {
        removedClientUKS.forEach(this.entity::removeAuthenticatedClientSession);
    }

    public String getNote(String name) {
        return name != null ? this.entity.getNote(name) : null;
    }

    public void setNote(String name, String value) {
        if (name != null) {
            if (value == null) {
                this.entity.removeNote(name);
            } else {
                this.entity.setNote(name, value);
            }
        }
    }

    public void removeNote(String name) {
        if (name != null) {
            this.entity.removeNote(name);
        }
    }

    public Map<String, String> getNotes() {
        Map<String, String> notes = this.entity.getNotes();
        return notes == null ? Collections.emptyMap() : Collections.unmodifiableMap(notes);
    }

    public UserSessionModel.State getState() {
        return this.entity.getState();
    }

    public void setState(UserSessionModel.State state) {
        this.entity.setState(state);
    }

    public void restartSession(RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        this.entity.setRealmId(realm.getId());
        this.entity.setUserId(user.getId());
        this.entity.setLoginUsername(loginUsername);
        this.entity.setIpAddress(ipAddress);
        this.entity.setAuthMethod(authMethod);
        this.entity.setRememberMe(rememberMe);
        this.entity.setBrokerSessionId(brokerSessionId);
        this.entity.setBrokerUserId(brokerUserId);
        long currentTime = Time.currentTimeMillis();
        this.entity.setTimestamp(currentTime);
        this.entity.setLastSessionRefresh(currentTime);
        this.entity.setState(null);
        String correspondingSessionId = this.entity.getNote("correspondingSessionId");
        this.entity.setNotes(new ConcurrentHashMap<String, String>());
        if (correspondingSessionId != null) {
            this.entity.setNote("correspondingSessionId", correspondingSessionId);
        }
        this.entity.clearAuthenticatedClientSessions();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), this.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserSessionModel)) {
            return false;
        }
        UserSessionModel that = (UserSessionModel)o;
        return Objects.equals(that.getId(), this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

