/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.http.Outcome;

public class HttpCommonTags {
    public static final Tag URI_NOT_FOUND = Tag.of((String)"uri", (String)"NOT_FOUND");
    public static final Tag URI_REDIRECTION = Tag.of((String)"uri", (String)"REDIRECTION");
    public static final Tag URI_ROOT = Tag.of((String)"uri", (String)"root");
    static final Tag URI_UNKNOWN = Tag.of((String)"uri", (String)"UNKNOWN");
    static final Tag STATUS_UNKNOWN = Tag.of((String)"status", (String)"UNKNOWN");
    public static final Tag STATUS_RESET = Tag.of((String)"status", (String)"RESET");
    public static final Tag METHOD_UNKNOWN = Tag.of((String)"method", (String)"UNKNOWN");

    public static Tag method(String method) {
        return method == null ? METHOD_UNKNOWN : Tag.of((String)"method", (String)method);
    }

    public static Tag status(int statusCode) {
        return statusCode > 0 ? Tag.of((String)"status", (String)Integer.toString(statusCode)) : STATUS_UNKNOWN;
    }

    public static Tag outcome(int statusCode) {
        return Outcome.forStatus((int)statusCode).asTag();
    }

    public static Tag uri(String pathInfo, int code) {
        if (code > 0) {
            if (code / 100 == 3) {
                return URI_REDIRECTION;
            }
            if (code == 404) {
                return URI_NOT_FOUND;
            }
        }
        if (pathInfo == null) {
            return URI_UNKNOWN;
        }
        if (pathInfo.isEmpty() || "/".equals(pathInfo)) {
            return URI_ROOT;
        }
        return Tag.of((String)"uri", (String)pathInfo);
    }
}

