/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import liquibase.exception.CustomChangeException;
import liquibase.statement.core.InsertStatement;
import liquibase.structure.core.Table;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class JpaUpdate19_0_0_DefaultPostLogoutRedirectUri
extends CustomKeycloakTask {
    private static final String POST_LOGOUT_REDIRECT_URIS = "post.logout.redirect.uris";

    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        String sql = "SELECT DISTINCT CLIENT_ID FROM " + this.getTableName("REDIRECT_URIS");
        try (PreparedStatement statement = this.jdbcConnection.prepareStatement(sql);
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                this.statements.add(new InsertStatement(null, null, this.database.correctObjectName("CLIENT_ATTRIBUTES", Table.class)).addColumnValue("CLIENT_ID", (Object)rs.getString(1)).addColumnValue("NAME", (Object)POST_LOGOUT_REDIRECT_URIS).addColumnValue("VALUE", (Object)"+"));
            }
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when extracting data from previous version", (Throwable)e);
        }
    }

    @Override
    protected String getTaskId() {
        return "Default post_logout_redirect_uris (19.0.0)";
    }
}

