/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert;

import java.util.List;
import org.wildfly.common.Assert;
import org.wildfly.security.asn1.ASN1Encoder;
import org.wildfly.security.x500.GeneralName;
import org.wildfly.security.x500.cert.X509CertificateExtension;

public final class IssuerAlternativeNamesExtension
extends X509CertificateExtension {
    private final List<GeneralName> issuerAlternativeNames;

    public IssuerAlternativeNamesExtension(boolean critical, List<GeneralName> issuerAlternativeNames) {
        super(critical);
        Assert.checkNotNullParam((String)"issuerAlternativeNames", issuerAlternativeNames);
        this.issuerAlternativeNames = issuerAlternativeNames;
    }

    @Override
    public String getId() {
        return "2.5.29.18";
    }

    @Override
    public void encodeTo(ASN1Encoder encoder) {
        encoder.startSequence();
        for (GeneralName name : this.issuerAlternativeNames) {
            name.encodeTo(encoder);
        }
        encoder.endSequence();
    }
}

