/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.ducttape.unreliables;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.rnorth.ducttape.Preconditions;
import org.rnorth.ducttape.RetryCountExceededException;
import org.rnorth.ducttape.TimeoutException;
import org.rnorth.ducttape.timeouts.Timeouts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Unreliables {
    private static final Logger LOGGER = LoggerFactory.getLogger(Unreliables.class);

    public static <T> T retryUntilSuccess(int timeout, @NotNull TimeUnit timeUnit, @NotNull Callable<T> lambda) {
        Preconditions.check("timeout must be greater than zero", timeout > 0);
        int[] attempt = new int[]{0};
        Exception[] lastException = new Exception[]{null};
        AtomicBoolean doContinue = new AtomicBoolean(true);
        try {
            Object object = Timeouts.getWithTimeout(timeout, timeUnit, () -> {
                while (doContinue.get()) {
                    try {
                        return lambda.call();
                    }
                    catch (Exception e) {
                        int n = attempt[0];
                        attempt[0] = n + 1;
                        LOGGER.trace("Retrying lambda call on attempt {}", (Object)n);
                        lastException[0] = e;
                    }
                }
                return null;
            });
            return (T)object;
        }
        catch (TimeoutException e) {
            if (lastException[0] != null) {
                throw new TimeoutException("Timeout waiting for result with exception", lastException[0]);
            }
            throw new TimeoutException(e);
        }
        finally {
            doContinue.set(false);
        }
    }

    public static <T> T retryUntilSuccess(int tryLimit, @NotNull Callable<T> lambda) {
        Preconditions.check("tryLimit must be greater than zero", tryLimit > 0);
        Exception lastException = null;
        for (int attempt = 0; attempt < tryLimit; ++attempt) {
            try {
                return lambda.call();
            }
            catch (Exception e) {
                lastException = e;
                continue;
            }
        }
        throw new RetryCountExceededException("Retry limit hit with exception", lastException);
    }

    public static void retryUntilTrue(int timeout, @NotNull TimeUnit timeUnit, @NotNull Callable<Boolean> lambda) {
        Unreliables.retryUntilSuccess(timeout, timeUnit, () -> {
            if (!((Boolean)lambda.call()).booleanValue()) {
                throw new RuntimeException("Not ready yet");
            }
            return null;
        });
    }

    public static void retryUntilTrue(int tryLimit, @NotNull Callable<Boolean> lambda) {
        Unreliables.retryUntilSuccess(tryLimit, () -> {
            if (!((Boolean)lambda.call()).booleanValue()) {
                throw new RuntimeException("Not ready yet");
            }
            return null;
        });
    }
}

