/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.okhttp;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.ExporterBuilderUtil;
import io.opentelemetry.exporter.internal.TlsUtil;
import io.opentelemetry.exporter.internal.auth.Authenticator;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.okhttp.OkHttpExporter;
import io.opentelemetry.exporter.internal.okhttp.OkHttpUtil;
import io.opentelemetry.exporter.internal.retry.RetryInterceptor;
import io.opentelemetry.exporter.internal.retry.RetryPolicy;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public final class OkHttpExporterBuilder<T extends Marshaler> {
    public static final long DEFAULT_TIMEOUT_SECS = 10L;
    private final String exporterName;
    private final String type;
    private String endpoint;
    private long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);
    private boolean compressionEnabled = false;
    private boolean exportAsJson = false;
    @Nullable
    private Headers.Builder headersBuilder;
    @Nullable
    private byte[] trustedCertificatesPem;
    @Nullable
    private byte[] privateKeyPem;
    @Nullable
    private byte[] certificatePem;
    @Nullable
    private RetryPolicy retryPolicy;
    private MeterProvider meterProvider = MeterProvider.noop();
    @Nullable
    private Authenticator authenticator;

    public OkHttpExporterBuilder(String exporterName, String type, String defaultEndpoint) {
        this.exporterName = exporterName;
        this.type = type;
        this.endpoint = defaultEndpoint;
    }

    public OkHttpExporterBuilder<T> setTimeout(long timeout, TimeUnit unit) {
        this.timeoutNanos = unit.toNanos(timeout);
        return this;
    }

    public OkHttpExporterBuilder<T> setTimeout(Duration timeout) {
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OkHttpExporterBuilder<T> setEndpoint(String endpoint) {
        URI uri = ExporterBuilderUtil.validateEndpoint(endpoint);
        this.endpoint = uri.toString();
        return this;
    }

    public OkHttpExporterBuilder<T> setCompression(String compressionMethod) {
        if (compressionMethod.equals("gzip")) {
            this.compressionEnabled = true;
        }
        return this;
    }

    public OkHttpExporterBuilder<T> addHeader(String key, String value) {
        if (this.headersBuilder == null) {
            this.headersBuilder = new Headers.Builder();
        }
        this.headersBuilder.add(key, value);
        return this;
    }

    public OkHttpExporterBuilder<T> setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public OkHttpExporterBuilder<T> setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.trustedCertificatesPem = trustedCertificatesPem;
        return this;
    }

    public OkHttpExporterBuilder<T> setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.privateKeyPem = privateKeyPem;
        this.certificatePem = certificatePem;
        return this;
    }

    public OkHttpExporterBuilder<T> setMeterProvider(MeterProvider meterProvider) {
        this.meterProvider = meterProvider;
        return this;
    }

    public OkHttpExporterBuilder<T> setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public OkHttpExporterBuilder<T> exportAsJson() {
        this.exportAsJson = true;
        return this;
    }

    public OkHttpExporter<T> build() {
        Headers headers;
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().dispatcher(OkHttpUtil.newDispatcher()).callTimeout(Duration.ofNanos(this.timeoutNanos));
        if (this.trustedCertificatesPem != null) {
            try {
                X509TrustManager trustManager = TlsUtil.trustManager(this.trustedCertificatesPem);
                X509KeyManager keyManager = null;
                if (this.privateKeyPem != null && this.certificatePem != null) {
                    keyManager = TlsUtil.keyManager(this.privateKeyPem, this.certificatePem);
                }
                clientBuilder.sslSocketFactory(TlsUtil.sslSocketFactory(keyManager, trustManager), trustManager);
            }
            catch (SSLException e) {
                throw new IllegalStateException("Could not set trusted certificate for OTLP HTTP connection, are they valid X.509 in PEM format?", e);
            }
        }
        Headers headers2 = headers = this.headersBuilder == null ? null : this.headersBuilder.build();
        if (this.retryPolicy != null) {
            clientBuilder.addInterceptor((Interceptor)new RetryInterceptor(this.retryPolicy, OkHttpExporter::isRetryable));
        }
        if (this.authenticator != null) {
            Authenticator finalAuthenticator = this.authenticator;
            clientBuilder.authenticator((route, response) -> {
                Request.Builder requestBuilder = response.request().newBuilder();
                finalAuthenticator.getHeaders().forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).header(arg_0, arg_1));
                return requestBuilder.build();
            });
        }
        return new OkHttpExporter(this.exporterName, this.type, clientBuilder.build(), this.meterProvider, this.endpoint, headers, this.compressionEnabled, this.exportAsJson);
    }
}

