/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.undertow.UndertowLogger;
import io.undertow.httpcore.UndertowOptions;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class SavedRequest
implements Serializable {
    private static final String SESSION_KEY = SavedRequest.class.getName();
    private final byte[] data;
    private final int dataLength;
    private final String method;
    private final String requestPath;
    private final HttpHeaders headerMap;

    public SavedRequest(byte[] data, int dataLength, String method, String requestPath, HttpHeaders headerMap) {
        this.data = data;
        this.dataLength = dataLength;
        this.method = method;
        this.requestPath = requestPath;
        this.headerMap = headerMap;
    }

    public static int getMaxBufferSizeToSave(HttpServerExchange exchange) {
        int maxSize = (Integer)exchange.getUndertowOptions().get(UndertowOptions.MAX_BUFFERED_REQUEST_SIZE, (Object)16384);
        return maxSize;
    }

    public static void trySaveRequest(HttpServerExchange exchange) {
        int maxSize = SavedRequest.getMaxBufferSizeToSave(exchange);
        if (maxSize > 0 && !exchange.isRequestComplete()) {
            long requestContentLength = exchange.getRequestContentLength();
            if (requestContentLength > (long)maxSize) {
                UndertowLogger.REQUEST_LOGGER.debugf("Request to %s was to large to save", (Object)exchange.getRequestURI());
                return;
            }
            byte[] buffer = new byte[maxSize];
            int read = 0;
            int res = 0;
            InputStream in = exchange.getInputStream();
            try {
                while ((res = in.read(buffer, read, buffer.length - read)) > 0) {
                    if ((read += res) != maxSize) continue;
                    UndertowLogger.REQUEST_LOGGER.debugf("Request to %s was to large to save", (Object)exchange.getRequestURI());
                    return;
                }
                SavedRequest.trySaveRequest(exchange, buffer, read);
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException((Throwable)e);
            }
        }
    }

    public static void trySaveRequest(HttpServerExchange exchange, byte[] buffer, int length) {
        int maxSize = (Integer)exchange.getUndertowOptions().get(UndertowOptions.MAX_BUFFERED_REQUEST_SIZE, (Object)16384);
        if (maxSize > 0) {
            if (length > maxSize) {
                UndertowLogger.REQUEST_LOGGER.debugf("Request to %s was to large to save", (Object)exchange.getRequestURI());
                return;
            }
            DefaultHttpHeaders headers = new DefaultHttpHeaders();
            for (String entry : exchange.getRequestHeaderNames()) {
                if (entry.equals("Content-Length") || entry.equals("Transfer-Encoding") || entry.equals("Connection")) continue;
                headers.set(entry, (Iterable)exchange.getRequestHeaders(entry));
            }
            SavedRequest request = new SavedRequest(buffer, length, exchange.getRequestMethod(), exchange.getRelativePath(), (HttpHeaders)headers);
            ServletRequestContext sc = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            HttpSessionImpl session = sc.getCurrentServletContext().getSession(exchange, true);
            Session underlyingSession = System.getSecurityManager() == null ? session.getSession() : AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction(session));
            underlyingSession.setAttribute(SESSION_KEY, (Object)request);
        }
    }

    public static void tryRestoreRequest(HttpServerExchange exchange, HttpSession session) {
        Session underlyingSession;
        SavedRequest request;
        if (session instanceof HttpSessionImpl && (request = (SavedRequest)(underlyingSession = System.getSecurityManager() == null ? ((HttpSessionImpl)session).getSession() : AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction(session))).getAttribute(SESSION_KEY)) != null && request.requestPath.equals(exchange.getRelativePath()) && exchange.isRequestComplete()) {
            UndertowLogger.REQUEST_LOGGER.debugf("restoring request body for request to %s", (Object)request.requestPath);
            exchange.requestMethod(request.method);
            Connectors.ungetRequestBytes((HttpServerExchange)exchange, (ByteBuf)Unpooled.wrappedBuffer((byte[])request.data, (int)0, (int)request.dataLength));
            underlyingSession.removeAttribute(SESSION_KEY);
            Iterator headerIterator = exchange.getRequestHeaderNames().iterator();
            while (headerIterator.hasNext()) {
                String header = (String)headerIterator.next();
                if (header.equals("Connection")) continue;
                headerIterator.remove();
            }
            for (Map.Entry header : request.headerMap) {
                exchange.addRequestHeader((String)header.getKey(), request.headerMap.get((String)header.getKey()));
            }
        }
    }
}

