/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.internal.restclient.model.ModelNodeBuilder;
import com.openshift.internal.restclient.model.image.ImageStreamImport;
import com.openshift.internal.restclient.model.properties.ResourcePropertyKeys;
import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.IClient;
import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.capability.resources.IImageStreamImportCapability;
import com.openshift.restclient.http.IHttpConstants;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.image.IImageStreamImport;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerRegistryImageStreamImportCapability
implements IImageStreamImportCapability,
IHttpConstants,
ResourcePropertyKeys {
    private static final String TOKEN = "token";
    private static final String STATUS_STATUS = "status.status";
    private static final String ID = "id";
    private static final String PARENT = "parent";
    private static final String REALM = "realm";
    private static final Logger LOG = LoggerFactory.getLogger(IImageStreamImportCapability.class);
    private static final String DEFAULT_DOCKER_REGISTRY = "https://registry-1.docker.io/v2";
    private IResourceFactory factory;
    private IProject project;
    private OkHttpClient okClient;

    public DockerRegistryImageStreamImportCapability(IProject project, IResourceFactory factory, IClient client) {
        this.factory = factory;
        this.project = project;
        this.okClient = client.adapt(OkHttpClient.class);
        if (this.okClient != null) {
            this.okClient = this.okClient.newBuilder().followRedirects(true).build();
        }
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return DockerRegistryImageStreamImportCapability.class.getSimpleName();
    }

    private boolean registryExists(OkHttpClient client) throws Exception {
        Request req = new Request.Builder().url(DEFAULT_DOCKER_REGISTRY).header("X-OPENSHIFT-IGNORE-RCI", "true").build();
        try (Response response = client.newCall(req).execute();){
            if (response == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = response.code() == 401 || response.code() == 200;
            return bl;
        }
    }

    private String retrieveAuthToken(OkHttpClient client, String details) throws Exception {
        if (StringUtils.isNotBlank((String)details)) {
            Map<String, String> auth = this.parseAuthDetails(details);
            if (auth.containsKey(REALM)) {
                Request request = this.createAuthRequest(auth);
                return this.retrieveAuthToken(client, request);
            }
            LOG.info("Unable to retrieve authentication token - 'realm' was not found in the authenticate header: {}", (Object)auth.toString());
        }
        return null;
    }

    private String retrieveAuthToken(OkHttpClient client, Request request) throws IOException {
        String token = null;
        try (Response response = client.newCall(request).execute();
             ResponseBody responseBody = response.body();){
            LOG.debug("Auth response: {}", (Object)responseBody.string());
            if (response.code() == 200 && "application/json;charset=utf-8".equals(response.headers().get("Content-Type"))) {
                ModelNode tokenNode = ModelNode.fromJSONString((String)responseBody.string());
                if (tokenNode.hasDefined(TOKEN)) {
                    token = tokenNode.get(TOKEN).asString();
                } else {
                    LOG.debug("No auth token was found on auth response: {}", (Object)tokenNode.toJSONString(false));
                }
            } else {
                LOG.info("Unable to retrieve authentication token as response was not OK and/or unexpected content type");
            }
        }
        return token;
    }

    private Request createAuthRequest(Map<String, String> authParams) {
        HttpUrl.Builder builder = HttpUrl.parse((String)StringUtils.strip((String)authParams.get(REALM), (String)"\"")).newBuilder();
        for (Map.Entry<String, String> e : authParams.entrySet()) {
            if (REALM.equals(e.getKey())) continue;
            builder.addQueryParameter(StringUtils.strip((String)e.getKey(), (String)"\""), StringUtils.strip((String)e.getValue(), (String)"\""));
        }
        Request request = new Request.Builder().url(builder.build()).header("X-OPENSHIFT-IGNORE-RCI", "true").build();
        LOG.debug("Auth request uri: {}", (Object)request.url());
        return request;
    }

    private Map<String, String> parseAuthDetails(String auth) {
        LOG.debug("Auth details header: {}", (Object)auth);
        HashMap<String, String> map = new HashMap<String, String>();
        String[] authAndValues = auth.split(" ");
        if (authAndValues.length == 2 && "Bearer".equals(authAndValues[0])) {
            String[] params;
            for (String p : params = authAndValues[1].split(",")) {
                String[] knv = p.split("=");
                if (knv.length < 2) continue;
                map.put(knv[0], knv[1]);
            }
        }
        return map;
    }

    /*
     * Exception decompiling
     */
    private DockerResponse retrieveMetaData(OkHttpClient client, String token, DockerImageURI uri) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public IImageStreamImport importImageMetadata(DockerImageURI uri) {
        if (this.okClient != null) {
            try {
                if (this.registryExists(this.okClient)) {
                    String token = null;
                    DockerResponse response = this.retrieveMetaData(this.okClient, token, uri);
                    if ("auth".equals(response.getResponseType())) {
                        LOG.debug("Unauthorized.  Trying to retrieve token...");
                        token = this.retrieveAuthToken(this.okClient, response.getData());
                        response = this.retrieveMetaData(this.okClient, token, uri);
                    }
                    if ("data".equals(response.getResponseType())) {
                        String meta = response.getData();
                        LOG.debug("Raw Docker image metadata: " + meta);
                        return this.buildResponse(meta, uri);
                    }
                    LOG.info("Unable to retrieve image metadata from docker registry");
                    return this.buildErrorResponse(uri);
                }
            }
            catch (Exception e) {
                LOG.error("Exception while trying to retrieve image metadata from docker", (Throwable)e);
            }
        }
        return this.buildErrorResponse(uri);
    }

    private IImageStreamImport buildErrorResponse(DockerImageURI uri) {
        ModelNodeBuilder builder = new ModelNodeBuilder().set(STATUS_STATUS, "Failure").set("status.message", String.format("you may not have access to the Docker image \"%s\"", uri.getUriWithoutHost())).set("status.reason", "Unauthorized").set("status.code", 401);
        return this.buildImageStreamImport(uri, builder.build());
    }

    private IImageStreamImport buildResponse(String meta, DockerImageURI uri) {
        ModelNode raw = ModelNode.fromJSONString((String)meta);
        ModelNode last = this.findNewestHistoryEntry(raw);
        ModelNode containerConfig = last.remove("container_config");
        last.get("ContainerConfig").set(containerConfig);
        ModelNodeBuilder builder = new ModelNodeBuilder().set(STATUS_STATUS, "Success").set("tag", uri.getTag()).set("image.metadata.name", uri.getName()).set("image.dockerImageReference", uri.getUriUserNameAndName()).set("image.dockerImageMetadata", last).set("status.code", 200);
        return this.buildImageStreamImport(uri, builder.build());
    }

    private ImageStreamImport buildImageStreamImport(DockerImageURI uri, ModelNode node) {
        ImageStreamImport isImport = (ImageStreamImport)this.factory.stub("ImageStreamImport", uri.getName(), this.project.getName());
        ModelNode root = isImport.getNode();
        ModelNode images = JBossDmrExtentions.get(root, null, "status.images");
        images.add(node);
        return isImport;
    }

    private ModelNode findNewestHistoryEntry(ModelNode root) {
        ModelNode history = root.get("history");
        List entries = history.asList().stream().map(n -> ModelNode.fromJSONString((String)n.get("v1Compatibility").asString())).collect(Collectors.toList());
        entries.sort(new ManifestComparator());
        ModelNode last = (ModelNode)entries.get(entries.size() - 1);
        LOG.debug("newest history: " + last.toJSONString(false));
        return last;
    }

    static class ManifestComparator
    implements Comparator<ModelNode> {
        ManifestComparator() {
        }

        @Override
        public int compare(ModelNode one, ModelNode two) {
            String parent2;
            String parent1 = one.has(DockerRegistryImageStreamImportCapability.PARENT) ? one.get(DockerRegistryImageStreamImportCapability.PARENT).asString() : null;
            String string = parent2 = two.has(DockerRegistryImageStreamImportCapability.PARENT) ? one.get(DockerRegistryImageStreamImportCapability.PARENT).asString() : null;
            if (parent1 == null && parent2 != null) {
                return -1;
            }
            if (parent1 != null && parent2 == null) {
                return 1;
            }
            if (parent1 == null && parent2 == null) {
                return 0;
            }
            String id1 = one.get(DockerRegistryImageStreamImportCapability.ID).asString();
            String id2 = two.get(DockerRegistryImageStreamImportCapability.ID).asString();
            if (parent2.equals(id1)) {
                return -1;
            }
            if (parent1.equals(id2)) {
                return 1;
            }
            return 0;
        }
    }

    private static class DockerResponse {
        public static final String DATA = "data";
        public static final String AUTH = "auth";
        String responseType;
        String data;

        DockerResponse(String responseType, String data) {
            this.responseType = responseType;
            this.data = data;
        }

        public Object getResponseType() {
            return this.responseType;
        }

        public String getData() {
            return this.data;
        }
    }
}

