/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.traces;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.otlp.InstrumentationScopeMarshaller;
import io.opentelemetry.exporter.internal.otlp.traces.SpanMarshaler;
import io.opentelemetry.proto.trace.v1.internal.ScopeSpans;
import java.io.IOException;
import java.util.List;

final class InstrumentationScopeSpansMarshaler
extends MarshalerWithSize {
    private final InstrumentationScopeMarshaller instrumentationScope;
    private final List<SpanMarshaler> spanMarshalers;
    private final byte[] schemaUrlUtf8;

    InstrumentationScopeSpansMarshaler(InstrumentationScopeMarshaller instrumentationScope, byte[] schemaUrlUtf8, List<SpanMarshaler> spanMarshalers) {
        super(InstrumentationScopeSpansMarshaler.calculateSize(instrumentationScope, schemaUrlUtf8, spanMarshalers));
        this.instrumentationScope = instrumentationScope;
        this.schemaUrlUtf8 = schemaUrlUtf8;
        this.spanMarshalers = spanMarshalers;
    }

    public void writeTo(Serializer output) throws IOException {
        output.serializeMessage(ScopeSpans.SCOPE, (Marshaler)this.instrumentationScope);
        output.serializeRepeatedMessage(ScopeSpans.SPANS, this.spanMarshalers);
        output.serializeString(ScopeSpans.SCHEMA_URL, this.schemaUrlUtf8);
    }

    private static int calculateSize(InstrumentationScopeMarshaller instrumentationScope, byte[] schemaUrlUtf8, List<SpanMarshaler> spanMarshalers) {
        int size = 0;
        size += MarshalerUtil.sizeMessage((ProtoFieldInfo)ScopeSpans.SCOPE, (Marshaler)instrumentationScope);
        size += MarshalerUtil.sizeBytes((ProtoFieldInfo)ScopeSpans.SCHEMA_URL, (byte[])schemaUrlUtf8);
        return size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ScopeSpans.SPANS, spanMarshalers);
    }
}

