/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.shaderc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct shaderc_spvc_resource_location_info")
public class ShadercSPVCResourceLocationInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ID;
    public static final int HAS_LOCATION;
    public static final int LOCATION;

    public ShadercSPVCResourceLocationInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ShadercSPVCResourceLocationInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int id() {
        return ShadercSPVCResourceLocationInfo.nid(this.address());
    }

    @NativeType(value="bool")
    public boolean has_location() {
        return ShadercSPVCResourceLocationInfo.nhas_location(this.address());
    }

    @NativeType(value="uint32_t")
    public int location() {
        return ShadercSPVCResourceLocationInfo.nlocation(this.address());
    }

    public static ShadercSPVCResourceLocationInfo malloc() {
        return (ShadercSPVCResourceLocationInfo)ShadercSPVCResourceLocationInfo.wrap(ShadercSPVCResourceLocationInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static ShadercSPVCResourceLocationInfo calloc() {
        return (ShadercSPVCResourceLocationInfo)ShadercSPVCResourceLocationInfo.wrap(ShadercSPVCResourceLocationInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static ShadercSPVCResourceLocationInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (ShadercSPVCResourceLocationInfo)ShadercSPVCResourceLocationInfo.wrap(ShadercSPVCResourceLocationInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static ShadercSPVCResourceLocationInfo create(long address) {
        return (ShadercSPVCResourceLocationInfo)ShadercSPVCResourceLocationInfo.wrap(ShadercSPVCResourceLocationInfo.class, (long)address);
    }

    @Nullable
    public static ShadercSPVCResourceLocationInfo createSafe(long address) {
        return address == 0L ? null : (ShadercSPVCResourceLocationInfo)ShadercSPVCResourceLocationInfo.wrap(ShadercSPVCResourceLocationInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)ShadercSPVCResourceLocationInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)ShadercSPVCResourceLocationInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)ShadercSPVCResourceLocationInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ShadercSPVCResourceLocationInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)ShadercSPVCResourceLocationInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)ShadercSPVCResourceLocationInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)ShadercSPVCResourceLocationInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static ShadercSPVCResourceLocationInfo mallocStack() {
        return ShadercSPVCResourceLocationInfo.mallocStack(MemoryStack.stackGet());
    }

    public static ShadercSPVCResourceLocationInfo callocStack() {
        return ShadercSPVCResourceLocationInfo.callocStack(MemoryStack.stackGet());
    }

    public static ShadercSPVCResourceLocationInfo mallocStack(MemoryStack stack) {
        return (ShadercSPVCResourceLocationInfo)ShadercSPVCResourceLocationInfo.wrap(ShadercSPVCResourceLocationInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ShadercSPVCResourceLocationInfo callocStack(MemoryStack stack) {
        return (ShadercSPVCResourceLocationInfo)ShadercSPVCResourceLocationInfo.wrap(ShadercSPVCResourceLocationInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return ShadercSPVCResourceLocationInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return ShadercSPVCResourceLocationInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)ShadercSPVCResourceLocationInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)ShadercSPVCResourceLocationInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nid(long struct) {
        return UNSAFE.getInt(null, struct + (long)ID);
    }

    public static boolean nhas_location(long struct) {
        return UNSAFE.getByte(null, struct + (long)HAS_LOCATION) != 0;
    }

    public static int nlocation(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOCATION);
    }

    static {
        Struct.Layout layout = ShadercSPVCResourceLocationInfo.__struct((Struct.Member[])new Struct.Member[]{ShadercSPVCResourceLocationInfo.__member((int)4), ShadercSPVCResourceLocationInfo.__member((int)1), ShadercSPVCResourceLocationInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ID = layout.offsetof(0);
        HAS_LOCATION = layout.offsetof(1);
        LOCATION = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ShadercSPVCResourceLocationInfo, Buffer>
    implements NativeResource {
        private static final ShadercSPVCResourceLocationInfo ELEMENT_FACTORY = ShadercSPVCResourceLocationInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ShadercSPVCResourceLocationInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int id() {
            return ShadercSPVCResourceLocationInfo.nid(this.address());
        }

        @NativeType(value="bool")
        public boolean has_location() {
            return ShadercSPVCResourceLocationInfo.nhas_location(this.address());
        }

        @NativeType(value="uint32_t")
        public int location() {
            return ShadercSPVCResourceLocationInfo.nlocation(this.address());
        }
    }
}

