/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.CXCursor;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXIdxEntityInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KIND;
    public static final int TEMPLATEKIND;
    public static final int LANG;
    public static final int NAME;
    public static final int USR;
    public static final int CURSOR;
    public static final int ATTRIBUTES;
    public static final int NUMATTRIBUTES;

    public CXIdxEntityInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXIdxEntityInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CXIdxEntityKind")
    public int kind() {
        return CXIdxEntityInfo.nkind(this.address());
    }

    @NativeType(value="CXIdxEntityCXXTemplateKind")
    public int templateKind() {
        return CXIdxEntityInfo.ntemplateKind(this.address());
    }

    @NativeType(value="CXIdxEntityLanguage")
    public int lang() {
        return CXIdxEntityInfo.nlang(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer name() {
        return CXIdxEntityInfo.nname(this.address());
    }

    @NativeType(value="char const *")
    public String nameString() {
        return CXIdxEntityInfo.nnameString(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer USR() {
        return CXIdxEntityInfo.nUSR(this.address());
    }

    @NativeType(value="char const *")
    public String USRString() {
        return CXIdxEntityInfo.nUSRString(this.address());
    }

    public CXCursor cursor() {
        return CXIdxEntityInfo.ncursor(this.address());
    }

    @NativeType(value="CXIdxAttrInfo const * const *")
    public PointerBuffer attributes() {
        return CXIdxEntityInfo.nattributes(this.address());
    }

    @NativeType(value="unsigned")
    public int numAttributes() {
        return CXIdxEntityInfo.nnumAttributes(this.address());
    }

    public static CXIdxEntityInfo malloc() {
        return (CXIdxEntityInfo)CXIdxEntityInfo.wrap(CXIdxEntityInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CXIdxEntityInfo calloc() {
        return (CXIdxEntityInfo)CXIdxEntityInfo.wrap(CXIdxEntityInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CXIdxEntityInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CXIdxEntityInfo)CXIdxEntityInfo.wrap(CXIdxEntityInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CXIdxEntityInfo create(long address) {
        return (CXIdxEntityInfo)CXIdxEntityInfo.wrap(CXIdxEntityInfo.class, (long)address);
    }

    @Nullable
    public static CXIdxEntityInfo createSafe(long address) {
        return address == 0L ? null : (CXIdxEntityInfo)CXIdxEntityInfo.wrap(CXIdxEntityInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CXIdxEntityInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CXIdxEntityInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CXIdxEntityInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXIdxEntityInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CXIdxEntityInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CXIdxEntityInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CXIdxEntityInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CXIdxEntityInfo mallocStack() {
        return CXIdxEntityInfo.mallocStack(MemoryStack.stackGet());
    }

    public static CXIdxEntityInfo callocStack() {
        return CXIdxEntityInfo.callocStack(MemoryStack.stackGet());
    }

    public static CXIdxEntityInfo mallocStack(MemoryStack stack) {
        return (CXIdxEntityInfo)CXIdxEntityInfo.wrap(CXIdxEntityInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXIdxEntityInfo callocStack(MemoryStack stack) {
        return (CXIdxEntityInfo)CXIdxEntityInfo.wrap(CXIdxEntityInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CXIdxEntityInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CXIdxEntityInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXIdxEntityInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXIdxEntityInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nkind(long struct) {
        return UNSAFE.getInt(null, struct + (long)KIND);
    }

    public static int ntemplateKind(long struct) {
        return UNSAFE.getInt(null, struct + (long)TEMPLATEKIND);
    }

    public static int nlang(long struct) {
        return UNSAFE.getInt(null, struct + (long)LANG);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    public static ByteBuffer nUSR(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)USR)));
    }

    public static String nUSRString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)USR)));
    }

    public static CXCursor ncursor(long struct) {
        return CXCursor.create(struct + (long)CURSOR);
    }

    public static PointerBuffer nattributes(long struct) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)ATTRIBUTES)), (int)CXIdxEntityInfo.nnumAttributes(struct));
    }

    public static int nnumAttributes(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMATTRIBUTES);
    }

    static {
        Struct.Layout layout = CXIdxEntityInfo.__struct((Struct.Member[])new Struct.Member[]{CXIdxEntityInfo.__member((int)4), CXIdxEntityInfo.__member((int)4), CXIdxEntityInfo.__member((int)4), CXIdxEntityInfo.__member((int)POINTER_SIZE), CXIdxEntityInfo.__member((int)POINTER_SIZE), CXIdxEntityInfo.__member((int)CXCursor.SIZEOF, (int)CXCursor.ALIGNOF), CXIdxEntityInfo.__member((int)POINTER_SIZE), CXIdxEntityInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KIND = layout.offsetof(0);
        TEMPLATEKIND = layout.offsetof(1);
        LANG = layout.offsetof(2);
        NAME = layout.offsetof(3);
        USR = layout.offsetof(4);
        CURSOR = layout.offsetof(5);
        ATTRIBUTES = layout.offsetof(6);
        NUMATTRIBUTES = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<CXIdxEntityInfo, Buffer>
    implements NativeResource {
        private static final CXIdxEntityInfo ELEMENT_FACTORY = CXIdxEntityInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXIdxEntityInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CXIdxEntityKind")
        public int kind() {
            return CXIdxEntityInfo.nkind(this.address());
        }

        @NativeType(value="CXIdxEntityCXXTemplateKind")
        public int templateKind() {
            return CXIdxEntityInfo.ntemplateKind(this.address());
        }

        @NativeType(value="CXIdxEntityLanguage")
        public int lang() {
            return CXIdxEntityInfo.nlang(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer name() {
            return CXIdxEntityInfo.nname(this.address());
        }

        @NativeType(value="char const *")
        public String nameString() {
            return CXIdxEntityInfo.nnameString(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer USR() {
            return CXIdxEntityInfo.nUSR(this.address());
        }

        @NativeType(value="char const *")
        public String USRString() {
            return CXIdxEntityInfo.nUSRString(this.address());
        }

        public CXCursor cursor() {
            return CXIdxEntityInfo.ncursor(this.address());
        }

        @NativeType(value="CXIdxAttrInfo const * const *")
        public PointerBuffer attributes() {
            return CXIdxEntityInfo.nattributes(this.address());
        }

        @NativeType(value="unsigned")
        public int numAttributes() {
            return CXIdxEntityInfo.nnumAttributes(this.address());
        }
    }
}

