<?php

/**
 * ⚠️ Editing not allowed except for 'en' language.
 *
 * @see https://github.com/monicahq/monica/blob/main/docs/contribute/translate.md for translations.
 */

return [
    'sidebar_settings' => 'Ρυθμίσεις λογαριασμού',
    'sidebar_personalization' => 'Εξατομίκευση',
    'sidebar_settings_storage' => 'Αποθηκευτικός χώρος',
    'sidebar_settings_export' => 'Εξαγωγή δεδομένων',
    'sidebar_settings_users' => 'Χρήστες',
    'sidebar_settings_subscriptions' => 'Συνδρομή',
    'sidebar_settings_import' => 'Εισαγωγή δεδομένων',
    'sidebar_settings_tags' => 'Διαχείριση ετικετών',
    'sidebar_settings_api' => 'API',
    'sidebar_settings_dav' => 'Πόροι DAV',
    'sidebar_settings_security' => 'Ασφάλεια',
    'sidebar_settings_auditlogs' => 'Αρχείο ελέγχου',

    'title_general' => 'Γενικές πληροφορίες',
    'title_i18n' => 'Ρυθμίσεις περιοχής',
    'title_layout' => 'Διάταξη',

    'me_title' => 'Εγώ ως επαφή',
    'me_help' => 'Αυτή είναι η επαφή που <em>σας</em> εκπροσωπεί στην Monica',
    'me_select' => 'Επιλέξτε μια επαφή',
    'me_no_contact' => 'Δεν έχουν επιλεγεί επαφές.',
    'me_select_click' => 'Κάντε κλικ εδώ για να επιλέξετε μια επαφή.',
    'me_remove_contact' => 'Αφαίρεση σύνδεσης',
    'me_choose' => 'Επιλέξτε εσάς',
    'me_choose_placeholder' => 'Επιλέξτε εσάς',

    'export_title' => 'Εξαγωγή των δεδομένων λογαριασμού σας',
    'export_be_patient' => 'Click the button to start the export. It might take several minutes to process the export – please be patient and do not spam the button.',
    'export_title_sql' => 'Export to SQL',
    'export_sql_explanation' => 'Exporting your data in SQL format allows you to take your data and import it to your own Monica instance. This is only valuable if you do have your own server.',
    'export_sql_cta' => 'Export to SQL',
    'export_sql_link_instructions' => 'Note: <a href=":url">read the instructions</a> to learn more about importing this file to your instance.',
    'export_title_json' => 'Export to Json',
    'export_submitted' => 'Your export has been submitted, it will be available in a few moment…',
    'export_json_explanation' => 'Exporting your data in Json format for backup.',
    'export_json_beta' => 'Json export is in preview mode. Tell us what you think about it:',
    'export_json_cta' => 'Export to Json',
    'export_header_type' => 'Type',
    'export_header_timestamp' => 'Creation date',
    'export_header_status' => 'Status',
    'export_header_actions' => 'Actions',
    'export_last_title' => 'Last exports',
    'export_empty_title' => 'No exports yet',
    'export_type_json' => 'Json export',
    'export_type_sql' => 'SQL export',
    'export_status_todo' => 'Submitted',
    'export_status_doing' => 'Doing',
    'export_status_done' => 'Done',
    'export_status_failed' => 'Failed',
    'export_not_done' => 'Download impossible, this export is not done yet.',

    'firstname' => 'Όνομα',
    'lastname' => 'Επώνυμο',
    'name_order' => 'Εμφάνιση ονόματος',
    'name_order_firstname_lastname' => '<First name> <Last name> – Τάδε Δείνα',
    'name_order_lastname_firstname' => '<Last name> <First name> – Δείνα Τάδε',
    'name_order_firstname_lastname_nickname' => '<Όνομα> <Επώνυμο> (<Ψευδώνυμο>) – Γιάννης Τάδε (Ράμπο)',
    'name_order_firstname_nickname_lastname' => '<Όνομα> (<Ψευδώνυμο>) <Επώνυμο> – Γιάννης (Ράμπο) Τάδε',
    'name_order_lastname_firstname_nickname' => '<Επώνυμο> <Όνομα> (<Ψευδώνυμο>) – Τάδε Γιάννης (Ράμπο)',
    'name_order_lastname_nickname_firstname' => '<Επώνυμο> (<Ψευδώνυμο>) <Όνομα> – Τάδε (Ράμπο) Γιάννης',
    'name_order_nickname_firstname_lastname' => '<Ψευδώνυμο> (<Όνομα> <Επώνυμο>) – Ράμπο (Γιάννης Τάδε)',
    'name_order_nickname_lastname_firstname' => '<Ψευδώνυμο> (<Επώνυμο> <Όνομα>) – Ράμπο (Τάδε Γιάννης)',
    'name_order_nickname' => '<Ψευδώνυμο> – Ράμπο',
    'currency' => 'Nόμισμα',
    'name' => 'Το όνομά σας: :name',
    'email' => 'Διεύθυνση email',
    'email_placeholder' => 'Εισάγετε email',
    'email_help' => 'Αυτό είναι το email που χρησιμοποιείται για την σύνδεση, και στο οποίο θα λαμβάνετε τις ειδοποιήσεις σας.',
    'timezone' => 'Ζώνη ώρας',
    'temperature_scale' => 'Κλίμακα θερμοκρασίας',
    'temperature_scale_fahrenheit' => 'Fahrenheit (°F)',
    'temperature_scale_celsius' => 'Celsius (°C)',
    'layout' => 'Διάταξη',
    'layout_small' => 'Μέγιστο πλάτος 1200 εικονοστοιχείων',
    'layout_big' => 'Πλήρες πλάτος του προγράμματος περιήγησης',
    'save' => 'Ενημέρωση προτιμήσεων',
    'delete_title' => 'Διαγραφή του λογαριασμού σας',
    'delete_desc' => 'Θέλετε να διαγράψετε τον λογαριασμό σας; Η διαγραφή είναι μόνιμη και όλα τα δεδομένα σας θα διαγραφούν οριστικά. Εάν έχετε συνδρομή, θα ακυρωθεί αμέσως.',
    'delete_other_desc' => 'Your data in the main database will be deleted immediately. As described in our privacy policy, we carry out securely encrypted backups of the database every day.  These backups are kept for 30 days after which they are completely deleted. We cannot delete specific data from the backups we hold any earlier than this.  All of your data will be completely deleted no later than 31 days after your account’s deletion.',
    'reset_desc' => 'Θέλετε να κάνετε επαναφορά του λογαριασμού σας; Αυτό θα καταργήσει όλες τις επαφές σας και όλα τα δεδομένα που σχετίζονται με αυτές. Ο λογαριασμός σας δεν θα διαγραφεί.',
    'reset_title' => 'Επαναφορά του λογαριασμού σας',
    'reset_cta' => 'Επαναφορά λογαριασμού',
    'reset_notice' => 'Είστε βέβαιοι ότι θέλετε να κάνετε επαναφορά στο λογαριασμό σας; Αυτό είναι μια μόνιμη κατάσταση και δεν μπορεί να αναιρεθεί.',
    'reset_success' => 'Η επαναφορά του λογαριασμού σας έγινε με επιτυχία.',
    'delete_notice' => 'Είστε βέβαιοι ότι θέλετε να διαγράψετε τον λογαριασμό σας; Αυτό είναι μόνιμο και δεν μπορεί να αναιρεθεί. Όλα τα δεδομένα σας θα διαγραφούν και δεν θα ανακτηθούν.',
    'delete_cta' => 'Διαγραφή λογαριασμού',
    'settings_success' => 'Οι προτιμήσεις ενημερώθηκαν!',
    'locale' => 'Γλώσσα που χρησιμοποιείται στην εφαρμογή',
    'locale_help' => 'Θέλετε να βοηθήσετε στη μετάφραση της Μόνικα ή να προσθέσετε μια νέα γλώσσα; Παρακαλώ ακολουθήστε <a href=":url" target="_blank" lang="en">αυτόν τον σύνδεσμο για περισσότερες πληροφορίες</a>.',
    'locale_ar' => 'Αραβικά',
    'locale_cs' => 'Τσέχικα',
    'locale_de' => 'Γερμανικά',
    'locale_el' => 'Ελληνικά',
    'locale_en' => 'Αγγλικά',
    'locale_en-GB' => 'Αγγλικά (Ηνωμένου Βασιλείου)',
    'locale_es' => 'Ισπανικά',
    'locale_fr' => 'Γαλλικά',
    'locale_he' => 'Εβραϊκά',
    'locale_hr' => 'Κροάτια',
    'locale_id' => 'Ινδονησιακά',
    'locale_it' => 'Ιταλικά',
    'locale_ja' => 'Ιαπωνικά',
    'locale_nl' => 'Ολλανδικά',
    'locale_pt' => 'Πορτογαλικά',
    'locale_pt-BR' => 'Βραζιλιάνικα',
    'locale_ru' => 'Ρωσικά',
    'locale_sv' => 'Σουηδικά',
    'locale_vi' => 'Βιετναμέζικα',
    'locale_zh' => 'Κινεζικά (απλοποιημένα)',
    'locale_zh-TW' => 'Κινεζικά (παραδοσιακά)',
    'locale_tr' => 'Τουρκικά',

    'security_title' => 'Ασφάλεια',
    'security_help' => 'Αλλάξτε θέματα ασφαλείας για το λογαριασμό σας.',
    'password_change' => 'Αλλάξτε τον κωδικό πρόσβασής σας',
    'password_current' => 'Τρέχον κωδικός πρόσβασης',
    'password_current_placeholder' => 'Εισαγάγετε τον τρέχοντα κωδικό πρόσβασης',
    'password_new1' => 'Νέος κωδικός πρόσβασης',
    'password_new1_placeholder' => 'Εισάγετε το νέο σας κωδικό',
    'password_new2' => 'Επιβεβαιώστε τον νέο κωδικό σας',
    'password_new2_placeholder' => 'Πληκτρολογήστε ξανά τον νέο σας κωδικό',
    'password_btn' => 'Αλλαγή κωδικού πρόσβασης',
    '2fa_title' => 'Έλεγχος ταυτότητας δυο παραγόντων',
    '2fa_otp_title' => 'Two Factor Authentication mobile application',
    '2fa_enable_title' => 'Enable Two Factor Authentication',
    '2fa_enable_description' => 'Enable Two Factor Authentication to increase the security of your account.',
    '2fa_enable_otp' => 'Open up your Two Factor Authentication mobile app and scan the following QR barcode:',
    '2fa_enable_otp_help' => 'If your Two Factor Authentication mobile app does not support QR barcodes, enter in the following code:',
    '2fa_enable_otp_validate' => 'Please validate the new device you’ve just set up:',
    '2fa_enable_success' => 'Two Factor Authentication activated',
    '2fa_enable_error' => 'Error when trying to activate Two Factor Authentication',
    '2fa_enable_error_already_set' => 'Two Factor Authentication is already activated',
    '2fa_disable_title' => 'Disable Two Factor Authentication',
    '2fa_disable_description' => 'Disable Two Factor Authentication for your account. Be careful, your account will be much less secure!',
    '2fa_disable_success' => 'Two Factor Authentication disabled',
    '2fa_disable_error' => 'Error when trying to disable Two Factor Authentication',

    'webauthn_title' => 'Security key — WebAuthn protocol',
    'webauthn_enable_description' => 'Add a new security key',
    'webauthn_key_name_help' => 'Give your key a name.',
    'webauthn_key_name' => 'Key name:',
    'webauthn_success' => 'Your key is detected and validated.',
    'webauthn_last_use' => 'Last use: {timestamp}',
    'webauthn_delete_confirmation' => 'Are you sure you want to delete this key?',
    'webauthn_delete_success' => 'Key deleted',
    'webauthn_insertKey' => 'Insert your security key.',
    'webauthn_buttonAdvise' => 'If your security key has a button, press it.',
    'webauthn_noButtonAdvise' => 'If it does not, remove it and insert it again.',
    'webauthn_not_supported' => 'Your browser doesn’t currently support WebAuthn.',
    'webauthn_not_secured' => 'WebAuthn only supports secure connections. Please load this page with https scheme.',
    'webauthn_error_already_used' => 'This key is already registered. It’s not necessary to register it again.',
    'webauthn_error_not_allowed' => 'The operation either timed out or was not allowed.',

    'recovery_title' => 'Κωδικοί ανάκτησης',
    'recovery_show' => 'Λήψη κωδικών ανάκτησης',
    'recovery_copy_help' => 'Αντιγράψτε τους κωδικούς στο πρόχειρο σας',
    'recovery_help_intro' => 'Αυτοί είναι οι κωδικοί ανάκτησης σας:',
    'recovery_help_information' => 'Μπορείτε να χρησιμοποιήσετε κάθε κωδικό ανάκτησης μόνο μία φορά.',
    'recovery_clipboard' => 'Οι κωδικοί αντιγράφηκαν στο πρόχειρο.',
    'recovery_generate' => 'Δημιουργία νέων κωδικών…',
    'recovery_generate_help' => 'Η δημιουργία νέων κωδικών θα ακυρώσει τους προηγούμενους κωδικούς.',
    'recovery_already_used_help' => 'Αυτός ο κωδικός έχει ήδη χρησιμοποιηθεί.',

    'users_list_title' => 'Users with access to your account',
    'users_list_add_user' => 'Invite a new user',
    'users_list_you' => 'That’s you',
    'users_list_invitations_title' => 'Pending invitations',
    'users_list_invitations_explanation' => 'Below are the people you’ve invited to join Monica as a collaborator.',
    'users_list_invitations_invited_by' => 'invited by :name',
    'users_list_invitations_sent_date' => 'sent on :date',
    'users_blank_title' => 'You are the only one who has access to this account.',
    'users_blank_add_title' => 'Would you like to invite someone else?',
    'users_blank_description' => 'This person will have the same access that you have, and will be able to add, edit or delete contact information.',
    'users_blank_cta' => 'Invite someone',
    'users_add_title' => 'Invite a new user to your account by email',
    'users_add_description' => 'This person will have the same access as you do, including inviting or deleting other users, including you. Make sure you trust this person before giving them access.',
    'users_add_email_field' => 'Enter the email of the person you want to invite',
    'users_add_confirmation' => 'I confirm that I want to invite this user to my account. I understand that this person will have access to ALL of my data and see exactly what I see.',
    'users_add_cta' => 'Invite user by email',
    'users_accept_title' => 'Accept invitation and create a new account',
    'users_error_please_confirm' => 'Please confirm that you want to invite this user before proceeding with the invitation',
    'users_error_email_already_taken' => 'This email is already taken. Please choose another one',
    'users_error_already_invited' => 'You already have invited this user. Please choose another email address.',
    'users_error_email_not_similar' => 'This is not the email of the person who’ve invited you.',
    'users_invitation_deleted_confirmation_message' => 'The invitation has been successfully deleted',
    'users_invitations_delete_confirmation' => 'Are you sure you want to delete this invitation?',
    'users_list_delete_confirmation' => 'Are you sure to delete this user from your account?',
    'users_invitation_need_subscription' => 'Adding more users requires a subscription.',

    'subscriptions_account_current_plan' => 'Your current plan',
    'subscriptions_account_current_legacy' => 'Current plan, not selectable anymore:',
    'subscriptions_account_current_paid_plan' => 'You are on the :name plan. Thanks so much for being a subscriber.',

    'subscriptions_account_next_billing_title' => 'Next bill',
    'subscriptions_account_next_billing' => 'Your subscription will auto-renew on <strong>:date</strong>.',
    'subscriptions_account_bill_monthly' => 'We’ll bill you <strong>:price</strong> for another <strong>month</strong>.',
    'subscriptions_account_bill_annual' => 'We’ll bill you <strong>:price</strong> for another <strong>year</strong>.',
    'subscriptions_account_change' => 'Change plan',

    'subscriptions_account_cancel_title' => 'Cancel subscription',
    'subscriptions_account_cancel_action' => 'Cancel subscription',
    'subscriptions_account_cancel' => 'You can cancel your subscription at any time.',
    'subscriptions_account_free_plan' => 'You are on the free plan.',
    'subscriptions_account_free_plan_upgrade' => 'You can upgrade your account to the :name plan, which costs $:price per month. Here are the advantages:',
    'subscriptions_account_free_plan_benefits_users' => 'Unlimited number of users',
    'subscriptions_account_free_plan_benefits_reminders' => 'Reminders by email',
    'subscriptions_account_free_plan_benefits_import_data_vcard' => 'Import your contacts with vCard',
    'subscriptions_account_free_plan_benefits_support' => 'Support the project in the long run, so we can introduce more great features.',
    'subscriptions_account_upgrade' => 'Upgrade your account',
    'subscriptions_account_upgrade_title' => 'Upgrade Monica today and have more meaningful relationships.',
    'subscriptions_account_upgrade_choice' => 'Pick a plan below and join over :customers persons who upgraded their Monica.',
    'subscriptions_account_update_title' => 'Update Monica subscription',
    'subscriptions_account_update_description' => 'You can change your subscription’s frequency here.',
    'subscriptions_account_update_information' => 'You will be billed immediately for the new amount. Your subscription will extend to the new period, depending on your choice.',
    'subscriptions_account_invoices' => 'Invoices',
    'subscriptions_account_invoices_download' => 'Download',
    'subscriptions_account_invoices_subscription' => 'Subscription from :startDate to :endDate',
    'subscriptions_account_payment' => 'Which payment option fits you best?',
    'subscriptions_account_confirm_payment' => 'Your payment is currently incomplete, please <a href=":url">confirm your payment</a>.',
    'subscriptions_downgrade_title' => 'Downgrade your account to the free plan',
    'subscriptions_downgrade_limitations' => 'The free plan has limitations. In order to be able to downgrade, you need to pass the checklist below:',
    'subscriptions_downgrade_rule_users' => 'You must have only 1 user in your account',
    'subscriptions_downgrade_rule_users_constraint' => 'You currently have <a href=":url">1 user</a> in your account.|You currently have <a href=":url">:count users</a> in your account.',
    'subscriptions_downgrade_rule_invitations' => 'You must not have any pending invitations',
    'subscriptions_downgrade_rule_invitations_constraint' => 'You currently have <a href=":url">1 pending invitation</a>.|You currently have <a href=":url">:count pending invitations</a>.',
    'subscriptions_downgrade_rule_contacts' => 'You must not have more than :number active contacts',
    'subscriptions_downgrade_rule_contacts_constraint' => 'You currently have <a href=":url">1 contact</a>.|You currently have <a href=":url">:count contacts</a>.',
    'subscriptions_downgrade_rule_contacts_archive' => 'We can also <a href=":url">archive all your contacts for you</a> – that would clear this rule and let you proceed with your account’s downgrade process.',
    'subscriptions_downgrade_cta' => 'Downgrade',
    'subscriptions_downgrade_success' => 'You are back to the Free plan!',
    'subscriptions_downgrade_thanks' => 'Thanks so much for trying the paid plan. We keep adding new features on Monica all the time – so you might want to come back in the future to see if you might be interested in taking a subscription again.',
    'subscriptions_back' => 'Back to settings',
    'subscriptions_upgrade_title' => 'Upgrade your account',
    'subscriptions_upgrade_choose' => 'You picked the :plan plan.',
    'subscriptions_upgrade_infos' => 'We couldn’t be happier. Enter your payment info below.',
    'subscriptions_upgrade_name' => 'Name on card',
    'subscriptions_upgrade_zip' => 'ZIP or postal code',
    'subscriptions_upgrade_credit' => 'Credit or debit card',
    'subscriptions_upgrade_submit' => 'Pay {amount}',
    'subscriptions_upgrade_charge' => 'We’ll charge your card :price now. The next charge will be on :date. If you ever change your mind, you can cancel at any time, no questions asked.',
    'subscriptions_upgrade_charge_handled' => 'The payment is handled by <a href=":url">Stripe</a>. No card information touches our server.',
    'subscriptions_upgrade_success' => 'Thank you! You are now subscribed.',
    'subscriptions_upgrade_thanks' => 'Welcome to the community of people who try to make the world a better place.',

    'subscriptions_payment_confirm_title' => 'Confirm your :amount payment',
    'subscriptions_payment_confirm_information' => 'Extra confirmation is needed to process your payment. Please confirm your payment by filling out your payment details below.',
    'subscriptions_payment_succeeded_title' => 'Payment Successful',
    'subscriptions_payment_succeeded' => 'This payment was already successfully confirmed.',
    'subscriptions_payment_cancelled_title' => 'Payment Cancelled',
    'subscriptions_payment_cancelled' => 'This payment was cancelled.',
    'subscriptions_payment_error_name' => 'Please provide your name.',
    'subscriptions_payment_success' => 'The payment was successful.',

    'subscriptions_pdf_title' => 'Your :name monthly subscription',
    'subscriptions_plan_frequency_year' => ':amount / year',
    'subscriptions_plan_frequency_month' => ':amount / month',
    'subscriptions_plan_choose' => 'Choose this plan',
    'subscriptions_plan_year_title' => 'Pay annually',
    'subscriptions_plan_year_bonus' => 'Peace of mind for a whole year',
    'subscriptions_plan_month_title' => 'Pay monthly',
    'subscriptions_plan_month_bonus' => 'Cancel any time',
    'subscriptions_plan_include1' => 'Included with your upgrade:',
    'subscriptions_plan_include2' => 'Unlimited number of contacts • Unlimited number of users • Reminders by email • Import with vCard • Personalization of the contact sheet',
    'subscriptions_plan_include3' => '100% of the profits go the development of this great open source project.',
    'subscriptions_help_title' => 'Additional details you may be curious about',
    'subscriptions_help_opensource_title' => 'What is an open source project?',
    'subscriptions_help_opensource_desc' => 'Monica is an open source project.  This means it is built by a community who wants to build a great tool for the greater good. Being open source means the code is publicly available on GitHub, and everyone can inspect it, modify it or enhance it. All the money we raise is dedicated to building better features, paying for more powerful servers, and paying other costs. Thanks for your help. We couldn’t do it without you.',
    'subscriptions_help_limits_title' => 'Is there a limit to the number of contacts we can have on the free plan?',
    'subscriptions_help_limits_plan' => 'Yes. Free plans let you manage :number contacts.',
    'subscriptions_help_discounts_title' => 'Do you have discounts for non-profits and education?',
    'subscriptions_help_discounts_desc' => 'We do! Monica is free for students, and free for non-profits and charities. Just contact <a href=":support">the support</a> with a proof of your status and we’ll apply this special status in your account.',
    'subscriptions_help_change_title' => 'What if I change my mind?',
    'subscriptions_help_change_desc' => 'You can cancel anytime, no questions asked, and all by yourself – no need to contact support. However, you will not be refunded for the current period.',

    'stripe_error_card' => 'Your card was declined. Decline message is: :message',
    'stripe_error_api_connection' => 'Network communication with Stripe failed. Try again later.',
    'stripe_error_rate_limit' => 'Too many requests with Stripe right now. Try again later.',
    'stripe_error_invalid_request' => 'Invalid parameters. Try again later.',
    'stripe_error_authentication' => 'Wrong authentication with Stripe',

    'import_title' => 'Εισαγωγή επαφών στο λογαριασμό σας',
    'import_cta' => 'Μεταφόρτωση επαφών',
    'import_stat' => 'Έχετε εισάγει :number αρχεία μέχρι στιγμής.',
    'import_result_stat' => 'Μεταφορτώθηκε vCard με 1 επαφή (:total_imported εισήχθηκε, :total_skipped παραλείφθηκε)|Μεταφορτώθηκε vCard με :total_contacts επαφές (:total_imported εισήχθησαν, :total_skipped παραλείφθηκαν)',
    'import_view_report' => 'Προβολή αναφοράς',
    'import_in_progress' => 'Η εισαγωγή βρίσκεται σε εξέλιξη. Κάνετε μια ανανέωση της σελίδας σε ένα λεπτό.',
    'import_upload_title' => 'Εισαγωγή των επαφών σας από ένα αρχείο vCard',
    'import_upload_rules_desc' => 'Ωστόσο, έχουμε ορισμένους κανόνες:',
    'import_upload_rule_format' => 'Υποστηρίζουμε αρχεία <code>.vcard</code> και <code>.vcf</code>.',
    'import_upload_rule_vcard' => 'Υποστηρίζουμε τη μορφή vCard 3.0, η οποία είναι η προεπιλεγμένη μορφή για το Contacts.app του macOS και τις Επαφές Google.',
    'import_upload_rule_instructions' => 'Οδηγίες εξαγωγής για <a href=":url1" target="_blank" rel="noopener noreferrer">macOS Contacts.app</a> και <a href=":url2" target="_blank" rel="noopener noreferrer">Google Contacts</a>.',
    'import_upload_rule_multiple' => 'Εάν οι επαφές σας έχουν πολλές διευθύνσεις email ή αριθμούς τηλεφώνου, μόνο η πρώτη καταχώριση θα αποθηκευτεί.',
    'import_upload_rule_limit' => 'Τα αρχεία έχουν περιορισμό στα 10 MB.',
    'import_upload_rule_time' => 'Μπορεί να χρειαστεί έως και ένα λεπτό για τη μεταφόρτωση των επαφών και την επεξεργασία τους. Παρακαλώ να είστε υπομονετικοί.',
    'import_upload_rule_cant_revert' => 'Βεβαιωθείτε ότι τα δεδομένα είναι ακριβή πριν από τη μεταφόρτωση, καθώς δεν μπορείτε να αναιρέσετε τη μεταφόρτωση.',
    'import_upload_form_file' => 'Το αρχείο σας <code>.vcf</code> ή <code>.vCard</code>:',
    'import_upload_behaviour' => 'Συμπεριφορά κατά την εισαγωγή:',
    'import_upload_behaviour_add' => 'Προσθήκη νέων επαφών και παράλειψη για τις υπάρχουσες',
    'import_upload_behaviour_replace' => 'Αντικατάσταση για τις υπάρχουσες επαφές',
    'import_upload_behaviour_help' => 'Η αντικατάσταση θα αντικαταστήσει όλα τα δεδομένα που βρίσκονται στην vCard, αλλά θα διατηρήσει τα υπάρχοντα πεδία επαφών.',
    'import_report_title' => 'Αναφορά εισαγωγής',
    'import_report_date' => 'Ημερομηνία εισαγωγής',
    'import_report_type' => 'Είδος εισαγωγής',
    'import_report_number_contacts' => 'Αριθμός επαφών στο αρχείο',
    'import_report_number_contacts_imported' => 'Αριθμός επαφών που έχουν εισαχθεί',
    'import_report_number_contacts_skipped' => 'Αριθμός επαφών που παραλείφθηκαν',
    'import_report_status_imported' => 'Εισαγωγή',
    'import_report_status_skipped' => 'Παράλειψη',
    'import_vcard_parse_error' => 'Σφάλμα κατά την ανάλυση της καταχώρισης vCard',
    'import_vcard_contact_exist' => 'Η επαφή υπάρχει ήδη',
    'import_vcard_contact_no_firstname' => 'Χωρίς Όνομα (υποχρεωτικό πεδίο)',
    'import_vcard_file_not_found' => 'Το αρχείο δεν βρέθηκε',
    'import_vcard_unknown_entry' => 'Άγνωστο όνομα επαφής',
    'import_vcard_file_no_entries' => 'Το αρχείο δεν περιέχει καταχωρήσεις',
    'import_blank_title' => 'Δεν έχετε εισαγάγει ακόμη καμία επαφή.',
    'import_blank_question' => 'Θέλετε να εισάγετε επαφές τώρα;',
    'import_blank_description' => 'Μπορούμε να εισαγάγουμε αρχεία vCard που μπορείτε να λάβετε από το Google Contacts ή τον διαχειριστή επαφών σας.',
    'import_blank_cta' => 'Εισαγωγή vCard',
    'import_need_subscription' => 'Η εισαγωγή δεδομένων απαιτεί συνδρομή.',

    'tags_list_title' => 'Ετικέτες',
    'tags_list_description' => 'Μπορείτε να οργανώσετε τις επαφές σας χρησιμοποιώντας ετικέτες. Οι ετικέτες λειτουργούν σαν φάκελοι οργάνωσης, αλλά μπορείτε να προσθέσετε περισσότερες από μία ετικέτες σε κάθε επαφή. Για να δημιουργήσετε μια νέα ετικέτα, απλά προσθέστε την στην ίδια την επαφή.',
    'tags_list_contact_number' => '1 επαφή|:count επαφές',
    'tags_list_delete_success' => 'Η ετικέτα έχει διαγραφεί με επιτυχία',
    'tags_list_delete_confirmation' => 'Είστε βέβαιοι ότι θέλετε να διαγράψετε την ετικέτα? Καμία επαφή δεν θα διαγραφεί, μόνο αυτή η ετικέτα από τις επαφές που είχε χρησιμοποιηθεί.',
    'tags_blank_title' => 'Οι ετικέτες είναι ένας πολύ καλός τρόπος για να κατηγοριοποιήσετε τις επαφές σας.',
    'tags_blank_description' => 'Οι ετικέτες λειτουργούν σαν φάκελοι οργάνωσης, ενώ μπορείτε να προσθέσετε περισσότερες από μία ετικέτες σε μια επαφή. Μεταβείτε σε μια επαφή και προσθέστε μια ετικέτα, ακριβώς κάτω από το όνομα. Μόλις προστεθεί η ετικέτα, μπορείτε να επιστρέψτε εδώ για να διαχειριστείτε όλες τις ετικέτες στον λογαριασμό σας.',

    'api_title' => 'API access',
    'api_description' => 'The API can be used to manipulate Monica’s data from an external application, like a mobile application for instance.',
    'api_help' => 'To use the API, a token is mandatory. You can either create a personal access token (Bearer authentication), or authorize an OAuth client to create it for you. See <a href=":url">API documentation</a>.',
    'api_endpoint' => 'The API endpoint for this Monica instance is:',

    'api_personal_access_tokens' => 'Personal access tokens',
    'api_pao_description' => 'Make sure you give this token to a source you trust – as they allow you to access all your data.',
    'api_token_title' => 'Personal Access Tokens',
    'api_token_create_new' => 'Create New Token',
    'api_token_not_created' => 'You have not created any personal access tokens.',
    'api_token_name' => 'Token name',
    'api_token_expire' => 'Expires at {date}',
    'api_token_delete' => 'Delete',
    'api_token_create' => 'Create Token',
    'api_token_scopes' => 'Scopes',
    'api_token_help' => 'Here is your new personal access token. This is the only time it will be shown so don’t lose it! You may now use this token to make API requests.',

    'api_oauth_clients' => 'Your OAuth clients',
    'api_oauth_clients_desc' => 'This section lets you register your own OAuth clients.',
    'api_oauth_clients_desc2' => 'Use this client id to request a new token, and convert authorization codes to access tokens. See <a href="{url}">Laravel Passport documentation</a> for more information.',
    'api_oauth_title' => 'OAuth Clients',
    'api_oauth_create_new' => 'Create New Client',
    'api_oauth_edit' => 'Edit Client',
    'api_oauth_not_created' => 'You have not created any OAuth clients.',
    'api_oauth_clientid' => 'Client ID',
    'api_oauth_name' => 'Name',
    'api_oauth_name_help' => 'Something your users will recognize and trust.',
    'api_oauth_secret' => 'Secret',
    'api_oauth_create' => 'Create Client',
    'api_oauth_redirecturl' => 'Redirect URL',
    'api_oauth_redirecturl_help' => 'Your application’s authorization callback URL.',

    'api_authorized_clients' => 'List of authorized clients',
    'api_authorized_clients_desc' => 'This section lists all the clients you’ve authorized to access your application data. You can revoke this authorization at anytime.',
    'api_authorized_clients_title' => 'Authorized Applications',
    'api_authorized_clients_none' => 'There are no authorized clients yet.',
    'api_authorized_clients_name' => 'Name',
    'api_authorized_clients_scopes' => 'Scopes',

    'personalization_tab_title' => 'Προσαρμόστε τον λογαριασμό σας',

    'personalization_title' => 'Εδώ θα βρείτε διάφορες ρυθμίσεις για τη διαμόρφωση του λογαριασμού σας. Αυτές οι δυνατότητες προορίζονται για «προχωρημένους» χρήστες που θέλουν μέγιστο έλεγχο της Monica.',
    'personalization_contact_field_type_title' => 'Τύποι πεδίων επαφών',
    'personalization_contact_field_type_add' => 'Προσθήκη νέου τύπου πεδίων',
    'personalization_contact_field_type_description' => 'You can configure all the different types of contact fields that you can associate to all your contacts. For example, if a new social network appears in the future, you will be able to add this new way of communicating with your contacts right here.',
    'personalization_contact_field_type_table_name' => 'Όνομα',
    'personalization_contact_field_type_table_protocol' => 'Πρωτόκολλο',
    'personalization_contact_field_type_table_actions' => 'Ενέργειες',
    'personalization_contact_field_type_modal_title' => 'Προσθήκη νέου τύπου πεδίου επαφής',
    'personalization_contact_field_type_modal_edit_title' => 'Επεξεργασία ενός υπάρχοντος τύπου πεδίου επαφής',
    'personalization_contact_field_type_modal_delete_title' => 'Διαγραφή ενός υπάρχοντος τύπου πεδίου επαφής',
    'personalization_contact_field_type_modal_delete_description' => 'Είστε βέβαιοι ότι θέλετε να διαγράψετε αυτόν τον τύπο πεδίου επαφών; Η διαγραφή αυτού του τύπου πεδίου επαφών θα διαγράψει ΟΛΑ τα δεδομένα με αυτόν τον τύπο για όλες τις επαφές σας.',
    'personalization_contact_field_type_modal_name' => 'Όνομα',
    'personalization_contact_field_type_modal_protocol' => 'Πρωτόκολλο (προαιρετικό)',
    'personalization_contact_field_type_modal_protocol_help' => 'Μπορείτε να κάνετε κλικ σε κάθε νέο τύπο πεδίου επαφών. Εάν έχει οριστεί ένα πρωτόκολλο, θα γίνεται χρήση με την ενέργεια που έχει οριστεί.',
    'personalization_contact_field_type_modal_icon' => 'Εικονίδιο (προαιρετικό)',
    'personalization_contact_field_type_modal_icon_help' => 'Μπορείτε να συσχετίσετε ένα εικονίδιο με αυτόν τον τύπο πεδίου επαφών. Πρέπει να κάνετε χρήση αναφοράς σε ένα εικονίδιο Font Awesome.',
    'personalization_contact_field_type_delete_success' => 'Ο τύπος πεδίου επαφών έχει διαγραφεί επιτυχώς.',
    'personalization_contact_field_type_add_success' => 'Ο τύπος πεδίου επαφών έχει προστεθεί με επιτυχία.',
    'personalization_contact_field_type_edit_success' => 'Ο τύπος πεδίου επαφών έχει ενημερωθεί με επιτυχία.',

    'personalization_genders_title' => 'Gender types',
    'personalization_genders_add' => 'Add new gender type',
    'personalization_genders_desc' => 'You can define as many genders as you need to. You need at least one gender type in your account.',
    'personalization_genders_modal_add' => 'Add gender type',
    'personalization_genders_modal_edit' => 'Update gender type',
    'personalization_genders_modal_name' => 'Name',
    'personalization_genders_modal_name_help' => 'The name used to display the gender on a contact page.',
    'personalization_genders_modal_sex' => 'Sex',
    'personalization_genders_modal_sex_help' => 'Used to define the relationships, and during the VCard import/export process.',
    'personalization_genders_modal_default' => 'Select the default gender for a new contact',
    'personalization_genders_modal_delete' => 'Delete gender type',
    'personalization_genders_modal_delete_desc' => 'Are you sure you want to delete the gender “{name}”?',
    'personalization_genders_modal_delete_question' => 'You currently have {count} contact with this gender. If you delete this gender, what gender should this contact have?|You currently have {count} contacts with this gender. If you delete this gender, what gender should these contacts have?',
    'personalization_genders_modal_delete_question_default' => 'This gender is the default one. If you delete this gender, which one will be the new default?',
    'personalization_genders_modal_error' => 'Please choose a gender from the list.',
    'personalization_genders_list_contact_number' => '{count} contact|{count} contacts',
    'personalization_genders_table_name' => 'Name',
    'personalization_genders_table_sex' => 'Sex',
    'personalization_genders_table_default' => 'Default',
    'personalization_genders_default' => 'Default gender',
    'personalization_genders_make_default' => 'Change default gender',
    'personalization_genders_select_default' => 'Select default gender',
    'personalization_genders_m' => 'Male',
    'personalization_genders_f' => 'Female',
    'personalization_genders_o' => 'Other',
    'personalization_genders_u' => 'Unknown',
    'personalization_genders_n' => 'None or not applicable',

    'personalization_reminder_rule_save' => 'The change has been saved',
    'personalization_reminder_rule_title' => 'Κανόνες υπενθύμισης',
    'personalization_reminder_rule_line' => '{count} ημέρα νωρίτερα|{count} ημέρες νωρίτερα',
    'personalization_reminder_rule_desc' => 'Για κάθε υπενθύμιση που ορίζετε, η Monica μπορεί να σας στείλει ένα email αρκετές ημέρες πριν από το γεγονός. Εδώ μπορείτε να προσαρμόσετε αυτές τις ρυθμίσεις ειδοποιήσεων. Αυτές οι ειδοποιήσεις ισχύουν μόνο για μηνιαίες και ετήσιες υπενθυμίσεις.',

    'personalization_module_save' => 'Η αλλαγή έχει αποθηκευτεί',
    'personalization_module_title' => 'Δυνατότητες',
    'personalization_module_desc' => 'Μπορεί να μην χρειάζεστε όλες τις δυνατότητες της Monica. Παρακάτω μπορείτε να αλλάξετε συγκεκριμένες λειτουργίες που δε χρειάζεστε στις καρτέλες επαφών. Αυτή η αλλαγή θα επηρεάσει την εμφάνιση σε ΟΛΕΣ τις επαφές σας. Η απενεργοποίηση μιας λειτουργίας δεν διαγράφει δεδομένα, απλώς αποκρύπτει τη δυνατότητα από τις καρτέλες επαφών.',

    'personalisation_paid_upgrade' => 'This is a premium feature that requires a Paid subscription to be active. Upgrade your account by visiting <a href=":url">Settings > Subscription</a>.',
    'personalisation_paid_upgrade_vue' => 'This is a premium feature that requires a Paid subscription to be active. Upgrade your account by visiting <a href="{url}">Settings > Subscription</a>.',

    'reminder_time_to_send' => 'Time of the day reminders will be sent',
    'reminder_time_to_send_help' => 'Your next reminder is scheduled to be sent on <span title="{dateTimeUtc}" class="reminder-info">{dateTime}</span>.',

    'personalization_activity_type_category_title' => 'Activity type categories',
    'personalization_activity_type_category_add' => 'Add a new activity type category',
    'personalization_activity_type_category_table_name' => 'Name',
    'personalization_activity_type_category_description' => 'An activity with one of your contacts can have a type and a category type. Your account comes with a set of predefined category types by default, but you can customize these here.',
    'personalization_activity_type_category_table_actions' => 'Actions',
    'personalization_activity_type_category_modal_add' => 'Add a new activity type category',
    'personalization_activity_type_category_modal_edit' => 'Edit an activity type category',
    'personalization_activity_type_category_modal_question' => 'What should we name this new category?',
    'personalization_activity_type_add_button' => 'Add a new activity type',
    'personalization_activity_type_modal_add' => 'Add a new activity type',
    'personalization_activity_type_modal_question' => 'What should we name this new activity type?',
    'personalization_activity_type_modal_edit' => 'Edit an activity type',
    'personalization_activity_type_category_modal_delete' => 'Delete an activity type category',
    'personalization_activity_type_category_modal_delete_desc' => 'Are you sure you want to delete this category? Deleting it will delete all associated activity types. Activities that belong to this category will not be affected by this deletion.',
    'personalization_activity_type_modal_delete' => 'Delete an activity type',
    'personalization_activity_type_modal_delete_desc' => 'Are you sure you want to delete this activity type? Activities that belong to this category will not be affected by this deletion.',
    'personalization_activity_type_modal_delete_error' => 'We can’t find this activity type.',
    'personalization_activity_type_category_modal_delete_error' => 'We can’t find this activity type category.',

    'personalization_life_event_category_title' => 'Life event categories',
    'personalization_live_event_category_table_name' => 'Name',
    'personalization_life_event_category_description' => 'A life event can have a type and a category. Your account comes with a set of predefined categories and types by default, but you can customize life event types here.',
    'personalization_live_event_category_table_actions' => 'Actions',
    'personalization_life_event_type_add_button' => 'Add a new life event type',
    'personalization_life_event_type_modal_add' => 'Add a new life event type',
    'personalization_life_event_type_modal_question' => 'What should we name this new life event type?',
    'personalization_life_event_type_modal_edit' => 'Edit a life event type',
    'personalization_life_event_type_modal_delete' => 'Delete a life event type',
    'personalization_life_event_type_modal_delete_desc' => 'Are you sure you want to delete this life event type? Life events that belong to this type will be deleted by performing this action.',
    'personalization_life_event_type_modal_delete_error' => 'We can’t find this life event type.',

    'personalization_life_event_category_work_education' => 'Work & education',
    'personalization_life_event_category_family_relationships' => 'Family & relationships',
    'personalization_life_event_category_home_living' => 'Home & living',
    'personalization_life_event_category_travel_experiences' => 'Travel & experiences',
    'personalization_life_event_category_health_wellness' => 'Health & wellness',

    'personalization_life_event_type_new_job' => 'New job',
    'personalization_life_event_type_retirement' => 'Retirement',
    'personalization_life_event_type_new_school' => 'New school',
    'personalization_life_event_type_study_abroad' => 'Study abroad',
    'personalization_life_event_type_volunteer_work' => 'Volunteer work',
    'personalization_life_event_type_published_book_or_paper' => 'Published a book or paper',
    'personalization_life_event_type_military_service' => 'Military service',
    'personalization_life_event_type_first_met' => 'First met',
    'personalization_life_event_type_new_relationship' => 'New relationship',
    'personalization_life_event_type_engagement' => 'Engagement',
    'personalization_life_event_type_marriage' => 'Marriage',
    'personalization_life_event_type_anniversary' => 'Anniversary',
    'personalization_life_event_type_expecting_a_baby' => 'Expecting a baby',
    'personalization_life_event_type_new_child' => 'New child',
    'personalization_life_event_type_new_family_member' => 'New family member',
    'personalization_life_event_type_new_pet' => 'New pet',
    'personalization_life_event_type_end_of_relationship' => 'End of relationship',
    'personalization_life_event_type_loss_of_a_loved_one' => 'Loss of a loved one',
    'personalization_life_event_type_moved' => 'Moved',
    'personalization_life_event_type_bought_a_home' => 'Bought a home',
    'personalization_life_event_type_home_improvement' => 'Home improvement',
    'personalization_life_event_type_holidays' => 'Holidays',
    'personalization_life_event_type_new_vehicle' => 'New vehicle',
    'personalization_life_event_type_new_roommate' => 'New roommate',
    'personalization_life_event_type_overcame_an_illness' => 'Overcame an illness',
    'personalization_life_event_type_quit_a_habit' => 'Quit a habit',
    'personalization_life_event_type_new_eating_habits' => 'New eating habits',
    'personalization_life_event_type_weight_loss' => 'Weight loss',
    'personalization_life_event_type_wear_glass_or_contact' => 'Started wearing glasses or contacts',
    'personalization_life_event_type_broken_bone' => 'Broke a bone',
    'personalization_life_event_type_removed_braces' => 'Had braces removed',
    'personalization_life_event_type_surgery' => 'Had surgery',
    'personalization_life_event_type_dentist' => 'Had dental treatment',
    'personalization_life_event_type_new_sport' => 'Started playing a new sport',
    'personalization_life_event_type_new_hobby' => 'Took up a new hobby',
    'personalization_life_event_type_new_instrument' => 'Started learning a new instrument',
    'personalization_life_event_type_new_language' => 'Started learning a new language',
    'personalization_life_event_type_tattoo_or_piercing' => 'Tattoo or piercing',
    'personalization_life_event_type_new_license' => 'New license',
    'personalization_life_event_type_travel' => 'Travel',
    'personalization_life_event_type_achievement_or_award' => 'Achievement or award',
    'personalization_life_event_type_changed_beliefs' => 'Changed beliefs',
    'personalization_life_event_type_first_word' => 'First word',
    'personalization_life_event_type_first_kiss' => 'First kiss',

    'storage_title' => 'Storage',
    'storage_account_info' => 'Your account limit is :accountLimit MB. Your current usage is :currentAccountSize MB (about :percentUsage%).',
    'storage_upgrade_notice' => 'Upgrade your account to be able to upload documents and photos.',
    'storage_description' => 'Here you can see all the documents and photos uploaded about your contacts.',

    'dav_title' => 'WebDAV',
    'dav_description' => 'Here you can find all settings to use WebDAV resources for CardDAV and CalDAV exports.',
    'dav_copy_help' => 'Copy into your clipboard',
    'dav_clipboard_copied' => 'Value copied into your clipboard',
    'dav_url_base' => 'Base url for all CardDAV and CalDAV resources:',
    'dav_connect_help' => 'You can connect your contacts and/or calendars with this base url on you phone or computer.',
    'dav_connect_help2' => 'Use your login (email) and create an API token as the password to authenticate.',
    'dav_url_carddav' => 'CardDAV url for Contacts resource:',
    'dav_url_caldav_birthdays' => 'CalDAV url for Birthdays resources:',
    'dav_url_caldav_tasks' => 'CalDAV url for Tasks resources:',
    'dav_title_carddav' => 'CardDAV',
    'dav_title_caldav' => 'CalDAV',
    'dav_carddav_export' => 'Export all contacts in one file',
    'dav_caldav_birthdays_export' => 'Export all birthdays in one file',
    'dav_caldav_tasks_export' => 'Export all tasks in one file',

    'archive_title' => 'Archive all of the contacts in your account',
    'archive_desc' => 'This will archive all of the contacts in your account.',
    'archive_cta' => 'Archive all of your contacts',

    'logs_title' => 'Όλα όσα έχουν συμβεί σε αυτόν τον λογαριασμό',
    'logs_actor' => 'Χρήστης',
    'logs_timestamp' => 'Χρονοσήμανση',
    'logs_description' => 'Περιγραφή',
    'logs_subject' => 'Θέμα',
    'logs_size' => 'Μέγεθος (Kb)',
    'logs_object' => 'Αντικείμενο',
];
