/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring.namespace;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.spring.BeanCreator;
import org.directwebremoting.spring.CreatorConfig;
import org.directwebremoting.spring.namespace.CreatorParserHelper;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RemoteDecorator
extends CreatorParserHelper
implements BeanDefinitionDecorator {
    private static final Log log = LogFactory.getLog(RemoteDecorator.class);

    public BeanDefinitionHolder decorate(Node remoteElement, BeanDefinitionHolder bean, ParserContext parserContext) {
        String name = bean.getBeanName();
        Element element = (Element)remoteElement;
        String javascript = element.getAttribute("javascript");
        BeanDefinitionBuilder beanCreator = BeanDefinitionBuilder.rootBeanDefinition(BeanCreator.class);
        try {
            String beanClassName = this.resolveBeanClassname(bean.getBeanDefinition(), parserContext.getRegistry());
            if (beanClassName == null) {
                throw new FatalBeanException("Unabled to find type for beanName '" + name + "'. " + "Check your bean has a correctly configured parent or provide a class for " + " the bean definition");
            }
            beanCreator.addPropertyValue("beanClass", (Object)ClassUtils.forName((String)beanClassName, (ClassLoader)ClassUtils.getDefaultClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new FatalBeanException("Unable to create DWR bean creator for '" + name + "'.", (Throwable)e);
        }
        if (name.startsWith("scopedTarget.")) {
            name = name.substring(name.indexOf(".") + 1);
        }
        if (!StringUtils.hasText((String)javascript)) {
            javascript = StringUtils.capitalize((String)name);
            if (log.isDebugEnabled()) {
                log.debug((Object)("No javascript name provided. Remoting using bean id [" + javascript + "]"));
            }
        }
        beanCreator.addPropertyValue("beanId", (Object)name);
        beanCreator.addPropertyValue("javascript", (Object)javascript);
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        BeanDefinitionBuilder creatorConfig = BeanDefinitionBuilder.rootBeanDefinition(CreatorConfig.class);
        creatorConfig.addPropertyValue("creator", (Object)beanCreator.getBeanDefinition());
        this.configureCreator(registry, javascript, creatorConfig, remoteElement.getChildNodes());
        this.registerCreator(registry, creatorConfig, javascript);
        return bean;
    }
}

