# has-values [![NPM version](https://img.shields.io/npm/v/has-values.svg?style=flat)](https://www.npmjs.com/package/has-values) [![NPM monthly downloads](https://img.shields.io/npm/dm/has-values.svg?style=flat)](https://npmjs.org/package/has-values) [![NPM total downloads](https://img.shields.io/npm/dt/has-values.svg?style=flat)](https://npmjs.org/package/has-values) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/has-values.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/has-values)

> Returns true if any values exist, false if empty. Works for booleans, functions, numbers, strings, nulls, objects and arrays.

Please consider following this project's author, [Jon Schlinkert](https://github.com/jonschlinkert), and consider starring the project to show your :heart: and support.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save has-values
```

## Usage

```js
const has = require('has-values');
```

Create an `isEmpty` function by returning the inverse of the result from has-values:

```js
const isEmpty = val => !has(val);
```

## Supported types

### Arrays

```js
console.log(has(['a']));      //=> true
console.log(has([0]));        //=> true
console.log(has([[[]]]));     //=> false
console.log(has([[], []]));   //=> false
console.log(has([]));         //=> false
```

### Booleans

```js
console.log(has(true));  //=> true
console.log(has(false)); //=> true
```

### Buffers

```js
console.log(has(new Buffer()));      //=> false
console.log(has(new Buffer('foo'))); //=> true
```

### Dates

Dates are always true.

```js
console.log(has(new Date())); //=> true
```

### Errors

Returns `false` if `err.message` is an empty string.

```js
console.log(has(new Error()));      //=> false
console.log(has(new Error('foo'))); //=> true
```

### Functions

Functions are always true.

```js
console.log(has(function(foo) {})); //=> true
console.log(has(function() {}));    //=> true
```

### Maps

```js
console.log(has(new Map()));                 //=> false
console.log(has(new Map([['foo', 'bar']]))); //=> true
```

### Null

`null` is always true, as it's assumed that this is a user-defined value, versus `undefined` which is not.

```js
console.log(has(null)); //=> true
```

### Objects

```js
console.log(has({})); //=> false
console.log(has({ a: 'a' }}));        //=> true
console.log(has({ foo: undefined })); //=> false
console.log(has({ foo: null }));      //=> true
```

### Numbers

```js
console.log(has(1)); //=> true
console.log(has(0)); //=> true
```

### Regular expressions

```js
console.log(has(new RegExp()));      //=> false
console.log(has(new RegExp('foo'))); //=> true
```

### Sets

```js
console.log(has(new Set()));               //=> false
console.log(has(new Set(['foo', 'bar']))); //=> true
```

### Strings

```js
console.log(has('a')); //=> true
console.log(has(''));  //=> false
```

## Undefined

```js
console.log(has());          //=> false
console.log(has(void 0));    //=> false
console.log(has(undefined)); //=> false
```

## Release history

### v2.0.0

* no longer supports numbers as a string
* optimizations
* adds support for `regex` and `buffer`

### v1.0.0

* adds support for `Map` and `Set`
* `zero` always returns true
* `array` now recurses, so that an array of empty arrays will return `false`
* `null` now returns true

## About

<details>
<summary><strong>Contributing</strong></summary>

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

</details>

<details>
<summary><strong>Running Tests</strong></summary>

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

</details>

<details>
<summary><strong>Building docs</strong></summary>

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

</details>

### Related projects

You might also be interested in these projects:

* [has-value](https://www.npmjs.com/package/has-value): Returns true if a value exists, false if empty. Works with deeply nested values using… [more](https://github.com/jonschlinkert/has-value) | [homepage](https://github.com/jonschlinkert/has-value "Returns true if a value exists, false if empty. Works with deeply nested values using object paths.")
* [is-number](https://www.npmjs.com/package/is-number): Returns true if the value is a number. comprehensive tests. | [homepage](https://github.com/jonschlinkert/is-number "Returns true if the value is a number. comprehensive tests.")
* [is-plain-object](https://www.npmjs.com/package/is-plain-object): Returns true if an object was created by the `Object` constructor. | [homepage](https://github.com/jonschlinkert/is-plain-object "Returns true if an object was created by the `Object` constructor.")
* [isobject](https://www.npmjs.com/package/isobject): Returns true if the value is an object and not an array or null. | [homepage](https://github.com/jonschlinkert/isobject "Returns true if the value is an object and not an array or null.")
* [kind-of](https://www.npmjs.com/package/kind-of): Get the native type of a value. | [homepage](https://github.com/jonschlinkert/kind-of "Get the native type of a value.")

### Author

**Jon Schlinkert**

* [linkedin/in/jonschlinkert](https://linkedin.com/in/jonschlinkert)
* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2018, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on January 30, 2018._