"use strict";

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
module.exports = {
  rootDir: '../',
  setupFiles: ['<rootDir>/test/polyfills.ts', '<rootDir>/test/setupTests.ts'],
  setupFilesAfterEnv: ['<rootDir>/test/setup.jest.ts'],
  roots: ['<rootDir>'],
  coverageDirectory: './coverage',
  moduleNameMapper: {
    '\\.(css|less|scss)$': '<rootDir>/test/mocks/styleMock.ts'
  },
  testEnvironment: 'jest-environment-jsdom',
  coverageReporters: ['lcov', 'text', 'cobertura'],
  testMatch: ['**/*.test.js', '**/*.test.jsx', '**/*.test.ts', '**/*.test.tsx'],
  collectCoverageFrom: ['**/*.ts', '**/*.tsx', '**/*.js', '**/*.jsx', '!**/models/**', '!**/node_modules/**', '!**/index.js', '!<rootDir>/public/app.js', '!<rootDir>/index.js', '!<rootDir>/babel.config.js', '!<rootDir>/test/**', '!<rootDir>/server/**', '!<rootDir>/coverage/**', '!<rootDir>/scripts/**', '!<rootDir>/build/**', '!**/vendor/**'],
  clearMocks: true,
  modulePathIgnorePatterns: ['<rootDir>/offline-module-cache/'],
  testPathIgnorePatterns: ['<rootDir>/build/', '<rootDir>/node_modules/'],
  transformIgnorePatterns: ['<rootDir>/node_modules'],
  globalSetup: '<rootDir>/global-setup.js'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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