"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLQueryBuilder = void 0;

var _ppl_syntax_parser = require("../antlr/ppl_syntax_parser");

var _stats_builder = require("../ast/builder/stats_builder");

var _stats_ast_builder = require("../ast/builder/stats_ast_builder");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class PPLQueryBuilder {
  constructor() {
    _defineProperty(this, "parser", null);
  }

  build(query, pplTokens) {
    this.parser = new _ppl_syntax_parser.PPLSyntaxParser().parse(query);
    return this.buildStats(query, pplTokens);
  }

  buildStats(query, statsTokens) {
    const statsTree = new _stats_ast_builder.StatsAstBuilder().visitRoot(this.parser.root());
    const newStatsAstTree = new _stats_builder.StatsBuilder(statsTokens).build();

    if (typeof statsTree.getStartEndIndicesOfOriginQuery !== 'function') {
      return query + ' | ' + newStatsAstTree.toString();
    }

    const indices = statsTree.getStartEndIndicesOfOriginQuery();

    if (indices.start !== -1 && indices.end !== -1) {
      return query.substring(0, indices.start) + newStatsAstTree.toString() + query.substring(indices.end + 1, query.length);
    } else if (indices && newStatsAstTree) {
      return query + ' | ' + newStatsAstTree.toString();
    }

    return '';
  }

}

exports.PPLQueryBuilder = PPLQueryBuilder;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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