"use strict";

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
// @ts-check
// workaround for Safari support before https://github.com/niklasvh/html2canvas/pull/2911 is merged
const replace = require('replace-in-file');

const options = {
  files: [__dirname + '/../node_modules/html2canvas/**/*.js', __dirname + '/../node_modules/html2canvas/**/*.js.map'],
  from: 'if (image.width === width && image.height === height) {',
  to: 'if (false && image.width === width && image.height === height) {'
};

try {
  const changedFiles = replace.sync(options);
  console.log('Modified files for html2canvas Safari support:\n', changedFiles.filter(file => file.hasChanged).map(file => file.file).join('\n'));
} catch (error) {
  console.error('Error occurred when modifiying files for html2canvas Safari support:', error);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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