"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAuthenticationHandler = getAuthenticationHandler;

var _common = require("../../common");

var _types = require("./types");

/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */
async function createAuthentication(ctor, config, sessionStorageFactory, router, esClient, coreSetup, logger) {
  const authHandler = new ctor(config, sessionStorageFactory, router, esClient, coreSetup, logger);
  await authHandler.init();
  return authHandler;
}

async function getAuthenticationHandler(authType, router, config, core, esClient, securitySessionStorageFactory, logger) {
  let authHandlerType;

  if (typeof authType === 'string' || authType.length === 1) {
    const currType = typeof authType === 'string' ? authType : authType[0];

    switch (currType.toLowerCase()) {
      case '':
      case _common.AuthType.BASIC:
        authHandlerType = _types.BasicAuthentication;
        break;

      case _common.AuthType.JWT:
        authHandlerType = _types.JwtAuthentication;
        break;

      case _common.AuthType.OPEN_ID:
        authHandlerType = _types.OpenIdAuthentication;
        break;

      case _common.AuthType.SAML:
        authHandlerType = _types.SamlAuthentication;
        break;

      case _common.AuthType.PROXY:
        authHandlerType = _types.ProxyAuthentication;
        break;

      default:
        throw new Error(`Unsupported authentication type: ${currType}`);
    }
  } else {
    if (config.auth.multiple_auth_enabled) {
      authHandlerType = _types.MultipleAuthentication;
    } else {
      throw new Error(`Multiple Authentication Mode is disabled. To enable this feature, please set up opensearch_security.auth.multiple_auth_enabled: true`);
    }
  }

  const auth = await createAuthentication(authHandlerType, config, securitySessionStorageFactory, router, esClient, core, logger);
  return auth;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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