/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.grouping.core.summaries;

import com.projectlibre1.algorithm.DoubleValue;
import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.summaries.NumberSummaryVisitor;

public abstract class DivisionSummaryVisitor
extends NumberSummaryVisitor
implements DoubleValue {
    protected double denominator = 0.0;
    private boolean nodeBased = true;

    public DivisionSummaryVisitor(boolean bl) {
        this.nodeBased = bl;
    }

    @Override
    public void execute(Object object) {
        Object object2 = this.nodeBased ? ((Node)object).getImpl() : object;
        this.summary += this.getNumerator(object2);
        this.denominator += this.getDenominator(object2);
    }

    @Override
    public double getValue() {
        if (this.denominator == 0.0) {
            return 0.0;
        }
        return this.summary / this.denominator;
    }

    public abstract double getNumerator(Object var1);

    public abstract double getDenominator(Object var1);

    @Override
    public void reset() {
        super.reset();
        this.denominator = 0.0;
    }

    @Override
    public Object getSummary() {
        return new Double(this.getValue());
    }

    @Override
    public void addToSummary(Object object) {
    }
}

