/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.util.concurrent.ExecutorService;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.DistributedClusterStateUpdater;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.common.SolrCloseable;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.component.ShardHandler;

public class DistributedCollectionCommandContext
implements CollectionCommandContext {
    private final CoreContainer coreContainer;
    private final DistributedClusterStateUpdater getDistributedClusterStateUpdater;
    private final ExecutorService executorService;
    private final SolrCloudManager solrCloudManager;
    private final ZkStateReader zkStateReader;

    public DistributedCollectionCommandContext(CoreContainer coreContainer, ExecutorService executorService) {
        this.coreContainer = coreContainer;
        this.getDistributedClusterStateUpdater = new DistributedClusterStateUpdater(coreContainer.getConfig().getCloudConfig().getDistributedClusterStateUpdates());
        this.executorService = executorService;
        this.solrCloudManager = this.coreContainer.getZkController().getSolrCloudManager();
        this.zkStateReader = this.coreContainer.getZkController().getZkStateReader();
    }

    @Override
    public boolean isDistributedCollectionAPI() {
        return true;
    }

    @Override
    public ShardHandler newShardHandler() {
        return this.coreContainer.getShardHandlerFactory().getShardHandler();
    }

    @Override
    public SolrCloudManager getSolrCloudManager() {
        return this.solrCloudManager;
    }

    @Override
    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    @Override
    public ZkStateReader getZkStateReader() {
        return this.zkStateReader;
    }

    @Override
    public DistributedClusterStateUpdater getDistributedClusterStateUpdater() {
        return this.getDistributedClusterStateUpdater;
    }

    @Override
    public SolrCloseable getCloseableToLatchOn() {
        return this.getSolrCloudManager();
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }
}

