/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.logging;

import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.StringUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.slf4j.MDC;

public class MDCLoggingContext {
    public static final String TRACE_ID = "trace_id";
    private static ThreadLocal<Integer> CALL_DEPTH = ThreadLocal.withInitial(() -> 0);

    public static void setCollection(String collection) {
        if (collection != null) {
            MDC.put((String)"collection", (String)collection);
        } else {
            MDC.remove((String)"collection");
        }
    }

    public static void setTracerId(String traceId) {
        if (!StringUtils.isEmpty((String)traceId)) {
            MDC.put((String)TRACE_ID, (String)traceId);
        } else {
            MDC.remove((String)TRACE_ID);
        }
    }

    public static void setShard(String shard) {
        if (shard != null) {
            MDC.put((String)"shard", (String)shard);
        } else {
            MDC.remove((String)"shard");
        }
    }

    public static void setReplica(String replica) {
        if (replica != null) {
            MDC.put((String)"replica", (String)replica);
        } else {
            MDC.remove((String)"replica");
        }
    }

    public static void setCoreName(String core) {
        if (core != null) {
            MDC.put((String)"core", (String)core);
        } else {
            MDC.remove((String)"core");
        }
    }

    public static void setNode(CoreContainer cc) {
        ZkController zk;
        if (cc != null && (zk = cc.getZkController()) != null) {
            MDCLoggingContext.setNode(zk.getNodeName());
        }
    }

    public static void setNode(String node) {
        int used = CALL_DEPTH.get();
        if (used == 0) {
            MDCLoggingContext.setNodeName(node);
        }
    }

    private static void setNodeName(String node) {
        if (node != null) {
            MDC.put((String)"node_name", (String)node);
        } else {
            MDC.remove((String)"node_name");
        }
    }

    public static String getNodeName() {
        String s = MDC.get((String)"node_name");
        if (s == null) {
            return null;
        }
        if (s.startsWith("n:")) {
            return s.substring(2);
        }
        return null;
    }

    public static void setCore(SolrCore core) {
        CoreContainer coreContainer = core == null ? null : core.getCoreContainer();
        CoreDescriptor coreDescriptor = core == null ? null : core.getCoreDescriptor();
        MDCLoggingContext.setCoreDescriptor(coreContainer, coreDescriptor);
    }

    public static void setCoreDescriptor(CoreContainer coreContainer, CoreDescriptor cd) {
        MDCLoggingContext.setNode(coreContainer);
        int callDepth = CALL_DEPTH.get();
        CALL_DEPTH.set(callDepth + 1);
        if (callDepth > 0) {
            return;
        }
        if (cd != null) {
            assert (cd.getName() != null);
            MDCLoggingContext.setCoreName(cd.getName());
            CloudDescriptor ccd = cd.getCloudDescriptor();
            if (ccd != null) {
                MDCLoggingContext.setCollection(ccd.getCollectionName());
                MDCLoggingContext.setShard(ccd.getShardId());
                MDCLoggingContext.setReplica(ccd.getCoreNodeName());
            }
        }
    }

    public static void clear() {
        int used = CALL_DEPTH.get();
        if (used <= 1) {
            CALL_DEPTH.set(0);
            MDC.remove((String)"collection");
            MDC.remove((String)"core");
            MDC.remove((String)"replica");
            MDC.remove((String)"shard");
        } else {
            CALL_DEPTH.set(used - 1);
        }
    }

    private static void removeAll() {
        MDC.remove((String)"collection");
        MDC.remove((String)"core");
        MDC.remove((String)"replica");
        MDC.remove((String)"shard");
        MDC.remove((String)"node_name");
        MDC.remove((String)TRACE_ID);
    }

    public static void reset() {
        CALL_DEPTH.set(0);
        MDCLoggingContext.removeAll();
    }
}

