/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.NoSuchElementException;
import org.apache.lucene.util.BitUtil;
import org.apache.solr.util.LongIterator;

public class LongSet {
    private static final float LOAD_FACTOR = 0.7f;
    private long[] vals;
    private int cardinality;
    private int mask;
    private int threshold;
    private int zeroCount;

    public LongSet(int sz) {
        sz = Math.max(BitUtil.nextHighestPowerOfTwo((int)sz), 2);
        this.vals = new long[sz];
        this.mask = sz - 1;
        this.threshold = (int)((float)sz * 0.7f);
    }

    public long[] getBackingArray() {
        return this.vals;
    }

    public boolean containsZero() {
        return this.zeroCount != 0;
    }

    public boolean add(long val) {
        if (val == 0L) {
            if (this.zeroCount != 0) {
                return false;
            }
            this.zeroCount = 1;
            return true;
        }
        if (this.cardinality >= this.threshold) {
            this.rehash();
        }
        int h = (int)(val + (val >>> 44) + (val >>> 15));
        int slot = h & this.mask;
        while (true) {
            long v;
            if ((v = this.vals[slot]) == 0L) {
                this.vals[slot] = val;
                ++this.cardinality;
                return true;
            }
            if (v == val) break;
            slot = slot + 1 & this.mask;
        }
        return false;
    }

    private void rehash() {
        long[] oldVals = this.vals;
        int newCapacity = this.vals.length << 1;
        this.vals = new long[newCapacity];
        this.mask = newCapacity - 1;
        this.threshold = (int)((float)newCapacity * 0.7f);
        this.cardinality = 0;
        for (long val : oldVals) {
            if (val == 0L) continue;
            this.add(val);
        }
    }

    public int cardinality() {
        return this.cardinality + this.zeroCount;
    }

    public LongIterator iterator() {
        return new LongIterator(){
            private int remainingValues;
            private int valsIdx;
            {
                this.remainingValues = LongSet.this.cardinality();
                this.valsIdx = 0;
            }

            @Override
            public boolean hasNext() {
                return this.remainingValues > 0;
            }

            @Override
            public long next() {
                long value;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                --this.remainingValues;
                if (this.remainingValues == 0 && LongSet.this.zeroCount > 0) {
                    return 0L;
                }
                while ((value = LongSet.this.vals[this.valsIdx++]) == 0L) {
                }
                return value;
            }
        };
    }
}

