/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels.store;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.nodelabels.store.op.AddClusterLabelOp;
import org.apache.hadoop.yarn.nodelabels.store.op.AddNodeToAttributeLogOp;
import org.apache.hadoop.yarn.nodelabels.store.op.FSNodeStoreLogOp;
import org.apache.hadoop.yarn.nodelabels.store.op.NodeAttributeMirrorOp;
import org.apache.hadoop.yarn.nodelabels.store.op.NodeLabelMirrorOp;
import org.apache.hadoop.yarn.nodelabels.store.op.NodeToLabelOp;
import org.apache.hadoop.yarn.nodelabels.store.op.RemoveClusterLabelOp;
import org.apache.hadoop.yarn.nodelabels.store.op.RemoveNodeToAttributeLogOp;
import org.apache.hadoop.yarn.nodelabels.store.op.ReplaceNodeToAttributeLogOp;

public class FSStoreOpHandler {
    private static Map<StoreType, Map<Integer, Class<? extends FSNodeStoreLogOp>>> editLogOp = new HashMap<StoreType, Map<Integer, Class<? extends FSNodeStoreLogOp>>>();
    private static Map<StoreType, Class<? extends FSNodeStoreLogOp>> mirrorOp = new HashMap<StoreType, Class<? extends FSNodeStoreLogOp>>();

    private static void registerMirror(StoreType type, Class<? extends FSNodeStoreLogOp> clazz) {
        mirrorOp.put(type, clazz);
    }

    private static void registerLog(StoreType type, int opcode, Class<? extends FSNodeStoreLogOp> clazz) {
        Map<Integer, Class<? extends FSNodeStoreLogOp>> ops = editLogOp.get((Object)type);
        Integer code = opcode;
        if (ops == null) {
            HashMap<Integer, Class<? extends FSNodeStoreLogOp>> newOps = new HashMap<Integer, Class<? extends FSNodeStoreLogOp>>();
            newOps.put(code, clazz);
            editLogOp.put(type, newOps);
        } else {
            ops.put(code, clazz);
        }
    }

    public static FSNodeStoreLogOp getMirrorOp(StoreType storeType) {
        return FSStoreOpHandler.newInstance(mirrorOp.get((Object)storeType));
    }

    public static FSNodeStoreLogOp get(int opCode, StoreType storeType) {
        return FSStoreOpHandler.newInstance(editLogOp.get((Object)storeType).get(opCode));
    }

    private static <T extends FSNodeStoreLogOp> T newInstance(Class<T> clazz) {
        FSNodeStoreLogOp instance = null;
        if (clazz != null) {
            try {
                instance = (FSNodeStoreLogOp)clazz.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to instantiate " + clazz, ex);
            }
        }
        return (T)instance;
    }

    static {
        FSStoreOpHandler.registerLog(StoreType.NODE_LABEL_STORE, 0, AddClusterLabelOp.class);
        FSStoreOpHandler.registerLog(StoreType.NODE_LABEL_STORE, 1, NodeToLabelOp.class);
        FSStoreOpHandler.registerLog(StoreType.NODE_LABEL_STORE, 2, RemoveClusterLabelOp.class);
        FSStoreOpHandler.registerLog(StoreType.NODE_ATTRIBUTE, 0, AddNodeToAttributeLogOp.class);
        FSStoreOpHandler.registerLog(StoreType.NODE_ATTRIBUTE, 1, RemoveNodeToAttributeLogOp.class);
        FSStoreOpHandler.registerLog(StoreType.NODE_ATTRIBUTE, 2, ReplaceNodeToAttributeLogOp.class);
        FSStoreOpHandler.registerMirror(StoreType.NODE_LABEL_STORE, NodeLabelMirrorOp.class);
        FSStoreOpHandler.registerMirror(StoreType.NODE_ATTRIBUTE, NodeAttributeMirrorOp.class);
    }

    public static enum StoreType {
        NODE_LABEL_STORE,
        NODE_ATTRIBUTE;

    }
}

