/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.simple;

import java.io.Serializable;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.Type;
import org.opengis.util.TypeName;

public final class SimpleAttributeType<V>
implements Type,
Serializable {
    private static final long serialVersionUID = -4130729627352535488L;
    private final TypeName name;
    private final Class<V> valueClass;

    public SimpleAttributeType(TypeName typeName, Class<V> clazz) {
        this.name = typeName;
        this.valueClass = clazz;
    }

    public GenericName getName() {
        return this.name;
    }

    public TypeName getTypeName() {
        return this.name;
    }

    public Class<V> getValueClass() {
        return this.valueClass;
    }

    public int getMinimumOccurs() {
        return 1;
    }

    public int getMaximumOccurs() {
        return 1;
    }

    public V getDefaultValue() {
        return null;
    }

    public InternationalString getDefinition() {
        return null;
    }

    public InternationalString getDesignation() {
        return null;
    }

    public InternationalString getDescription() {
        return null;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.valueClass.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SimpleAttributeType) {
            SimpleAttributeType simpleAttributeType = (SimpleAttributeType)object;
            return this.name.equals((Object)simpleAttributeType.name) && this.valueClass.equals(simpleAttributeType.valueClass);
        }
        return false;
    }

    public String toString() {
        return this.name.toFullyQualifiedName().toString();
    }
}

