/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu;

import com.ibm.icu.text.FilteredNormalizer2;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.UnicodeSet;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.icu.ICUNormalizer2Filter;

public class ICUNormalizer2FilterFactory
extends TokenFilterFactory {
    public static final String NAME = "icuNormalizer2";
    private final Normalizer2 normalizer;

    public ICUNormalizer2FilterFactory(Map<String, String> args) {
        super(args);
        UnicodeSet set;
        String form = this.get(args, "form", "nfkc_cf");
        String mode = this.get(args, "mode", Arrays.asList("compose", "decompose"), "compose");
        Normalizer2 normalizer = Normalizer2.getInstance(null, (String)form, (Normalizer2.Mode)("compose".equals(mode) ? Normalizer2.Mode.COMPOSE : Normalizer2.Mode.DECOMPOSE));
        String filter = this.get(args, "filter");
        if (filter != null && !(set = new UnicodeSet(filter)).isEmpty()) {
            set.freeze();
            normalizer = new FilteredNormalizer2(normalizer, set);
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
        this.normalizer = normalizer;
    }

    public ICUNormalizer2FilterFactory() {
        throw ICUNormalizer2FilterFactory.defaultCtorException();
    }

    public TokenStream create(TokenStream input) {
        return new ICUNormalizer2Filter(input, this.normalizer);
    }

    public TokenStream normalize(TokenStream input) {
        return this.create(input);
    }
}

